/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for sen_ctx
 */
public class SennaContext {
    /* C pointer to sen_ctx */
    private int sen_ctx_ptr;

    /* C pointer to space */
    private int space_ptr;

    /**
     * call sen_ctx_init().
     *
     * @throws SennaException
     */
    private native void init(int flags, int encoding) throws SennaException;

    /**
     * call sen_ctx_fin().
     *
     * @throws SennaException
     */
    private native void fin() throws SennaException;

    /**
     * call sen_ctx_fin().
     *
     * @throws SennaException
     */
    protected void finalize() throws SennaException {
	fin();
    }

    /**
     * <pre>
     *  call sen_ctx_init() with below values.
     *  flags: SEN_CTX_USE_DB
     *  encoding: SEN_ENC_DEFAULT
     * </pre>
     *
     * @throws SennaException
     */
    public SennaContext() throws SennaException {
	init(Senna.SEN_CTX_USE_DB, Senna.SEN_ENC_DEFAULT);
    }

    /**
     * <pre>
     *  call sen_ctx_init() with below values.
     *  flags: SEN_CTX_USE_DB
     * </pre>
     *
     * @param encoding
     *            default encoding for this context
     * @throws SennaException
     */
    public SennaContext(int encoding) throws SennaException {
	init(Senna.SEN_CTX_USE_DB, encoding);
    }

    /**
     * call sen_ctx_init().
     *
     * @param flags
     *            context flags
     * @param encoding
     *            default encoding for this context
     * @throws SennaException
     */
    public SennaContext(int flags, int encoding) throws SennaException {
	init(flags, encoding);
    }

    /**
     * call sen_ctx_use().
     *
     * @param space
     *            space
     * @throws SennaException
     */
    public native void use(Space space) throws SennaException;

    /**
     * call sen_ctx_space().
     *
     * @return current space
     * @throws SennaException
     */
    public native Space getSpace() throws SennaException;

    /**
     * call sen_ctx_lookup().
     *
     * @param name
     *            object name
     * @return matched senna object
     * @throws SennaException
     */
    public native SennaObject lookup(String name) throws SennaException;

    /**
     * call sen_ctx_get().
     *
     * @param sen_id sen_id
     * @return matched senna object
     * @throws SennaException
     */
    public native SennaObject get(int sen_id) throws SennaException;


}
