/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for sen_obj
 */
public abstract class SennaObject {
    /**
     * call sen_obj_remove().
     *
     * @param path
     * @throws SennaException
     */
    public native void remove(String path) throws SennaException;

    /**
     * call sen_obj_rename().
     *
     * @param old_path
     * @param new_path
     * @throws SennaException
     */
    public native void rename(String old_path, String new_path) throws SennaException;

    /**
     * call sen_obj_close().
     *
     * @throws SennaException
     */
    public native void close() throws SennaException;

    /**
     * call sen_obj_path().
     *
     * @return path
     * @throws SennaException
     */
    public native String getPath() throws SennaException;

    /**
     * call sen_obj_name().
     *
     * @return name
     * @throws SennaException
     */
    public native String getName() throws SennaException;

    /**
     * call sen_obj_expire().
     *
     * @param threshold
     * @throws SennaException
     */
    public native void expire(int threshold) throws SennaException;

    /**
     * call sen_obj_check().
     *
     * @return status
     * @throws SennaException
     */
    public native int check() throws SennaException;

    /**
     * call sen_obj_lock().
     *
     * @param timeout
     * @throws SennaException
     */
    public native void lock(int timeout) throws SennaException;

    /**
     * call sen_obj_unlock().
     *
     * @throws SennaException
     */
    public native void unlock() throws SennaException;

    /**
     * call sen_obj_clear_lock().
     *
     * @throws SennaException
     */
    public native void clearLock() throws SennaException;

    /**
     * call sen_obj_is_locked().
     *
     * @return true if object is locked
     * @throws SennaException
     */
    public native boolean isLocked() throws SennaException;

    /**
     * call sen_obj_space().
     *
     * @return space
     * @throws SennaException
     */
    public native Space getSpace() throws SennaException;
}
