/*
 * Copyright(C) 2008 Tetsuro IKEDA <ikdttr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include "senna_java.h"
#include "senna_SennaLogger.h"

static const char* log_file_path;
static int log_level;
static FILE *fp = NULL;

void senna_logger_func(int level, const char *time, const char *title,
                       const char *msg, const char *location, void *func_arg)
{
  const char slev[] = " EACewnid-";
  if (fp)
  {
    fprintf(fp, "%s|%c|%s %s %s\n", time, *(slev + log_level), title, msg, location);
      fflush(fp);
  }
}

sen_logger_info senna_logger = {
  sen_log_notice,
  SEN_LOG_TIME|SEN_LOG_MESSAGE,
  senna_logger_func,
  NULL
};

/*
 * Class:     senna_SennaLogger
 * Method:    open
 * Signature: (Ljava/lang/String;I)V
 */
JNIEXPORT void JNICALL
Java_senna_SennaLogger_open(JNIEnv *env, jclass clazz, jstring path_str, jint level)
{
  if (!fp)
  {
    log_file_path = (*env)->GetStringUTFChars(env, path_str, NULL);
    fp = fopen(log_file_path, "a");
    (*env)->ReleaseStringUTFChars(env, path_str, log_file_path);
  }

  log_level = level;
  senna_logger.max_level = (sen_log_level) log_level;
  sen_logger_info_set(&senna_logger);
}

/*
 * Class:     senna_SennaLogger
 * Method:    close
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_senna_SennaLogger_close(JNIEnv *env, jclass clazz)
{
  if (fp)
  {
    fclose(fp);
    fp = NULL;
  }
}

/*
 * Class:     senna_SennaLogger
 * Method:    getLevel
 * Signature: ()I
 */
JNIEXPORT jint JNICALL
Java_senna_SennaLogger_getLevel(JNIEnv *env, jclass clazz)
{
  return (jint) log_level;
}

/*
 * Class:     senna_SennaLogger
 * Method:    setLevel
 * Signature: (I)V
 */
JNIEXPORT void JNICALL
Java_senna_SennaLogger_setLevel(JNIEnv *env, jclass clazz, jint level)
{
  log_level = level;
  senna_logger.max_level = (sen_log_level) log_level;
}

/*
 * Class:     senna_SennaLogger
 * Method:    write
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL
Java_senna_SennaLogger_write(JNIEnv *env, jclass clazz,
			     jint level, jstring str)
{
  char buf[1024];
  const char *msg;
  msg = (*env)->GetStringUTFChars(env, str, NULL);
  strncpy(buf, msg, 1024);
  SEN_LOG((sen_log_level) level, buf);
  (*env)->ReleaseStringUTFChars(env, str, msg);
}
