/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

import junit.framework.TestCase;

public class IndexTest extends TestCase {

    public IndexTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Senna.init();
	SennaLogger.open("senna.log",Senna.SEN_LOG_DEBUG);
    }

    protected void tearDown() throws Exception {
	SennaLogger.close();
        Senna.fin();
    }

    public void testCreate() throws Exception {
	SennaLogger.write(Senna.SEN_LOG_DEBUG, "=== IndexTest#testCreate() ===");
        // create
        Index index = Index.create("tests/testindex");
        assertNotNull(index);
        index.printInfo();
        index.close();
        // rename
        Index.rename("tests/testindex", "tests/testrename");
        // then open
        index = new Index("tests/testrename");
        assertNotNull(index);
        index.close();
        // remove
        Index.remove("tests/testrename");
    }

    public void testInsert() throws Exception {
	SennaLogger.write(Senna.SEN_LOG_DEBUG, "=== IndexTest#testInsert() ===");
	Index index = Index.create("tests/testindex",0,0,0,Senna.SEN_ENC_UTF8);
        index.insert("ほげ", "東京都");
        index.printInfo();
        Records records = index.sel("東京");
        assertNotNull(records);
        assertEquals(1, records.nhits());
        String key = records.next();
        assertEquals("ほげ", key);
        key = records.next();
        assertNull(key);
        records.close();

        index.upd("ほげ", "東京都", "京都");
        records = index.sel("東京");
        assertNull(records);

        records = index.sel("京都");
        assertNotNull(records);
        assertEquals(1, records.nhits());
        key = records.next();
        assertEquals("ほげ", key);
        records.close();

        index.delete("ほげ", "京都");
        records = index.sel("京都");
        assertNull(records);
        index.close();
        Index.remove("tests/testindex");
    }

}

