package noguchi.SentenceLearner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.os.Environment;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.RatingBar;
import android.widget.Toast;

public class SoundViewer extends Activity
implements CheckedListListener,
Button.OnClickListener
{

	// DB object
	private DatabaseHelper helper;
	private SQLiteDatabase db;

	// GUI components
	ListView listView; // Category List
	Button toggleButton;
	Button startButton;

	// For menu
	private static final int MENU_ID_MENU1 = (Menu.FIRST + 1);
	private static final int MENU_ID_MENU2 = (Menu.FIRST + 2);
	private static final int MENU_ID_MENU3 = (Menu.FIRST + 3);
	private static final int MENU_ID_MENU4 = (Menu.FIRST + 4);

	// Return from intents
	private static final int SOUNDSELECTOR = 0;
	private static final int QUESTIONCREATOR = 1;
	private static final int QUESTIONVIEWER = 2;

	private List<ListItem> list = null;
	private boolean allSelected = true;
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		// Create the database (if not exist yet)
		helper = new DatabaseHelper(this);
		db = helper.getReadableDatabase();

		// Create GUI component objects
		listView = (ListView)findViewById(R.id.CategoryListView);
		toggleButton = (Button)findViewById(R.id.btnToggle);
		startButton = (Button)findViewById(R.id.btnStart);
		updatSoundList();

		// Register listeners
		toggleButton.setOnClickListener(this);
		startButton.setOnClickListener(this);
	}

	private void updatSoundList() {
		try {
			list = helper.getSounds(db);
			CheckedListAdapter adapter = new CheckedListAdapter(getApplicationContext(),list, allSelected, this);
			listView.setAdapter(adapter);    		
		}
		catch (Exception ex)
		{
			Toast.makeText(SoundViewer.this, getResources().getString(R.string.DBFailed), Toast.LENGTH_SHORT).show();
		}
	}

	//
	// CallBack method which is called when the control is back to this window
	//
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		// If return from SoundSelector window
		if (requestCode == SOUNDSELECTOR) {
			if (resultCode == RESULT_OK) {
				updatSoundList();
			}
		}
	}

	// Handling a menu
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Add menus
		menu.add(Menu.NONE, MENU_ID_MENU1, Menu.NONE, getResources().getString(R.string.AddSoundMenu));
		menu.add(Menu.NONE, MENU_ID_MENU2, Menu.NONE, getResources().getString(R.string.RemoveDatabaseMenu));
		menu.add(Menu.NONE, MENU_ID_MENU3, Menu.NONE, getResources().getString(R.string.ExportData));
		menu.add(Menu.NONE, MENU_ID_MENU4, Menu.NONE, getResources().getString(R.string.ImportData));
		return super.onCreateOptionsMenu(menu);
	}
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		boolean ret = true;
		Intent intent;
		Builder alertDialogBuilder;
		switch (item.getItemId()) {
		default:
			ret = super.onOptionsItemSelected(item);
			break;
		case MENU_ID_MENU1:
			intent = new Intent(SoundViewer.this, SoundSelector.class);
			startActivityForResult(intent,SOUNDSELECTOR);
			ret = true;
			break;
		case MENU_ID_MENU2:
			// Remove database after showing alarm
			alertDialogBuilder = new AlertDialog.Builder(this);
			alertDialogBuilder.setTitle(getResources().getString(R.string.RemoveDatabase));
			alertDialogBuilder.setMessage(getResources().getString(R.string.AreYouSureToProceed));
			alertDialogBuilder.setPositiveButton(getResources().getString(R.string.Yes),
					new DialogInterface.OnClickListener() {
				@Override
				public void onClick(DialogInterface dialog, int which) {

					final ProgressDialog progressDialog = new ProgressDialog(SoundViewer.this);
					progressDialog.setIndeterminate(true);
					progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
					progressDialog.setMessage(getResources().getString(R.string.RemovingDatabase));
					progressDialog.show();

					new Thread(){
						@Override
						public void run(){
							helper.onUpgrade(db,0,0);
							runOnUiThread(new Runnable(){
								@Override
								public void run(){
									progressDialog.dismiss();
									updatSoundList();
								}
							});
						}
					}.start();        			
				}
			});
			alertDialogBuilder.setNegativeButton(getResources().getString(R.string.No),
					new DialogInterface.OnClickListener() {
				@Override
				public void onClick(DialogInterface dialog, int which) {
					// Do nothing
				}
			});
			alertDialogBuilder.setCancelable(true);
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
			break;     
		case MENU_ID_MENU3:
			exportData();        	
			break;
		case MENU_ID_MENU4:
			importData();
			break;
		}
		return ret;
	}

	@Override
	public void OnCheckedListClick(ListItem item) {
		try {
			SoundItem soundItem = (SoundItem)item;
			if (soundItem.IsInitialise() == 0){
				//TODO
				//Toast.makeText(SoundViewer.this, "<TEST>SoundItem initialised", Toast.LENGTH_SHORT).show();
				//soundItem.setInitialise(1);
				//helper.updateSoundItem(soundItem, db);
				Intent intent = new Intent(SoundViewer.this, QuestionCreator.class);
				intent.putExtra("NAME", soundItem.getName());
				intent.putExtra("FILENAME", soundItem.getFileName());
				startActivityForResult(intent,QUESTIONCREATOR);
			}
		}
		catch (Exception ex){
			Toast.makeText(SoundViewer.this, getResources().getString(R.string.DBFailed), Toast.LENGTH_SHORT).show();
		}
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		if (v == toggleButton)
		{
			allSelected = (allSelected == false);
			updatSoundList();
		}
		else if (v == startButton)
		{
			//TODO
			if (list != null)
			{
				// Show AlertDialog which specifies the rating
				AlertDialog.Builder alertDialogBuilder;
				final RatingBar r = new RatingBar(this);

				alertDialogBuilder = new AlertDialog.Builder(this);
				alertDialogBuilder.setTitle(getResources().getString(R.string.SetRating));
				alertDialogBuilder.setMessage("");
				alertDialogBuilder.setView(r);	        	
				alertDialogBuilder.setPositiveButton(getResources().getString(R.string.Ok),
						new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						int rating = (int)r.getRating();
						showQuestions(rating);
					}
				});

				alertDialogBuilder.setCancelable(true);
				AlertDialog alertDialog = alertDialogBuilder.create();
				alertDialog.show();
			}
		}
	}

	private void showQuestions(int rating)
	{
		ArrayList<String> targets = new ArrayList<String>();
		for (int i = 0 ; i < list.size() ; i++)
		{
			SoundItem item = (SoundItem) list.get(i);

			if (list.get(i).isChecked())
			{
				targets.add(((SoundItem) list.get(i)).getFileName());
				item.setInitialise(2);  // Not good. 2 is the magic number which means that this item is the current position...
			}
			else
			{
				item.setInitialise(0);					
			}

			try 
			{
				helper.updateSoundItemIsInitialise(item, db);
			}
			catch (Exception ex)
			{
			}	
		}
		String[] targetStrings = (String[])targets.toArray(new String[0]);

		Intent intent = new Intent(SoundViewer.this, QuestionViewer.class);
		intent.putExtra("TARGETS", targetStrings);
		intent.putExtra("RATING", rating);
		startActivityForResult(intent,QUESTIONVIEWER);
	}

	private void exportData()
	{
		// Export to file menu

		Builder alertDialogBuilder;

		final EditText edit = new EditText(this);
		edit.setWidth(50);
		File file = Environment.getExternalStorageDirectory(); 
		edit.setText(file.getPath() + "/");

		alertDialogBuilder = new AlertDialog.Builder(this);
		alertDialogBuilder.setTitle(getResources().getString(R.string.ExportData));
		alertDialogBuilder.setMessage(getResources().getString(R.string.InputFolderName));
		alertDialogBuilder.setView(edit);
		alertDialogBuilder.setPositiveButton(getResources().getString(R.string.OK), new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {

				final ProgressDialog progressDialog = new ProgressDialog(SoundViewer.this);
				progressDialog.setIndeterminate(true);
				progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
				progressDialog.setMessage(getResources().getString(R.string.ExportData));
				progressDialog.show();

				new Thread(){
					@Override
					public void run(){
						// Get input filename
						CharSequence fullPath = edit.getText();

						try {
							helper.ExportData(db, fullPath.toString());
						}
						catch (Exception e){
							Toast.makeText(SoundViewer.this, getResources().getString(R.string.ExportFailed), Toast.LENGTH_SHORT).show();
						}
						finally {
							runOnUiThread(new Runnable(){
								@Override
								public void run(){
									progressDialog.dismiss();
								}
							});
						}
					}
				}.start();
			}
		});
		alertDialogBuilder.setNegativeButton(getResources().getString(R.string.Cancel), new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
				// Canceled.
			}
		});
		alertDialogBuilder.show();

	}

	private void importData()
	{
		// Import from file menu

		Builder alertDialogBuilder;

		final EditText edit = new EditText(this);
		edit.setWidth(50);
		File file = Environment.getExternalStorageDirectory(); 
		edit.setText(file.getPath() + "/");

		alertDialogBuilder = new AlertDialog.Builder(this);
		alertDialogBuilder.setTitle(getResources().getString(R.string.ImportData));
		alertDialogBuilder.setMessage(getResources().getString(R.string.InputFolderName));
		alertDialogBuilder.setView(edit);
		alertDialogBuilder.setPositiveButton(getResources().getString(R.string.OK), new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {

				final ProgressDialog progressDialog = new ProgressDialog(SoundViewer.this);
				progressDialog.setIndeterminate(true);
				progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
				progressDialog.setMessage(getResources().getString(R.string.ExportData));
				progressDialog.show();

				new Thread(){
					@Override
					public void run(){
						// Get input filename
						CharSequence fullPath = edit.getText();

						try {
							helper.ImportData(db, fullPath.toString());
						}
						catch (Exception e){
							Toast.makeText(SoundViewer.this, getResources().getString(R.string.ImportFailed), Toast.LENGTH_SHORT).show();
						}
						finally {
							runOnUiThread(new Runnable(){
								@Override
								public void run(){
									progressDialog.dismiss();
									updatSoundList();
								}
							});
						}
					}
				}.start();
			}
		});
		alertDialogBuilder.setNegativeButton(getResources().getString(R.string.Cancel), new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
				// Canceled.
			}
		});
		alertDialogBuilder.show();

	}

}

