// Draw.h : CCanvas ̐錾

#pragma once

#include "resource.h"       // C V{
#include "layer.h"

/////////////////////////////////////////////////////////////////////////////
// CCanvas

#define MAXLAYER 256

class ATL_NO_VTABLE CCanvas :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CCanvas, &CLSID_Canvas>,
	public ISupportErrorInfoImpl<&IID_ICanvas>,
	public IConnectionPointContainerImpl<CCanvas>,
	public IDispatchImpl<ICanvas, &IID_ICanvas, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	HRESULT FinalConstruct();

	void CCanvas::FinalRelease();

	DECLARE_REGISTRY_RESOURCEID(IDR_CANVAS)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CCanvas)
		COM_INTERFACE_ENTRY(ICanvas)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(IConnectionPointContainer)
	END_COM_MAP()
	BEGIN_CONNECTION_POINT_MAP(CCanvas)
	END_CONNECTION_POINT_MAP()


	// ICanvas
public:
	STDMETHOD(LoadPicture)(/*[in]*/VARIANT path,/*[out,retval]*/VARIANT* punkVal);
	void AttachOwner(HWND hParent);
	void DetachOwner();
	void Draw(HDC hdc, RECT& rt);
	STDMETHOD(get_Layer)(/*[in]*/VARIANT varLay, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(Print)();
	STDMETHOD(GetPrinterDefault)(/*[in,optional]*/VARIANT name);
	STDMETHOD(get_MarginHeight)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_MarginHeight)(/*[in]*/ long newVal);
	STDMETHOD(get_MarginWidth)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_MarginWidth)(/*[in]*/ long newVal);
	STDMETHOD(PrintAs)(/*[in,optional]*/VARIANT print,/*[oute,retval]*/VARIANT* pRet);
protected:
	CComObject<CLayer>* m_pComLayer[MAXLAYER];
	TCHAR m_szPrinterName[MAX_PATH];
	DEVMODE* m_pPrinterDeviceMode;
	long m_marginHeight;
	long m_marginWidth;
	BOOL PrintCore(CDC dc);
	HWND m_hParent;
};
