#! /usr/bin/python2.7
'''
Created on 2015/07/19
for Python2.7

@author: seraphy
'''

from HTMLParser import HTMLParser

class MyHTMLParser(HTMLParser):

    sitemapAttr = ('type', 'text/sitemap')

    beginBody = False

    sitemapMode = False
    sitemapTitle = ''
    sitemapUrl = ''

    def handle_starttag(self, tag, attrs):
        if not self.beginBody:
            if tag == 'body':
                self.wr.write('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">\r\n');
                self.wr.write('<html><head>\r\n');
                self.wr.write('<meta http-equiv="Content-Type" content="text/html; charset=Windows-31J">\r\n')
                self.wr.write('<meta http-equiv="Content-Language" content="ja-JP">\r\n')
                self.wr.write('<link href="sidemenu.css" rel="stylesheet" type="text/css" media="screen" >\r\n')
                self.wr.write('<title>SeraphyScriptDialog Help</title>\r\n');
                self.wr.write('<base target="main"/>\r\n');
                self.wr.write('<body>\r\n');
                self.beginBody = True
            return

        if tag == 'object':
            if [x for x in attrs if x == self.sitemapAttr]:
                self.sitemapMode = True
        elif tag == 'param' and self.sitemapMode:
            paramType = [x[1] for x in attrs if x[0] == 'name']
            paramValue = [x[1] for x in attrs if x[0] == 'value']
            # print("*param name={0} value={1}".format(paramType, paramValue))

            if paramType == ['Name']:
                self.sitemapTitle = paramValue[0]
            elif paramType == ['Local']:
                self.sitemapUrl = paramValue[0]
            else:
                raise Exception('unknown attrs:{0}'.format(attrs))

        else:
            self.wr.write("<{0}>".format(tag))

    def handle_endtag(self, tag):
        if not self.beginBody:
            return

        if tag == 'object':
            if self.sitemapMode:
                if len(self.sitemapUrl) > 0:
                    self.wr.write("<a href='{1}'>{0}</a>".format(self.sitemapTitle, self.sitemapUrl.replace('\\', '/')))
                else:
                    self.wr.write("{0}".format(self.sitemapTitle))

                self.sitemapMode = False
                self.sitemapTitle = ''
                self.sitemapUrl = ''

        elif tag == 'param' and self.sitemapMode:
            pass
        else:
            self.wr.write("</{0}>\r\n".format(tag))

def main():
    with open('seraphyscripttools.hhc', 'r') as f:
        text = f.read()

    with open('sidemenu.html', 'w') as wr:
        parser = MyHTMLParser()
        parser.wr = wr
        parser.feed(text)

    print("ok");

if __name__ == '__main__':
    main()
