// ObjectMap.cpp : CObjectMap ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "ObjectMap.h"
#include "generic.h"
#include "profilesection.h"
#include "CComEnumDynaVARIANT.h"

#include <vector>

/////////////////////////////////////////////////////////////////////////////
// CObjectMap

STDMETHODIMP CObjectMap::FindNear(VARIANT key, VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	::VariantInit(pVal);

	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.lower_bound(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		// ꂽ
		CComVariant findkey((LPCWSTR)p->first);
		findkey.ChangeType(VT_BSTR);
		return findkey.Detach(pVal);
	}
	return S_FALSE;
}

STDMETHODIMP CObjectMap::get_NearValue(VARIANT key, VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	::VariantInit(pVal);

	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.lower_bound(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		// ꂽ
		return VariantCopy(pVal, &p->second);
	}
	return S_FALSE;
}

STDMETHODIMP CObjectMap::get_Value(VARIANT key, VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	::VariantInit(pVal);

	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		// ꂽ
		return VariantCopy(pVal, &p->second);
	}

	// Ȃ
	return S_FALSE;
}

STDMETHODIMP CObjectMap::put_Value(VARIANT key, VARIANT newVal)
{
	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	// ByRefByValɕϊRs[
	CComVariant tmp;
	if (FAILED(hr = VariantCopyByVal(&tmp, &newVal))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		// 
		p->second = tmp;
	}
	else {
		// VK
		m_mapVariant.insert(std::make_pair(varName.bstrVal, tmp));
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::get_Count(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	*pVal = m_mapVariant.size();
	return S_OK;
}

STDMETHODIMP CObjectMap::Clear()
{
	//VARIANT̃NAƘAzz̉
	VariantMap::iterator p = m_mapVariant.begin();
	while (p != m_mapVariant.end()) {
		p->second.Clear();
		p++;
	}
	m_mapVariant.clear();
	return S_OK;
}


STDMETHODIMP CObjectMap::Duplicate(IUnknown** punkVal)
{
	if (!punkVal) {
		return E_POINTER;
	}
	*punkVal = NULL;

	CComObject<CObjectMap>* pMap = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&pMap))) {
		return hr;
	}

	// ݂̃IuWFNg𕡐
	VariantMap::iterator p = m_mapVariant.begin();
	while (p != m_mapVariant.end()) {
		CComVariant key(p->first);
		key.ChangeType(VT_BSTR);
		pMap->put_Value(key, p->second);
		p++;
	}

	return pMap->QueryInterface(punkVal);
}

STDMETHODIMP CObjectMap::CreateMap(IUnknown** punkVal)
{
	if (!punkVal) {
		return E_POINTER;
	}
	*punkVal = NULL;

	CComObject<CObjectMap>* pMap = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&pMap))) {
		return hr;
	}

	return pMap->QueryInterface(punkVal);
}

STDMETHODIMP CObjectMap::get__NewEnum(IUnknown **pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	int mx = m_mapVariant.size();
	std::vector<CComVariant> pvarArray;
	pvarArray.resize(mx + 1);

	// i[Ă閼O̗
	VariantMap::iterator p = m_mapVariant.begin();
	int i = 0;
	while (p != m_mapVariant.end()) {
		pvarArray[i] = p->first;
		p++;
		i++;
	}

	// 񋓃C^[tFCX̐
	HRESULT hr;
	CComObject<CComEnumVARIANT>* pCol = NULL;
	if (FAILED(hr = CComObject<CComEnumVARIANT>::CreateInstance(&pCol))) {
		return hr;
	}
	pCol->Init(&pvarArray[0], &pvarArray[mx], pCol, AtlFlagCopy);

	return pCol->QueryInterface(pVal);
}

STDMETHODIMP CObjectMap::ExpandVariables(VARIANT text, VARIANT env, VARIANT *pVal)
{
	CComVariant varText, varEnv, varResult;

	HRESULT hr;
	if (FAILED(hr = varText.ChangeType(VT_BSTR, &text))) {
		return hr;
	}

	// ϐWJ邩?
	BOOL bEnv = false;
	if (SUCCEEDED(varEnv.ChangeType(VT_I2, &env))) {
		bEnv = varEnv.iVal;
	}

	// tF[Y1 : ܂܂ϐ𒲍ĕKvȃobt@TCY߂
	// tF[Y2 ; ۂɓWJ
	DWORD expandsize = 0;
	UINT writeidx = 0;
	LPWSTR pExpandBuffer = NULL;
	for (int phase = 0; phase < 2; phase++) {
		LPCWSTR str = varText.bstrVal;
		UINT length = SysStringLen(varText.bstrVal);
		UINT idx = 0;
		while (idx < length) {
			if (str[idx] == '%') {
				// ϐWJX^[g
				WCHAR name[MAX_PATH] = {0};
				UINT len = 0;
				// A%ɂ%g̏o͂ł邩?
				idx++;
				if (str[idx] == '%') {
					if (phase == 0) {
						idx++;
					}
					else {
						pExpandBuffer[writeidx++] = str[idx++];
					}
					continue;
				}
				// ϐ̎o
				while (idx < length && str[idx] != '%') {
					name[len++] = str[idx++];
				}
				name[len] = 0;
				if (str[idx] == '%') {
					idx++;
				}
				// ϐ̎݃`FbN
				VariantMap::iterator p = m_mapVariant.find(name);
				if (p != m_mapVariant.end()) {
					// ꂽ
					CComVariant tmp;
					if (SUCCEEDED(tmp.ChangeType(VT_BSTR, &p->second))) {
						if (phase == 0) {
							// tF[Y1̓TCYJEg邾
							expandsize += SysStringLen(tmp.bstrVal);
						}
						else {
							// tF[Y2݈͌ʒuɕϐWJ
							UINT len = SysStringLen(tmp.bstrVal);
							for (UINT i = 0; i < len; i++) {
								pExpandBuffer[writeidx++] = tmp.bstrVal[i];
							}
						}
					}
				}
				else if (bEnv) {
					// Azzɂ݂͑AϐWJwĂ
					ATL::CString szName(name);
					TCHAR szBuf[MAX_PATH] = {0};
					DWORD ret = GetEnvironmentVariable(szName, szBuf, MAX_PATH);
					if (ret && ret < MAX_PATH) {
						// ϐꂽ
						if (phase == 0) {
							// tG[Y1̓JEg邾
							expandsize += ret;
						}
						else {
							// tF[Y2͎ۂɏ
							ATL::CStringW wbuf(szBuf);
							for (UINT i = 0; i < ret; i++) {
								pExpandBuffer[writeidx++] = wbuf[i];
							}
						}
					}
				}
				continue;
			}
			if (phase == 0) {
				// tF[Y1͉Ȃ
				idx++;
			}
			else {
				// tF[Y2̓obt@ɒʏ폑݂
				pExpandBuffer[writeidx++] = str[idx++];
			}
		}
		//
		if (phase == 0) {
			// tF[Y1ÎŃobt@TCYB
			pExpandBuffer = new WCHAR[length + expandsize + 1];
		}
		else {
			// tF[Y2ÎŒu
			pExpandBuffer[writeidx] = 0;
			varResult = (LPCWSTR)pExpandBuffer;
			delete[] pExpandBuffer;
		}
	}
	varResult.Detach(pVal);
	return S_OK;
}


STDMETHODIMP CObjectMap::get_IsExist(VARIANT key, BOOL *pVal)
{
	*pVal = VB_FALSE;

	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		// ݂
		*pVal = VB_TRUE;
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::Erase(VARIANT key)
{
	CComVariant varName;
	HRESULT hr;
	if (FAILED(hr = varName.ChangeType(VT_BSTR, &key))) {
		return hr;
	}

	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if (p != m_mapVariant.end()) {
		m_mapVariant.erase(p);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::LoadProfile(IUnknown *punkVal)
{
	ISeraphyScriptTools_ProfileSection* pSection = NULL;
	HRESULT hr;
	if (FAILED(hr = punkVal->QueryInterface(
		IID_ISeraphyScriptTools_ProfileSection, (void**)&pSection))) {
		return hr;
	}

	CComVariant varArray;
	if (FAILED(hr = pSection->GetKeyNames(&varArray))) {
		return hr;
	}
	if (!(varArray.vt & VT_ARRAY)) {
		// Internal Error
		return DISP_E_UNKNOWNINTERFACE;
	}

	// z̏I擾
	long mx = 0;
	HRESULT ret = SafeArrayGetUBound(varArray.parray, 1, &mx);
	if (ret != S_OK) {
		mx = -1;
	}

	long idx = 0;
	while (idx <= mx) {
		CComVariant varKey, varVal;
		if (SUCCEEDED(SafeArrayGetElement(varArray.parray, &idx, &varKey))) {
			if (SUCCEEDED(pSection->get_Value(varKey, &varVal))) {
				put_Value(varKey, varVal);
			}
		}
		idx++;
	}
	pSection->Release();
	return S_OK;
}

STDMETHODIMP CObjectMap::SaveProfile(IUnknown *punkVal)
{
	ISeraphyScriptTools_ProfileSection* pSection = NULL;
	HRESULT hr;
	if (FAILED(hr = punkVal->QueryInterface(
		IID_ISeraphyScriptTools_ProfileSection, (void**)&pSection))) {
		return hr;
	}

	// i[Ă閼O̗
	VariantMap::iterator p = m_mapVariant.begin();
	while (p != m_mapVariant.end()) {
		CComVariant varTmp;
		if (SUCCEEDED(varTmp.ChangeType(VT_BSTR, &p->second))) {
			CComVariant varIdx = (BSTR)p->first;
			pSection->put_Value(varIdx, varTmp);
		}
		p++;
	}
	pSection->Release();
	return S_OK;
}
