// OverlappedWindow.cpp : COverlappedWindow ̃Cve[V


// /D "_ATL_MIN_CRT" O

#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "OverlappedWindow.h"
#include "generic.h"
#include <list>
#include <stack>

/////////////////////////////////////////////////////////////////////////////
// COverlappedWindow


HRESULT COverlappedWindow::FinalConstruct()
{
	m_pUnkMarshaler = NULL;

	// ACȐ
	m_hIcon = NULL;

	// Cxgҋ@pCxgnhACxgZ}tH
	m_hWaitEvent = CreateEvent(NULL, false, false, NULL); // Cxg : FALSE
	// NeBJZNV
	InitializeCriticalSection(&m_objEventDataProtection);

	// CxgC^[tFCX̏
	m_pEvent = NULL;
	// NXIuWFNg̏
	m_pClassDisp = NULL;
	m_bAutoReleaseClassObject = true;

	// EBhETCY
	//  Windows2000300x300ALunaȍ~ŘgύXꂽƂɂ
	// 308ɏCB(2015/08)
	windowParam.SetWindowPlacement(CW_USEDEFAULT, CW_USEDEFAULT, 308, 300);
	windowParam.noclose = false;
	windowParam.doublebuffer = true;
	windowParam.automessageloop = true;
	// obNOEhuV
	m_dwBackColor = ::GetSysColor(COLOR_WINDOW);
	m_hBkBrush = CreateSolidBrush(COLORREF(m_dwBackColor));
	// EBhE̍쐬
	m_hParentWnd = NULL;
	m_hPopupWnd = NULL;
	m_hMenu = NULL;

	// [U[[h̏
	m_bQuit = false; // ĂȂƂ
	m_dModalExitCode = 0;   // [_ԓR[h
	m_dCaptureMode = 0;
	m_bDefaultAction = true; // fBtHgOK/CANCELANVŕ

	// tH[C^[tFCX̍쐬
	m_hLastFocusControl = NULL;


	HRESULT hr;

	// tH[IuWFNg̐
	m_pForm = NULL;
	if (FAILED(hr = CComObject<CForm>::CreateInstance(&m_pForm))) {
		return hr;
	}
	m_pForm->AddRef();
	m_pForm->SetWindowSize(windowParam.width, windowParam.height,
		windowParam.ComputeStyle(), windowParam.exstyle);

	// `IuWFNg̐
	m_pCanvas = NULL;
	if (FAILED(hr = CComObject<CCanvas>::CreateInstance(&m_pCanvas))) {
		return hr;
	}
	m_pCanvas->AddRef();

	// [U[`AzzIuWFNg̐
	m_pObject = NULL;
	if (FAILED(hr = CComObject<CObjectMap>::CreateInstance(&m_pObject))) {
		return hr;
	}
	m_pObject->AddRef();

	// EFCgJ[\̏
	m_dWaitCursor = 0;

	// Ŵ߂̃t[Xbh}[V̐ݒ
	return CoCreateFreeThreadedMarshaler(
		GetControllingUnknown(), &m_pUnkMarshaler.p);
}

void COverlappedWindow::FinalRelease()
{
	// EBhEj邱ƂʒmCxg
	Fire_ExitWindow();
	ClassObjectInvoke(L"ExitWindow");

	// NXIuWFNg̕
	if (m_pClassDisp) {
		m_pClassDisp.Release();
	}

	// ACR̔j
	if (m_hIcon) {
		::DestroyIcon(m_hIcon);
	}
	// `Ch|bvAbv̔j
	std::list<CComObject<COverlappedWindow>*>::iterator pWnd = m_lstChild.begin();
	while (pWnd != m_lstChild.end()) {
		(*pWnd)->Close();
		(*pWnd)->Release();
		pWnd = m_lstChild.erase(pWnd);
	}
	// CxgIuWFNg̔j
	if (m_pEvent) {
		m_pEvent->Release();
		m_pEvent = NULL;
	}

	// h[COIuWFNg̃f^b`ƃC^[tFCX̕
	if (m_pCanvas) {
		m_pCanvas->DetachOwner();
		m_pCanvas->Release();
		m_pCanvas = NULL;
	}
	// tH[̔j
	if (m_pForm) {
		m_pForm->DetachOwner();
		m_pForm->Release();
		m_pForm = NULL;
	}
	// [U[`AzzIuWFNg̔j
	if (m_pObject) {
		m_pObject->Release();
		m_pObject = NULL;
	}

	// wiuV̉
	if (m_hBkBrush) {
		DeleteObject(m_hBkBrush);
	}

	EnterCriticalSection(&m_objEventDataProtection);
	// Cxgf[^̉
	std::list<CComObject<CEvent>*>::iterator pEv = m_lstEvent.begin();
	while (pEv != m_lstEvent.end()) {
		(*pEv)->Release();
		pEv = m_lstEvent.erase(pEv);
	}
	LeaveCriticalSection(&m_objEventDataProtection);

	// Cxgnh̉
	if (m_hWaitEvent) {
		CloseHandle(m_hWaitEvent);
		m_hWaitEvent = NULL;
	}
	// j[̔j
	if (m_hMenu) {
		DestroyMenu(m_hMenu);
		m_hMenu = NULL;
	}
	// CEBhE̔j
	if (m_hPopupWnd) {
		::DestroyWindow(m_hPopupWnd);
		m_hPopupWnd = NULL;
	}
	// NeBJZbV̔j
	DeleteCriticalSection(&m_objEventDataProtection);

	m_pUnkMarshaler.Release();
	ATLTRACE("COverlappedWindow::FinalRelease\r\n");
}

STDMETHODIMP COverlappedWindow::get_Caption(BSTR* pVal)
{
	*pVal = SysAllocString(m_bstrCaption);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Caption(BSTR newVal)
{
	SysReAllocString(&m_bstrCaption, newVal);
	SetTitle();
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_backColor(long *pVal)
{
	*pVal = m_dwBackColor;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_backColor(long newVal)
{
	m_dwBackColor = newVal;
	if (m_hBkBrush) {
		DeleteObject(m_hBkBrush);
	}
	m_hBkBrush = CreateSolidBrush(COLORREF(newVal));
	if (m_hPopupWnd) {
		::InvalidateRect(m_hPopupWnd, NULL, true);
		::UpdateWindow(m_hPopupWnd);
	}
	return S_OK;
}

HWND COverlappedWindow::SafeCreateWnd()
{
	// ς݂łΉȂB
	if (m_hPopupWnd) {
		return m_hPopupWnd;
	}
	// EBhEɕKvȑSp[^[̓RXgN^ō쐬ς
	// Ƃ̓EBhEKvɂȂ^C~OŐs

	if (windowParam.noclose) {
		// {^Ȃ^Cv
		windowParam.SetWindowClassName(_TEXT("SeraphyScriptToolsOverlappedWindowNC"));
		windowParam.wndstyle = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_NOCLOSE;
	}
	else {
		windowParam.SetWindowClassName(_TEXT("SeraphyScriptToolsOverlappedWindow"));
		windowParam.wndstyle = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	}

	WNDCLASSEX wcex = { 0 };
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.lpfnWndProc = (WNDPROC)WindowProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = _Module.m_hInst;
	wcex.hIcon = NULL;//(HICON)LoadImage(NULL,"SETUPICON.ICO",IMAGE_ICON,16,16,LR_LOADFROMFILE);//LoadIcon(hInstance, (LPCTSTR)IDI_INSTPAC);
	wcex.hIconSm = m_hIcon;//LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground = NULL;
	wcex.lpszMenuName = NULL;
	wcex.lpszClassName = windowParam.szClassName;
	wcex.style = windowParam.wndstyle;
	ATOM atm = RegisterClassEx(&wcex);

	HWND hWnd = CreateWindowEx(
		WS_EX_CONTROLPARENT,
		windowParam.szClassName,
		_TEXT(""), // _~[
		windowParam.ComputeStyle(),
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		windowParam.width,
		windowParam.height,
		m_hParentWnd,
		NULL, _Module.m_hInst, this);
	::SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR) this); // NXƊ֘At
	m_hPopupWnd = hWnd;
	// EBhEX^C̍Đݒ
	::SetWindowLong(m_hPopupWnd, GWL_STYLE, windowParam.ComputeStyle());
	Refresh();

	// VXej[Ƀt[ړj[
	HMENU hMenu = ::GetSystemMenu(m_hPopupWnd, false);
	int cnt = ::GetMenuItemCount(hMenu);
	MENUITEMINFO minfo = { 0 };
	minfo.cbSize = sizeof(MENUITEMINFO);
	minfo.fMask = MIIM_TYPE | MIIM_ID;
	minfo.fType = MFT_STRING;
	minfo.wID = WM_MOVENEXT_OVERLAPPED;
	minfo.dwTypeData = _TEXT("̃EBhEɈړ\tF6"); //FIXME: \[XɈړ
	::InsertMenuItem(hMenu, cnt, true, &minfo);

	// tH[̃CEBhEpƂăA^b`
	if (m_pForm) {
		// Rg[̎O쐬
		m_pForm->AttachOwner(m_hPopupWnd);
	}

	// EBhEꂽCxg𔭍s
	Fire_InitWindow();
	ClassObjectInvoke(L"InitWindow");

	return hWnd;
}

LRESULT CALLBACK COverlappedWindow::WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	COverlappedWindow* me = (COverlappedWindow*)::GetWindowLongPtr(hWnd, GWLP_USERDATA);

	// ً}~̔
	if (GetAsyncKeyState(VK_PAUSE) & 0x8000) {
		::EnableWindow(hWnd, true);
		me->m_bQuit = 1;
		me->m_dModalExitCode = 3;
	}

	switch (uMsg) {
	case WM_MOVENEXT_OVERLAPPED:
	{
		me->MoveNextOverlapped();
		return 0;
	}
	case WM_CREATE:
	{
		// fBtHg̓s
		break;
	}
	case WM_PAINT:
	{
		PAINTSTRUCT ps;
		RECT rt;
		::GetClientRect(hWnd, &rt);
		HDC hdc = ::BeginPaint(hWnd, &ps);
		HDC hdc2 = hdc;
		HBITMAP bmp;
		BOOL bDblBuf = me->windowParam.doublebuffer;
		if (bDblBuf) {
			// 𖳂邽߂Ƀouobt@ɂ邩H
			hdc2 = ::CreateCompatibleDC(NULL);
			bmp = ::CreateCompatibleBitmap(hdc, rt.right, rt.bottom);
			::SelectObject(hdc2, bmp);
		}
		// wihԂ
		::SetBkColor(hdc2, COLORREF(me->m_dwBackColor));
		::SetBkMode(hdc2, TRANSPARENT);
		::SetPolyFillMode(hdc2, ALTERNATE);
		FillRect(hdc2, &rt, me->m_hBkBrush);

		// h[COf[^[̕`
		if (me->m_pCanvas) {
			me->m_pCanvas->Draw(hdc2, rt);
		}

		if (bDblBuf) {
			// _uobt@̓]
			::BitBlt(hdc, 0, 0, rt.right, rt.bottom, hdc2, 0, 0, SRCCOPY);
			DeleteDC(hdc2);
			DeleteObject(bmp);
		}
		::EndPaint(hWnd, &ps);
		break;
	}
	case WM_SYSCOMMAND:
	{
		if (wParam == SC_CLOSE) {
			if (me->windowParam.autoclose) {
				me->Close();
			}
			me->m_bQuit = true;
			me->m_dModalExitCode = IDABORT;
			me->AddEventSingle(WM_COMMAND, IDABORT, 0);
			return false;
		}
		else if (wParam == WM_MOVENEXT_OVERLAPPED) {
			SendMessage(hWnd, WM_MOVENEXT_OVERLAPPED, 0, 0);
			return 0;
		}
		break;
	}
	case WM_MOUSEMOVE:
	{
		me->AddEventSingle(WM_MOUSEMOVE, 0, 0);
		break;
	}
	case WM_LBUTTONDBLCLK:
	{
		me->AddEvent(WM_LBUTTONDBLCLK, 0, 0);
		break;
	}
	case WM_RBUTTONDBLCLK:
	{
		me->AddEvent(WM_RBUTTONDBLCLK, 0, 0);
		break;
	}
	case WM_LBUTTONDOWN:
	{
		if (me->m_dCaptureMode == 0) {
			me->AddEvent(WM_LBUTTONDOWN, 0, 0);
			::SetCapture(hWnd);
			me->m_dCaptureMode |= 0x01;
		}
		else {
			ReleaseCapture();
		}
		break;
	}
	case WM_LBUTTONUP:
	{
		if (me->m_dCaptureMode & 0x01) {
			me->AddEvent(WM_LBUTTONUP, 0, 0);
			me->m_dCaptureMode &= ~0x01;
			ReleaseCapture();
		}
		break;
	}
	case WM_RBUTTONDOWN:
	{
		if (me->m_dCaptureMode == 0) {
			me->AddEvent(WM_RBUTTONDOWN, 0, 0);
			::SetCapture(hWnd);
			me->m_dCaptureMode |= 0x02;
		}
		else {
			ReleaseCapture();
		}
		break;
	}
	case WM_RBUTTONUP:
	{
		if (me->m_dCaptureMode & 0x02) {
			me->AddEvent(WM_RBUTTONUP, 0, 0);
			me->m_dCaptureMode &= ~0x02;
			ReleaseCapture();
		}
		break;
	}
	case WM_CAPTURECHANGED:
	{
		if (me->m_dCaptureMode & 0x01) {
			me->AddEvent(WM_CAPTURECHANGED, 1, 0);
		}
		if (me->m_dCaptureMode & 0x02) {
			me->AddEvent(WM_CAPTURECHANGED, 2, 0);
		}
		me->m_dCaptureMode = 0;
		break;
	}
	case WM_SIZE:
	{
		me->AddEventSingle(WM_SIZE, 0, 0);
		break;
	}
	case WM_TIMER:
	{
		if (wParam == 1) {
			me->AddEventSingle(WM_TIMER, 0, 0);
		}
		break;
	}
	case WM_DROPFILES:
	{
		HDROP hDrop = (HDROP)wParam;
		me->m_dropfiles.SetDropFiles(hDrop);
		me->AddEvent(WM_DROPFILES, 0, 0);
		break;
	}
	case WM_KEYDOWN:
	{
		DWORD st = 0;
		if (GetKeyState(VK_SHIFT) & 0x8000) st |= 0x01;
		if (GetKeyState(VK_CONTROL) & 0x8000) st |= 0x02;
		if (GetKeyState(VK_MENU) & 0x8000) st |= 0x04;
		me->AddEventSingle(WM_KEYDOWN, wParam, st);
		return 0;
	}
	case WM_KEYDOWN_EX:
	{
		DWORD st = 0;
		if (GetKeyState(VK_SHIFT) & 0x8000) st |= 0x01;
		if (GetKeyState(VK_CONTROL) & 0x8000) st |= 0x02;
		if (GetKeyState(VK_MENU) & 0x8000) st |= 0x04;
		me->AddEventSingle(WM_KEYDOWN_EX, wParam, st);
		return 0;
	}
	case WM_COMMAND:
	{
#ifdef _DEBUG
		ATLTRACE(_TEXT("command=%d:%d\n"), HIWORD(wParam), LOWORD(wParam));
#endif
		HWND hControl = (HWND)lParam;
		int nID = LOWORD(wParam);
		int notify = HIWORD(wParam);
		if (!notify) {
			if (nID == IDABORT) {
				// IDABORTƓȂquit𗧂Ă
				me->m_bQuit = true;
			}
			me->AddEventSingle(WM_COMMAND, nID, 0);
		}
		else {
			// Rg[ʒm
			switch (notify) {
			case CBN_SETFOCUS:
			case LBN_SETFOCUS:
			case EN_SETFOCUS:
			case BN_SETFOCUS:
				// TreeView - ListViewȊÕRg[tH[JX󂯎Ƃʒm
				me->m_hLastFocusControl = hControl;
				break;
			case LBN_DBLCLK:
				// LISTBOX_uNbNꂽ
				me->AddEvent(WM_COMMAND, nID, 0);
			default:
				break;
			}
		}
		break;
	}
	case WM_NOTIFY:
	{
		NMHDR* notify = (NMHDR*)lParam;
		switch (notify->code) {
		case NM_SETFOCUS:
		{
			// TreeView - ListViewtH[JX󂯎Ƃʒm
			me->m_hLastFocusControl = notify->hwndFrom;
			return 0;
		}
		case TVN_SELCHANGED:
		{
			// TreeView̑IύXꂽƂʒm
			LPNMTREEVIEW pnmTv = (LPNMTREEVIEW)lParam;
			me->AddEvent(WM_COMMAND, pnmTv->hdr.idFrom, 0);
			return 0;
		}
		case NM_DBLCLK:
		{
			// ListView - TreeViewŃ_uNbNꂽƂʒmꂽ
			LPNMITEMACTIVATE pnmLv = (LPNMITEMACTIVATE)lParam;
			me->AddEvent(WM_COMMAND, pnmLv->hdr.idFrom, 0);
			return 0;
		}
		case LVN_COLUMNCLICK:
		{
			// ListViewŃJNbNꂽƂʒm
			LPNMLISTVIEW pnmv = (LPNMLISTVIEW)lParam;
			LONG_PTR addr = ::GetWindowLongPtr(pnmv->hdr.hwndFrom, GWLP_USERDATA);
			if (addr) {
				// JNbNɂ\[eBOs
				CComObject<CControl>* pCtrl = (CComObject<CControl>*)addr;
				pCtrl->ListSort(pnmv->iSubItem);
			}
			return 0;
		}
		case LVN_ENDLABELEDIT:
		{
			// ListViewōڂҏWꂽƂʒm
			NMLVDISPINFO* pdi = (NMLVDISPINFO*)lParam;
			if (pdi->item.mask & LVIF_TEXT) {
				ListView_SetItemText(pdi->hdr.hwndFrom, pdi->item.iItem, 0, pdi->item.pszText);
			}
			return 0;
		}
		case LVN_KEYDOWN:
		{
			// ListViewŃL[{[hꂽƂʒm
			LPNMLVKEYDOWN pnkd = (LPNMLVKEYDOWN)lParam;
			if (pnkd->wVKey == VK_SPACE) {
				// Xy[XL[Ń_uNbNƓʂ
				me->AddEvent(WM_COMMAND, pnkd->hdr.idFrom, 0);
			}
			else if (pnkd->wVKey == VK_DELETE) {
				// f[g
				me->AddEvent(WM_NOTIFY, pnkd->hdr.idFrom, VK_DELETE);
			}
			else if (pnkd->wVKey == VK_F2) {
				// xҏWJn
				int idx = ListView_GetNextItem(pnkd->hdr.hwndFrom, -1, LVNI_FOCUSED);
				ListView_EditLabel(pnkd->hdr.hwndFrom, idx);
			}
			return 0;
		}
		case TVN_KEYDOWN:
		{
			LPNMTVKEYDOWN ptvkd = (LPNMTVKEYDOWN)lParam;
			if (ptvkd->wVKey == VK_DELETE) {
				// f[g
				me->AddEvent(WM_NOTIFY, ptvkd->hdr.idFrom, VK_DELETE);
			}
			return 0;
		}
		case NM_RCLICK:
		{
			// ListView - TreeView ŉENbNꂽƂʒm
			LPNMHDR lpnmh = (LPNMHDR)lParam;
			LONG_PTR addr = ::GetWindowLongPtr(lpnmh->hwndFrom, GWLP_USERDATA);
			if (addr) {
				CComObject<CControl>* pCtrl = (CComObject<CControl>*)addr;
				pCtrl->OnRClick(); // Rg[ɉENbNʒmOs킹
			}
			me->AddEvent(WM_NOTIFY, lpnmh->idFrom, VK_RBUTTON);
			return 0;
		}
		default:
			break;
		}
		break;
	}
	case WM_CTLCOLORSTATIC:
	{
		HDC hdc = (HDC)wParam;
		::SetBkColor(hdc, me->m_dwBackColor);
		::SetTextColor(hdc, ::GetSysColor(COLOR_WINDOWTEXT));
		return (LPARAM)me->m_hBkBrush;
	}
	case WM_CTLCOLOREDIT:
	case WM_CTLCOLORLISTBOX:
	case WM_CTLCOLORMSGBOX:
	{
		if (me->m_pForm) {
			// tH[Ŏw肳ꂽRg[wiuV擾
			HDC hdc = (HDC)wParam;
			::SetBkColor(hdc, me->m_pForm->GetControlColor());
			::SetTextColor(hdc, ::GetSysColor(COLOR_WINDOWTEXT));
			return (LPARAM)me->m_pForm->GetControlColorBrush();
		}
		break;
	}
	case WM_SETCURSOR:
	{
		if (me->m_dWaitCursor > 0) {
			::SetCursor(::LoadCursor(NULL, IDC_WAIT));
			return true;
		}
		break;
	}
	}
	return ::DefWindowProc(hWnd, uMsg, wParam, lParam);
}

STDMETHODIMP COverlappedWindow::DoEvent(VARIANT *varResult)
{
	SafeCreateWnd();

	CComVariant ret;
	ret = 0;

	// CxL[̎擾
	EnterCriticalSection(&m_objEventDataProtection);
	CComObject<CEvent>* pEv = NULL;
	if (!m_lstEvent.empty()) {
		// CxgXgɃf[^[Ă
		pEv = m_lstEvent.front();
		m_lstEvent.pop_front();
	}
	if (m_lstEvent.empty()) {
		// ȏチbZ[WȂ̂Ȃ΁ACxgtOZbg
		ResetEvent(m_hWaitEvent);
	}
	else {
		// ܂bZ[ŴŃCxgĂ
		SetEvent(m_hWaitEvent);
	}
	LeaveCriticalSection(&m_objEventDataProtection);

	// oCxg̏
	if (pEv) {
		// ԓCxgR[h
		ret = pEv->GetMessage();
		//
		if (pEv->GetMessage() == WM_TIMER) {
			// ^C}[CxgUIɊ֌WȂ荞܂邽
			// CxgvpeB[ɂ̓ZbgACY邾B
			Fire_OnTimer();
			ClassObjectInvoke(L"OnTimer");
		}
		else {
			// ̂ق̃Cxg ݂̃CxgIuWFNgvpeB[ɃZbg
			if (m_pEvent) {
				// ÂIuWFNg̔j
				m_pEvent->Release();
				m_pEvent = NULL;
			}
			m_pEvent = pEv;
			m_pEvent->AddRef();

			// ̃IuWFNgƂēn߂ɃC^[tFCX𐶐
			CComPtr<IUnknown> pUnk;
			HRESULT hr;
			if (FAILED(hr = QueryInterface(IID_IUnknown, (void**)&pUnk))) {
				return hr;
			}

			// Cxgɑ΂郉CY
			switch (pEv->GetMessage()) {
			case WM_KEYDOWN:
			{
				Fire_OnKeydown();
				Fire_OnKeydownEx(pUnk);
				ClassObjectInvoke(L"OnKeydown");
				break;
			}
			case WM_KEYDOWN_EX:
			{
				Fire_OnKeydown2();
				Fire_OnKeydown2Ex(pUnk);
				ClassObjectInvoke(L"OnKeydown2");
				break;
			}
			case WM_MOUSEMOVE:
			{
				Fire_OnMouseMove();
				Fire_OnMouseMoveEx(pUnk);
				ClassObjectInvoke(L"OnMouseMove");
				break;
			}
			case WM_LBUTTONDBLCLK:
			{
				Fire_OnDblClick();
				Fire_OnDblClickEx(pUnk);
				ClassObjectInvoke(L"OnDblClick");
				break;
			}
			case WM_LBUTTONDOWN:
			{
				Fire_OnClick();
				Fire_OnClickEx(pUnk);
				ClassObjectInvoke(L"OnClick");
				break;
			}
			case WM_RBUTTONDBLCLK:
			{
				Fire_OnRDblClick();
				Fire_OnRDblClickEx(pUnk);
				ClassObjectInvoke(L"OnRDblClick");
				break;
			}
			case WM_RBUTTONDOWN:
			{
				Fire_OnRClick();
				Fire_OnRClickEx(pUnk);
				ClassObjectInvoke(L"OnRClick");
				break;
			}
			case WM_LBUTTONUP:
			{
				Fire_OnClickOut();
				Fire_OnClickOutEx(pUnk);
				ClassObjectInvoke(L"OnClickOut");
				break;
			}
			case WM_RBUTTONUP:
			{
				Fire_OnRClickOut();
				Fire_OnRClickOutEx(pUnk);
				ClassObjectInvoke(L"OnRClickOut");
				break;
			}
			case WM_CAPTURECHANGED:
			{
				if (pEv->GetParam() == 1) {
					Fire_OnClickCancel();
					Fire_OnClickCancelEx(pUnk);
					ClassObjectInvoke(L"OnClickCancel");
				}
				else {
					Fire_OnRClickCancel();
					Fire_OnRClickCancelEx(pUnk);
					ClassObjectInvoke(L"OnRClickCancel");
				}
				break;
			}
			case WM_SIZE:
			{
				Fire_OnSize();
				Fire_OnSizeEx(pUnk);
				ClassObjectInvoke(L"OnSize");
				break;
			}
			case WM_COMMAND:
			{
				int nID = pEv->GetParam();
				switch (nID) {
				case IDOK:
					if (m_bDefaultAction) {
						m_bQuit = true;
					}
					m_dModalExitCode = IDOK;
					Fire_OnOK();
					Fire_OnOKEx(pUnk);
					ClassObjectInvoke(L"OnOK");
					break;
				case IDCANCEL:
					if (m_bDefaultAction) {
						m_bQuit = true;
					}
					m_dModalExitCode = IDCANCEL;
					Fire_OnCancel();
					Fire_OnCancelEx(pUnk);
					ClassObjectInvoke(L"OnCancel");
					break;
				case IDABORT:
					m_bQuit = true;
					m_dModalExitCode = IDABORT;
					Fire_OnExit();
					Fire_OnExitEx(pUnk);
					ClassObjectInvoke(L"OnExit");
					break;
				default:
					Fire_OnCommand();
					Fire_OnCommandEx(pUnk);
					ClassObjectInvoke(L"OnCommand");
				}
				// ֘AÂꂽRg[̂H
				if (m_pForm) {
					BSTR eventname = NULL;
					if (m_pForm->FindControlEventName(nID, &eventname)) {
						if (SysStringLen(eventname) > 0) {
							ClassObjectInvoke(eventname);
						}
						SysFreeString(eventname);
					}
				}
				// j[̌
				if (m_hMenu && nID >= 100) {
					std::map<int, CComBSTR>::iterator p = m_cMenuMap.find(nID);
					if (p != m_cMenuMap.end()) {
						// ꂽ
						ClassObjectInvoke(p->second);
					}
				}
				break;
			}
			case WM_DROPFILES:
			{
				Fire_OnDropFiles();
				Fire_OnDropFilesEx(pUnk);
				ClassObjectInvoke(L"OnDropFiles");
				break;
			}
			case WM_NOTIFY:
			{
				switch (pEv->GetLParam()) {
				case VK_DELETE:
					Fire_OnContextDelete();
					Fire_OnContextDeleteEx(pUnk);
					ClassObjectInvoke(L"OnContextDelete");
					break;
				case VK_RBUTTON:
					Fire_OnContextMenu();
					Fire_OnContextMenuEx(pUnk);
					ClassObjectInvoke(L"OnContextMenu");
					break;
				}
				break;
			}
			}
			// ̈ƂēnC^[tFCX
			if (pUnk) {
				pUnk.Release();
			}
		}
		// ꂽCxg͉
		pEv->Release();
	}
	else {
		// CxgȂꍇ̓Cxg̃NA
		if (m_pEvent) {
			// ÂIuWFNg̔j
			m_pEvent->Release();
			m_pEvent = NULL;
		}
	}
	// CxgR[h߂B
	ret.Detach(varResult);
	return S_OK;
}

void COverlappedWindow::AddEventSingle(int message, WPARAM wParam, LPARAM lParam)
{
	// Cxgobt@ɖ̃Cxg΃Cxg𔭍sȂB
	BOOL bFind = false;
	EnterCriticalSection(&m_objEventDataProtection);
	std::list<CComObject<CEvent>*>::iterator p = m_lstEvent.begin();
	while (p != m_lstEvent.end()) {
		if ((*p)->GetMessage() == message && (*p)->GetParam() == wParam) {
			bFind = true;
			break;
		}
		p++;
	}
	LeaveCriticalSection(&m_objEventDataProtection);
	if (!bFind) {
		// CxgȂ΃Cxg̔ss
		AddEvent(message, wParam, lParam);
	}
}

void COverlappedWindow::AddEvent(int message, WPARAM wParam, LPARAM lParam)
{
	// Cxg̃}EXʒuNCGgWɕϊ
	POINT pt, lp;
	DWORD pos = GetMessagePos();
	pt.x = LOWORD(pos);
	pt.y = HIWORD(pos);
	lp.x = lp.y = 0;
	if (m_hPopupWnd) {
		::ScreenToClient(m_hPopupWnd, &pt);
		// Wn̕ϊ
		lp = pt;
		HDC hdc = ::GetDC(m_hPopupWnd);
		POINT org;
		RECT rct;
		::GetClientRect(m_hPopupWnd, &rct);
		::SetViewportOrgEx(hdc, 0, rct.bottom, &org);
		int md = ::GetMapMode(hdc);
		::SetMapMode(hdc, MM_LOMETRIC);
		::DPtoLP(hdc, &lp, 1);
		::SetMapMode(hdc, md);
		::SetViewportOrgEx(hdc, org.x, org.y, NULL);
		::ReleaseDC(m_hPopupWnd, hdc);
	}

	// Cxg̐ςݏグ
	EnterCriticalSection(&m_objEventDataProtection);
	CComObject<CEvent>* pEvent = NULL;
	HRESULT hr;
	if (SUCCEEDED(hr = CComObject<CEvent>::CreateInstance(&pEvent))) {
		pEvent->AddRef();
		pEvent->SetData(message, wParam, lParam, pt, lp);
		m_lstEvent.push_back(pEvent);
	}
	ATLASSERT(SUCCEEDED(hr));

	LeaveCriticalSection(&m_objEventDataProtection);

	// CxgnhVOiɂ
	SetEvent(m_hWaitEvent);

	if (windowParam.automessageloop) {
		// ɃCxgs
		CComVariant tmp;
		DoEvent(&tmp);
	}
}


STDMETHODIMP COverlappedWindow::Draw()
{
	// `悷
	if (m_hPopupWnd) {
		::InvalidateRect(m_hPopupWnd, NULL, true);
		::UpdateWindow(m_hPopupWnd);
	}
	return S_OK;
}


STDMETHODIMP COverlappedWindow::get_IsEventEmpty(BOOL *pVal)
{
	// CxgȂtrue
	*pVal = m_lstEvent.empty() ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::Open(VARIANT caption, VARIANT* pvarUnk)
{
	SafeCreateWnd();
	CComVariant tmp;
	if ((caption.vt != VT_ERROR && caption.vt != VT_NULL) && tmp.ChangeType(VT_BSTR, &caption) == S_OK) {
		put_Caption(tmp.bstrVal);
	}
	put_Enable(true);
	put_Visible(true);
	m_bQuit = false;
	m_dModalExitCode = 0;     // [_ԓR[h
	CreateThisInterface(pvarUnk);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::Close()
{
	// `ChĂꍇ́A`ChN[Y
	std::list<CComObject<COverlappedWindow>*>::iterator pWnd = m_lstChild.begin();
	while (pWnd != m_lstChild.end()) {
		(*pWnd)->Close();
		pWnd++;
	}
	// ̃EBhE\ɂ
	put_Visible(false);
	m_bQuit = true;

	// NXIuWFNg̕
	if (m_pClassDisp && m_bAutoReleaseClassObject) {
		m_pClassDisp.Release();
	}

	// tH[JXړ
	if (m_hParentWnd) {
		::SetActiveWindow(m_hParentWnd);
		::SetFocus(m_hParentWnd);
	}
	else {
		MoveNextOverlapped();
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_DoubleBuffer(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = windowParam.doublebuffer ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_DoubleBuffer(BOOL newVal)
{
	windowParam.doublebuffer = newVal;
	return S_OK;
}


STDMETHODIMP COverlappedWindow::get_TopMost(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	DWORD exstyle = ::GetWindowLong(m_hPopupWnd, GWL_EXSTYLE);
	*pVal = (exstyle & WS_EX_TOPMOST) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_TopMost(BOOL newVal)
{
	SafeCreateWnd();
	::SetWindowPos(m_hPopupWnd, newVal ? HWND_TOPMOST : HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_PosX(short *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		windowParam.posX = (int)pls.rcNormalPosition.left;
	}

	*pVal = windowParam.posX;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_PosX(short newVal)
{
	windowParam.posX = newVal;
	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		::SetWindowPos(m_hPopupWnd, NULL,
			windowParam.posX,
			pls.rcNormalPosition.top,
			0, 0, SWP_NOZORDER | SWP_NOSIZE);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_PosY(short *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		windowParam.posY = (int)pls.rcNormalPosition.top;
	}

	*pVal = windowParam.posY;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_PosY(short newVal)
{
	windowParam.posY = newVal;
	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		::SetWindowPos(m_hPopupWnd, NULL,
			pls.rcNormalPosition.left,
			windowParam.posY,
			0, 0, SWP_NOZORDER | SWP_NOSIZE);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Width(short *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		windowParam.width = (int)(pls.rcNormalPosition.right - pls.rcNormalPosition.left);
	}

	*pVal = windowParam.width;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Width(short newVal)
{
	windowParam.width = newVal;

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		::SetWindowPos(m_hPopupWnd, NULL,
			0, 0,
			windowParam.width,
			pls.rcNormalPosition.bottom - pls.rcNormalPosition.top, SWP_NOZORDER | SWP_NOMOVE);
	}

	if (m_pForm) {
		// tH[̃TCYύX
		m_pForm->SetWindowSize(windowParam.width, windowParam.height,
			windowParam.ComputeStyle(), windowParam.exstyle);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Height(short *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		windowParam.height = (short)(pls.rcNormalPosition.right - pls.rcNormalPosition.left);
	}

	*pVal = windowParam.height;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Height(short newVal)
{
	windowParam.height = newVal;

	if (m_hPopupWnd) {
		WINDOWPLACEMENT pls = { 0 };
		pls.length = sizeof(WINDOWPLACEMENT);
		::GetWindowPlacement(m_hPopupWnd, &pls);
		::SetWindowPos(m_hPopupWnd, NULL, 0, 0,
			pls.rcNormalPosition.right - pls.rcNormalPosition.left,
			windowParam.height,
			SWP_NOZORDER | SWP_NOMOVE);
	}

	if (m_pForm) {
		// tH[̃TCYύX
		m_pForm->SetWindowSize(windowParam.width, windowParam.height,
			windowParam.ComputeStyle(), windowParam.exstyle);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_AcceptFiles(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	DWORD exstyle = ::GetWindowLong(m_hPopupWnd, GWL_EXSTYLE);
	*pVal = (exstyle & WS_EX_ACCEPTFILES) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_AcceptFiles(BOOL newVal)
{
	SafeCreateWnd();
	DWORD exstyle = ::GetWindowLong(m_hPopupWnd, GWL_EXSTYLE);
	exstyle &= ~WS_EX_ACCEPTFILES;
	exstyle |= newVal ? WS_EX_ACCEPTFILES : 0;
	::SetWindowLong(m_hPopupWnd, GWL_EXSTYLE, exstyle);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::SetForegroundWindow()
{
	SafeCreateWnd();
	::SetForegroundWindow(m_hPopupWnd);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::SetFocus()
{
	SafeCreateWnd();
	::SetFocus(m_hPopupWnd);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Enable(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	SafeCreateWnd();

	*pVal = ::IsWindowEnabled(m_hPopupWnd) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Enable(BOOL newVal)
{
	SafeCreateWnd();

	::EnableWindow(m_hPopupWnd, newVal);

	if (m_pForm) {
		m_pForm->EnableAllControl(newVal);
		::SetActiveWindow(m_hPopupWnd);
	}
	return S_OK;
}


STDMETHODIMP COverlappedWindow::get_Iconic(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	*pVal = ::IsIconic(m_hPopupWnd) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Iconic(BOOL newVal)
{
	SafeCreateWnd();
	::ShowWindow(m_hPopupWnd, newVal ? SW_MINIMIZE : SW_SHOWNORMAL);
	return S_OK;
}


STDMETHODIMP COverlappedWindow::get_Zoomed(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	*pVal = ::IsZoomed(m_hPopupWnd) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Zoomed(BOOL newVal)
{
	SafeCreateWnd();
	::ShowWindow(m_hPopupWnd, newVal ? SW_SHOWMAXIMIZED : SW_SHOWNORMAL);
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Visible(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = VB_FALSE;

	if (::IsWindow(m_hPopupWnd)) {
		// EBhE쐬ς݂łΒ
		DWORD style = ::GetWindowLong(m_hPopupWnd, GWL_STYLE);
		*pVal = (style & WS_VISIBLE) ? VB_TRUE : VB_FALSE;
	}

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Visible(BOOL newVal)
{
	if (!newVal && !::IsWindow(m_hPopupWnd)) {
		// FALSEȂAč쐬͎݂Ȃ
		return S_OK;
	}

	SafeCreateWnd();

	::ShowWindow(m_hPopupWnd, newVal ? SW_SHOWNORMAL : SW_HIDE);
	::SetActiveWindow(m_hPopupWnd);

	return S_OK;
}

STDMETHODIMP COverlappedWindow::WaitEvent(VARIANT varTim, BOOL* pRet)
{
	if (!pRet) {
		return E_POINTER;
	}

	SafeCreateWnd();
	*pRet = VB_FALSE;

	// ҋ@Ԃ̎擾
	DWORD sleeptim = 1000;
	CComVariant tim;
	if (tim.ChangeType(VT_I4, &varTim) == S_OK) {
		sleeptim = (DWORD)tim.lVal;
	}
	if (sleeptim == 0) {
		sleeptim = INFINITE;
	}

	HANDLE hEvent[MAXIMUM_WAIT_OBJECTS] = { NULL };
	HWND   hWnd[MAXIMUM_WAIT_OBJECTS] = { NULL };
	int cnt = 0;
	SetWaitParam(&cnt, hWnd, hEvent);
	*pRet = MessageLoop(sleeptim, cnt, hWnd, hEvent) ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::SetMenu(VARIANT fmt)
{
	SafeCreateWnd();

	HRESULT hr;

	CComVariant tmp;
	if (FAILED(hr = tmp.ChangeType(VT_BSTR, &fmt))) {
		return hr;
	}

	ATL::CString buf(tmp.bstrVal);

	// Âj[j
	if (m_hMenu) {
		m_cMenuMap.clear();
		::SetMenu(m_hPopupWnd, NULL);
		DestroyMenu(m_hMenu);
		m_hMenu = NULL;
	}

	if (buf.GetLength() > 0) {
		// ڂ΃j[p[X
		m_hMenu = CreateMenu();
		TCHAR menuname[MAX_PATH];
		TCHAR szSubmenu[MAX_PATH];
		HMENU hPopupMenu = NULL;
		int lv1 = 0;
		int lv2 = 0;
		int cmd = 0;

		LPTSTR p = buf.GetBuffer();
		while (*p) {
			while (*p == ' ' || *p == '\t') p++; // uNXLbv
			if (*p == '/') {
				p++;
				// |bvAbvj[̍쐬
				if (hPopupMenu) {
					// ̃|bvAbv𖄂ߍ
					MENUITEMINFO inf = { 0 };
					inf.cbSize = sizeof(MENUITEMINFO);
					inf.fMask = MIIM_SUBMENU | MIIM_TYPE;
					inf.fType = MFT_STRING;
					inf.dwTypeData = szSubmenu;
					inf.hSubMenu = hPopupMenu;
					InsertMenuItem(m_hMenu, lv1, true, &inf);
				}
				lv1++;
				lv2 = 0;
				cmd = 0;

				hPopupMenu = CreatePopupMenu();
				LPTSTR st = p;
				while (*p && *p != ',' && *p != '/' && *p != ':') {
					p = CharNext(p);
				}
				ZeroMemory(szSubmenu, MAX_PATH);
				int submenuLen = p - st;
				if (submenuLen > 0) {
					_tcsncpy_s(szSubmenu, MAX_PATH, st, submenuLen);
				}
				if (*p == ',' || *p == ':') {
					p++;
				}
			}
			else {
				// j[̍쐬
				if (hPopupMenu) {
					LPTSTR st = p;
					while (*p && *p != ',' && *p != '/' && *p != ':') {
						p = CharNext(p);
					}

					ZeroMemory(menuname, MAX_PATH);
					int menunameLen = p - st;
					if (menunameLen > 0) {
						_tcsncpy_s(menuname, MAX_PATH, st, menunameLen);
					}

					// R}hZp[^[
					CComBSTR eventname;
					LPTSTR findcmd = _tcschr(menuname, _TEXT('@'));
					if (findcmd) {
						*findcmd = 0;
						eventname = findcmd + 1;

					}
					else {
						TCHAR tmp[64];
						wsprintf(tmp, _TEXT("OnMenu%d"), lv1 * 100 + cmd);
						eventname = tmp;
					}
					m_cMenuMap.insert(std::make_pair(lv1 * 100 + cmd, eventname));

					// j[̍쐬
					MENUITEMINFO inf = { 0 };
					inf.cbSize = sizeof(MENUITEMINFO);
					inf.fMask = MIIM_TYPE | MIIM_ID;
					inf.fType = MFT_STRING;
					inf.wID = lv1 * 100 + cmd;
					inf.dwTypeData = menuname;
					InsertMenuItem(hPopupMenu, lv2, true, &inf);
					lv2++;
					cmd++;

					// Zp[^[̎w肩?
					if (*p == ',') {
						p++;

					}
					else if (*p == ':') {
						MENUITEMINFO inf = { 0 };
						inf.cbSize = sizeof(MENUITEMINFO);
						inf.fMask = MIIM_TYPE;
						inf.fType = MFT_SEPARATOR;
						InsertMenuItem(hPopupMenu, lv2, true, &inf);
						p++;
						lv2++;
					}
				}
			}
		}
		// }̃|bvAbvj[̑}
		if (hPopupMenu) {
			// ̃|bvAbv𖄂ߍ
			MENUITEMINFO inf = { 0 };
			inf.cbSize = sizeof(MENUITEMINFO);
			inf.fMask = MIIM_SUBMENU | MIIM_TYPE;
			inf.fType = MFT_STRING;
			inf.dwTypeData = szSubmenu;
			inf.hSubMenu = hPopupMenu;
			InsertMenuItem(m_hMenu, lv1, true, &inf);
		}
		::SetMenu(m_hPopupWnd, m_hMenu);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::TrackPopupMenu(VARIANT text, VARIANT pcmd, VARIANT* pRet)
{
	if (!pRet) {
		return E_POINTER;
	}

	SafeCreateWnd();

	CComVariant varRet;
	varRet = 0;

	int nCommand = 0;
	CComVariant varCmd;
	if (SUCCEEDED(varCmd.ChangeType(VT_I2, &pcmd))) {
		nCommand = varCmd.iVal;
	}

	HRESULT hr;

	CComVariant varText;
	if (FAILED(hr = varText.ChangeType(VT_BSTR, &text))) {
		return hr;
	}

	TCHAR menuname[MAX_PATH];

	ATL::CString buf(varText.bstrVal);
	UINT len = buf.GetLength() + 1;
	LPTSTR p = buf.GetBuffer();

	int lv = 0;
	int cmd = 0;
	HMENU hPopupMenu = CreatePopupMenu();
	while (*p) {
		LPTSTR st = p;
		while (*p == ' ' || *p == '\t') {
			p++;
		}
		while (*p && *p != ',' && *p != '/' && *p != ':') {
			p = CharNext(p);
		}
		ZeroMemory(menuname, MAX_PATH);
		int menunameLen = p - st;
		if (menunameLen > 0) {
			_tcsncpy_s(menuname, MAX_PATH, st, menunameLen);
		}
		MENUITEMINFO inf = { 0 };
		inf.cbSize = sizeof(MENUITEMINFO);
		inf.fMask = MIIM_TYPE | MIIM_ID;
		inf.fType = MFT_STRING;

		if (nCommand != 0) {
			inf.wID = nCommand + cmd;

		}
		else {
			// R}hx[X0Ȃ΃R}hCxg͔ȂB
			// TrackPopupMenu̓R}hIȂꍇ0Ԃ߁A0傫ȒlɂKvB
			inf.wID = nCommand + cmd + 1;
		}

		inf.dwTypeData = menuname;
		InsertMenuItem(hPopupMenu, lv, true, &inf);
		lv++;
		cmd++;

		if (*p == ',' || *p == '/') {
			p++;

		}
		else if (*p == ':') {
			inf.fMask = MIIM_TYPE;
			inf.fType = MFT_SEPARATOR;
			InsertMenuItem(hPopupMenu, lv, true, &inf);
			p++;
			lv++;
		}
	}

	// TrackPopupMene
	DWORD pos = GetMessagePos();
	::SetFocus(m_hPopupWnd);
	varRet = (SHORT) ::TrackPopupMenuEx(hPopupMenu,
		TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON |
		(nCommand == 0 ? (TPM_NONOTIFY | TPM_RETURNCMD) : 0), // R}hx[X0ł΁AR}hCxgʒmȂB
		LOWORD(pos),
		HIWORD(pos),
		m_hPopupWnd,
		NULL);

	DestroyMenu(hPopupMenu);

	return varRet.Detach(pRet);
}

STDMETHODIMP COverlappedWindow::get_HWND(long *pVal)
{
	*pVal = (LONG)m_hPopupWnd;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::GetSysColor(VARIANT typ, VARIANT *col)
{
	if (!col) {
		return E_POINTER;
	}
	VariantInit(col);

	// VXeJ[̎擾
	HRESULT hr;

	CComVariant varType;
	if (FAILED(hr = varType.ChangeType(VT_I2, &typ))) {
		return hr;
	}

	CComVariant varRet;
	varRet = (long)::GetSysColor(varType.iVal);
	return varRet.Detach(col);
}

STDMETHODIMP COverlappedWindow::SetTimer(VARIANT tim, BOOL* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	long timer = 0;

	CComVariant varTim;
	if (SUCCEEDED(varTim.ChangeType(VT_I4, &tim))) {
		timer = varTim.lVal;
	}

	if (timer) {
		*pVal = ::SetTimer(m_hPopupWnd, 1, timer, NULL) ? VB_TRUE : VB_FALSE;

	}
	else {
		*pVal = ::KillTimer(m_hPopupWnd, 1) ? VB_TRUE : VB_FALSE;
	}
	return S_OK;
}


STDMETHODIMP COverlappedWindow::CheckMenu(VARIANT cmd, VARIANT mode)
{
	SafeCreateWnd();
	if (!m_hMenu) {
		return Error(IDS_ERR_NOCREATEMENU);
	}

	int nCmd = 0;
	CComVariant varCmd;
	if (SUCCEEDED(varCmd.ChangeType(VT_I2, &cmd))) {
		nCmd = varCmd.iVal;
	}

	int nMode = 0;
	CComVariant varMode;
	if (SUCCEEDED(varMode.ChangeType(VT_I2, &mode))) {
		nMode = varMode.iVal;
	}

	if (nCmd >= 100) {
		// j[R}h100ȏł̂ŁB
		MENUITEMINFO inf = { 0 };
		inf.cbSize = sizeof(MENUITEMINFO);
		inf.fMask = MIIM_STATE;
		inf.fState = nMode ? MFS_CHECKED : MFS_UNCHECKED;
		::SetMenuItemInfo(m_hMenu, nCmd, false, &inf);
	}

	return S_OK;
}

STDMETHODIMP COverlappedWindow::EnableMenu(VARIANT cmd, VARIANT mode)
{
	SafeCreateWnd();
	if (!m_hMenu) {
		return Error(IDS_ERR_NOCREATEMENU);
	}

	int nCmd = 0;
	CComVariant varCmd;
	if (SUCCEEDED(varCmd.ChangeType(VT_I2, &cmd))) {
		nCmd = varCmd.iVal;
	}

	int nMode = 0;
	CComVariant varMode;
	if (SUCCEEDED(varMode.ChangeType(VT_I2, &mode))) {
		nMode = varMode.iVal;
	}

	if (nCmd >= 100) {
		// j[R}h100ȏł̂ŁB
		MENUITEMINFO inf = { 0 };
		inf.cbSize = sizeof(MENUITEMINFO);
		inf.fMask = MIIM_STATE;
		inf.fState = nMode ? MFS_ENABLED : MFS_GRAYED;
		::SetMenuItemInfo(m_hMenu, nCmd, false, &inf);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_CreateNoCloseWindow(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	// N[Y֎~EBhE?
	*pVal = windowParam.noclose ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_CreateNoCloseWindow(BOOL newVal)
{
	if (m_hPopupWnd) {
		// EBhE쐬ɂ͎włȂ
		return Error(IDS_ERR_CREATEDWND);
	}
	windowParam.noclose = newVal;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Canvas(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	// h[COC^[tFCXn
	::VariantInit(pVal);

	if (m_pCanvas) {
		HRESULT hr;
		CComPtr<IUnknown> pUnk;
		if (FAILED(hr = m_pCanvas->QueryInterface(&pUnk))) {
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk.Detach();
	}

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Event(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	::VariantInit(pVal);

	if (m_pEvent) {
		// CxgC^[tFCX̎擾
		HRESULT hr;
		CComPtr<IUnknown> pUnk;
		if (FAILED(hr = m_pEvent->QueryInterface(&pUnk))) {
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk.Detach();
	}

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_DropFiles(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	return m_dropfiles.GetPathArray(pVal);
}

STDMETHODIMP COverlappedWindow::get_Quit(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = m_bQuit ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Quit(BOOL newVal)
{
	m_bQuit = newVal;
	if (m_hPopupWnd) {
		// Cxg𔭐ҋ@Ԃ
		SetEvent(m_hWaitEvent);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Form(VARIANT *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	// tH[̌J
	::VariantInit(pVal);

	if (m_pForm) {
		HRESULT hr;
		CComPtr<IUnknown> pUnk;
		if (FAILED(hr = m_pForm->QueryInterface(&pUnk))) {
			return hr;
		}
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk.Detach();
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Style(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	DWORD style;
	if (m_hPopupWnd) {
		style = ::GetWindowLong(m_hPopupWnd, GWL_STYLE);

	}
	else {
		style = windowParam.ComputeStyle();
	}

	*pVal = (long)style;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Style(long newVal)
{
	if (m_hPopupWnd) {
		::SetWindowLong(m_hPopupWnd, GWL_STYLE, (DWORD)newVal);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_Exstyle(long *pVal)
{
	if (m_hPopupWnd) {
		windowParam.exstyle = ::GetWindowLong(m_hPopupWnd, GWL_EXSTYLE);
	}
	*pVal = (long)windowParam.exstyle;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_Exstyle(long newVal)
{
	windowParam.exstyle = (DWORD)newVal;
	if (m_hPopupWnd) {
		::SetWindowLong(m_hPopupWnd, GWL_STYLE, windowParam.exstyle);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_WindowClassName(BSTR *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	CComBSTR tmp(windowParam.szClassName);
	*pVal = tmp.Detach();
	return S_OK;
}

STDMETHODIMP COverlappedWindow::Refresh()
{
	if (m_hPopupWnd) {
		::SetWindowPos(
			m_hPopupWnd,
			NULL,
			0, 0, 0, 0,
			SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_DRAWFRAME | SWP_FRAMECHANGED | SWP_NOCOPYBITS);
	}
	return S_OK;
}

void COverlappedWindow::SetTitle()
{
	if (!m_hPopupWnd) {
		return;
	}
	ATL::CString tmp(m_bstrCaption);
	::SetWindowText(m_hPopupWnd, tmp);
}

STDMETHODIMP COverlappedWindow::SetPlacement(VARIANT x, VARIANT y, VARIANT w, VARIANT h, VARIANT *pvarUnk)
{
	// TCYύX
	CComVariant varX, varY, varW, varH;
	UINT flag = SWP_NOZORDER | SWP_NOMOVE | SWP_NOSIZE;
	if ((x.vt != VT_EMPTY && x.vt != VT_NULL && x.vt != VT_ERROR) && varX.ChangeType(VT_I2, &x) == S_OK) {
		windowParam.posX = varX.iVal;
		flag &= ~SWP_NOMOVE;
	}
	if ((y.vt != VT_EMPTY && y.vt != VT_NULL && y.vt != VT_ERROR) && varY.ChangeType(VT_I2, &y) == S_OK) {
		windowParam.posY = varY.iVal;
		flag &= ~SWP_NOMOVE;
	}
	if ((w.vt != VT_EMPTY && w.vt != VT_NULL && w.vt != VT_ERROR) && varW.ChangeType(VT_I2, &w) == S_OK) {
		windowParam.width = varW.iVal;
		flag &= ~SWP_NOSIZE;
	}
	if ((h.vt != VT_EMPTY && h.vt != VT_NULL && h.vt != VT_ERROR) && varH.ChangeType(VT_I2, &h) == S_OK) {
		windowParam.height = varH.iVal;
		flag &= ~SWP_NOSIZE;
	}
	// EBhE\Ă΂ɔf
	if (m_hPopupWnd) {
		::SetWindowPos(m_hPopupWnd, NULL, windowParam.posX, windowParam.posY, windowParam.width, windowParam.height, flag);
	}
	if (m_pForm) {
		// tH[̃TCYύX
		m_pForm->SetWindowSize(windowParam.width, windowParam.height,
			windowParam.ComputeStyle(), windowParam.exstyle);
	}
	CreateThisInterface(pvarUnk);
	return S_OK;
}

void COverlappedWindow::CreateThisInterface(VARIANT* pvarUnk)
{
	ATLASSERT(pvarUnk != NULL);

	// ̃C^[tFCXԂ
	::VariantInit(pvarUnk);

	CComPtr<IUnknown> pUnk;
	HRESULT hr = QueryInterface(IID_IUnknown, (void**)&pUnk);
	ATLASSERT(SUCCEEDED(hr));

	pvarUnk->vt = VT_UNKNOWN;
	pvarUnk->punkVal = pUnk.Detach();
}

STDMETHODIMP COverlappedWindow::SetWindowStyle(VARIANT frametype, VARIANT caption_system, VARIANT maxmin, VARIANT *pvarUnk)
{
	CComVariant varFrametype, varCaptionSystem, varMaxMin;
	if (frametype.vt != VT_EMPTY && frametype.vt != VT_ERROR && frametype.vt != VT_NULL
		&& varFrametype.ChangeType(VT_I2, &frametype) == S_OK) {
		windowParam.frametype = varFrametype.iVal;
	}
	if (caption_system.vt != VT_EMPTY && caption_system.vt != VT_ERROR && caption_system.vt != VT_NULL
		&& varCaptionSystem.ChangeType(VT_I2, &caption_system) == S_OK) {
		windowParam.captionbar = (varCaptionSystem.iVal > 0);
		windowParam.systemmenu = (varCaptionSystem.iVal > 1);
	}
	if (maxmin.vt != VT_EMPTY && maxmin.vt != VT_ERROR && maxmin.vt != VT_NULL
		&& varMaxMin.ChangeType(VT_I2, &maxmin) == S_OK) {
		windowParam.minbox = (varMaxMin.iVal & 0x01);
		windowParam.maxbox = (varMaxMin.iVal & 0x02);
	}
	if (m_hPopupWnd) {
		::SetWindowLong(m_hPopupWnd, GWL_STYLE, windowParam.ComputeStyle());
		Refresh();
	}
	CreateThisInterface(pvarUnk);
	return S_OK;
}

void COverlappedWindow::PurgeUnusedWindows()
{
	// QƃJEg1ȂEBhE̔js
	std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstChild.begin();
	while (p != m_lstChild.end()) {
		DWORD refCount = (*p)->m_dwRef;
		if ((*p)->m_dwRef == 1) {
			// QƃJEg1Ȃ = ̃NXgĂȂ = sv
			BOOL bVisible = false;
			(*p)->get_Visible(&bVisible);
			if (!bVisible) {
				// \ĂȂΏĂ悵B
				(*p)->Release();
				p = m_lstChild.erase(p);
				continue;
			}
		}
		p++;
	}
}


STDMETHODIMP COverlappedWindow::CreateChild(VARIANT *pvarUnk)
{
	if (!pvarUnk) {
		return E_POINTER;
	}

	SafeCreateWnd();
	::VariantInit(pvarUnk);

	// gp̃EBhE폜
	PurgeUnusedWindows();

	// IuWFNg̍쐬
	CComObject<COverlappedWindow>* pChild = NULL;
	HRESULT hr;
	if (FAILED(hr = CComObject<COverlappedWindow>::CreateInstance(&pChild))) {
		return hr;
	}

	// ԋppC^[tFCX̎擾
	CComPtr<IUnknown> pUnk;
	if (FAILED(hr = pChild->QueryInterface(&pUnk))) {
		delete pChild;
		return hr;
	}

	pChild->SetParent(m_hPopupWnd);
	pChild->put_WaitCursor(m_dWaitCursor);

	// Xgɕۑ邽ߎQƃJEg+1.
	pChild->AddRef();
	m_lstChild.push_back(pChild);

	// C^[tFCXԂ
	pvarUnk->vt = VT_UNKNOWN;
	pvarUnk->punkVal = pUnk.Detach();
	return S_OK;
}

void COverlappedWindow::SetParent(HWND hParent)
{
	m_hParentWnd = hParent;
}

HANDLE COverlappedWindow::GetEventHandle()
{
	return m_hWaitEvent;
}

void COverlappedWindow::SetWaitParam(int *count, HWND *hWnd, HANDLE *hEvent)
{
	// ׂĂ̎qI[o[bvEBhẼCxgnh擾
	if (*count < MAXIMUM_WAIT_OBJECTS) {
		// go^
		hEvent[*count] = m_hWaitEvent;
		hWnd[*count] = m_hPopupWnd;
		(*count)++;
		// `Cho^
		std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstChild.begin();
		while ((p != m_lstChild.end()) && (*count < MAXIMUM_WAIT_OBJECTS)) {
			// `ChL`ChċNIɌĂяo
			(*p)->SetWaitParam(count, hWnd, hEvent);
			p++;
		}
	}
}

DWORD COverlappedWindow::MessageLoop(DWORD sleeptim, int cnt, HWND *hWnd, HANDLE* hEvent)
{
	// bZ[W[v
	DWORD ret = 0;
	DWORD retWait = MsgWaitForMultipleObjects(cnt, hEvent, false, sleeptim, QS_ALLEVENTS | QS_ALLINPUT);

	if (retWait != WAIT_TIMEOUT) {
		ret = 0;
		if (retWait >= WAIT_OBJECT_0 && retWait < WAIT_OBJECT_0 + cnt) {
			// Cxg̔nhʂ
			ret = retWait - WAIT_OBJECT_0 + 1;
		}
		//
		MSG msg;
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			BOOL bTranslated = false;
			HWND hOwner = NULL;
			if (msg.hwnd) {
				// bZ[WI[i[EBhETo
				HWND hParent = msg.hwnd;
				while (!hOwner && hParent) {
					int i;
					for (i = 0; i < cnt && hWnd[i]; i++) {
						if (hParent == hWnd[i]) {
							hOwner = hWnd[i];
							break;
						}
					}
					hParent = ::GetParent(hParent);
				}
			}
			if (hOwner) {
				BOOL bTranslatedDlg = false;
				if (msg.message == WM_KEYDOWN) {
					// ƂÃ݂L[R[hEBhEvVWɏ
					::SendMessage(hOwner, WM_KEYDOWN_EX, msg.wParam, msg.lParam);
					bTranslated = true;
					// _CAOǂs
					BOOL bShift = GetKeyState(VK_SHIFT) & 0x8000;
					BOOL bCtrl = GetKeyState(VK_CONTROL) & 0x8000;
					if (msg.wParam == VK_TAB) {
						// TAB = MOVE FOCUS 
						if (!bCtrl) {
							HWND hNextFocus = ::GetNextDlgTabItem(hOwner, GetFocus(), bShift);
							if (hNextFocus) {
								::SetFocus(hNextFocus);
							}
						}
						bTranslatedDlg = true;
					}
					else if (msg.wParam == VK_F6) {
						// ESCAPE = CANCEL
						SendMessage(hOwner, WM_MOVENEXT_OVERLAPPED, 0, 0);
						bTranslatedDlg = true;
					}
				}
				if (!bTranslatedDlg) {
					bTranslated |= ::IsDialogMessage(hOwner, &msg);
				}
			}
			if (!bTranslated) {
				::TranslateMessage(&msg);
				::DispatchMessage(&msg);
			}
		}
	}
	return ret;
}

STDMETHODIMP COverlappedWindow::get_AutoMessageLoop(BOOL *pVal)
{
	*pVal = windowParam.automessageloop ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_AutoMessageLoop(BOOL newVal)
{
	windowParam.automessageloop = newVal;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::DoModal(VARIANT* pRetCode)
{
	CComVariant dmy, retdmy;
	dmy.vt = VT_ERROR;
	dmy.scode = DISP_E_PARAMNOTFOUND;
	Open(dmy, &retdmy);

	CComVariant tim = (short)1000;
	BOOL ret;
	while (!m_bQuit && ::IsWindow(m_hPopupWnd)) {
		WaitEvent(tim, &ret);
		if (ret) {
			DoEvent(&dmy);
		}
	}
	Close();

	::VariantInit(pRetCode);
	pRetCode->vt = VT_I2;
	pRetCode->iVal = m_dModalExitCode;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_AutoClose(BOOL *pVal)
{
	*pVal = windowParam.autoclose ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_AutoClose(BOOL newVal)
{
	windowParam.autoclose = newVal;
	return S_OK;
}

void COverlappedWindow::CreateWindowList(std::list<HWND>& lstWnd, BOOL bSearchRoot)
{
	HWND* hWnds = NULL;
	if (m_hParentWnd && bSearchRoot) {
		// łȂ΁Aɖ₢킹
		COverlappedWindow* pParent = (COverlappedWindow*)::GetWindowLongPtr(m_hParentWnd, GWLP_USERDATA);
		if (pParent) {
			pParent->CreateWindowList(lstWnd, true);
		}
	}
	else {
		// ł
		std::list<CComObject<COverlappedWindow>*>::iterator p = m_lstChild.begin();
		DWORD stl = ::GetWindowLong(m_hPopupWnd, GWL_STYLE);
		if (stl & WS_VISIBLE) {
			// \ĂEBhÊ݂o^
			lstWnd.push_back(m_hPopupWnd);
		}
		while (p != m_lstChild.end()) {
			// ׂĂ̎qI[o[bv񋓂
			HWND hWnd = NULL;
			(*p)->get_HWND((long*)&hWnd);
			if (hWnd && ::IsWindow(hWnd)) {
				(*p)->CreateWindowList(lstWnd, false);
			}
			p++;
		}
	}
}

void COverlappedWindow::MoveNextOverlapped()
{
	// Xg̐˗
	std::list<HWND>lstWnd;
	CreateWindowList(lstWnd, true);
	// ݈ʒuc
	HWND hActiveWnd = ::GetActiveWindow();
	std::list<HWND>::iterator p = lstWnd.begin();
	while (p != lstWnd.end()) {
		// 
		if (hActiveWnd == *p) {
			// ANeBuEBhE𔭌
			p++;
			HWND hNext = lstWnd.front();
			if (p != lstWnd.end()) {
				hNext = *p;
			}
			//			::SetActiveWindow(hNext);
			::SetFocus(hNext);
			break;
		}
		p++;
	}
}

STDMETHODIMP COverlappedWindow::get_Object(VARIANT idx, VARIANT *pVal)
{
	// I[o[bvIuWFNgɃoCh邱Ƃ̂łAzz
	::VariantInit(pVal);
	pVal->vt = VT_UNKNOWN;
	m_pObject->QueryInterface(IID_IUnknown, (void**)&(pVal->punkVal));
	return S_OK;
}


STDMETHODIMP COverlappedWindow::get_ExitCode(short *pVal)
{
	*pVal = (short)m_dModalExitCode;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_ExitCode(short newVal)
{
	m_dModalExitCode = newVal;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_WaitCursor(short *pVal)
{
	*pVal = (short)m_dWaitCursor;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_WaitCursor(short newVal)
{
	m_dWaitCursor = newVal;
	if (m_hPopupWnd) {
		::SendMessage(m_hPopupWnd, WM_SETCURSOR, (WPARAM)m_hPopupWnd, 0);
	}
	// `ChĂꍇ́A`ChɂEFCgJ[\Kp
	std::list<CComObject<COverlappedWindow>*>::iterator pWnd = m_lstChild.begin();
	while (pWnd != m_lstChild.end()) {
		(*pWnd)->put_WaitCursor(newVal);
		pWnd++;
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::LoadIcon(VARIANT text)
{
	CComVariant varText;
	if (varText.ChangeType(VT_BSTR, &text) != S_OK) {
		return DISP_E_TYPEMISMATCH;
	}
	ATL::CString szPath(varText.bstrVal);

	if (m_hIcon) {
		DestroyIcon(m_hIcon);
		m_hIcon = NULL;
	}
	m_hIcon = (HICON)LoadImage(NULL, szPath, IMAGE_ICON,
		GetSystemMetrics(SM_CXSMICON),
		GetSystemMetrics(SM_CYSMICON),
		LR_LOADFROMFILE);

	if (m_hIcon && m_hPopupWnd) {
		::SendMessage(m_hPopupWnd, WM_SETICON, false, (LPARAM)m_hIcon);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::CenterWindow()
{
	SafeCreateWnd();
	RECT rct;
	if (m_hParentWnd) {
		// eEBhE΁A̒Ɉʒu킹
		::GetWindowRect(m_hParentWnd, &rct);

	}
	else {
		HWND hwnd = ::GetDesktopWindow();
		if (!hwnd) {
			return S_OK;
		}
		::GetWindowRect(hwnd, &rct);
	}

	int x = rct.left + (rct.right - rct.left) / 2 - windowParam.width / 2;
	int y = rct.top + (rct.bottom - rct.top) / 2 - windowParam.height / 2;
	WINDOWPLACEMENT pls = { 0 };
	pls.length = sizeof(WINDOWPLACEMENT);
	pls.rcNormalPosition.top = y;
	pls.rcNormalPosition.left = x;
	pls.rcNormalPosition.bottom = y + windowParam.height;
	pls.rcNormalPosition.right = x + windowParam.width;
	::SetWindowPlacement(m_hPopupWnd, &pls);

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_ClassObject(VARIANT* pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	::VariantInit(pVal);
	if (m_pClassDisp) {
		CComVariant tmp(m_pClassDisp);
		return tmp.Detach(pVal);
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_ClassObject(VARIANT newVal)
{
	if (m_pClassDisp) {
		// ݂̎QƂ.
		m_pClassDisp.Release();
	}

	if (newVal.vt == VT_EMPTY || newVal.vt == VT_ERROR || newVal.vt == VT_NULL) {
		// ȗ܂NULL, EMPTY̏ꍇ͎QƉ̂
		return S_FALSE;
	}

	if (newVal.vt != VT_DISPATCH) {
		// DISPATCHC^[tFCXȊOw肳ꂽꍇ
		return DISP_E_TYPEMISMATCH;
	}

	m_pClassDisp = newVal.pdispVal;

	return S_OK;
}

HRESULT COverlappedWindow::ClassObjectInvoke(LPCWSTR handler)
{
	if (!m_pClassDisp) {
		return S_FALSE;
	}

	HRESULT hr;

	DISPID dispid;
	if (FAILED(hr = m_pClassDisp->GetIDsOfNames(IID_NULL,
			(LPWSTR*)&handler, 1, LOCALE_SYSTEM_DEFAULT, &dispid))) {
		return hr;
	}

	DISPPARAMS dispparamsNoArgs = { NULL, NULL, 0, 0 };

	return m_pClassDisp->Invoke(dispid,
		IID_NULL, LOCALE_SYSTEM_DEFAULT, DISPATCH_METHOD,
		&dispparamsNoArgs, NULL, NULL, NULL);
}

STDMETHODIMP COverlappedWindow::get_ClientWidth(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	SafeCreateWnd();

	RECT rct;
	::GetClientRect(m_hPopupWnd, &rct);

	*pVal = rct.right;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_ClientHeight(long *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}
	SafeCreateWnd();

	RECT rct;
	::GetClientRect(m_hPopupWnd, &rct);

	*pVal = rct.bottom;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_innerWidth(double *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	RECT rct;
	::GetClientRect(m_hPopupWnd, &rct);

	POINT pt = { rct.right, 0 - rct.bottom };

	HDC hdc = ::GetWindowDC(m_hPopupWnd);

	int md = ::GetMapMode(hdc);
	::SetMapMode(hdc, MM_LOMETRIC); // _Pʂ0.1mm֕ϊ
	::DPtoLP(hdc, &pt, 1);
	::SetMapMode(hdc, md);
	::ReleaseDC(m_hPopupWnd, hdc);

	*pVal = pt.x / 10.; // ~Pʂ

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_innerHeight(double *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	SafeCreateWnd();

	RECT rct;
	::GetClientRect(m_hPopupWnd, &rct);

	POINT pt = { rct.right, 0 - rct.bottom };

	HDC hdc = ::GetWindowDC(m_hPopupWnd);

	int md = ::GetMapMode(hdc);
	::SetMapMode(hdc, MM_LOMETRIC);// _Pʂ0.1mm֕ϊ
	::DPtoLP(hdc, &pt, 1);
	::SetMapMode(hdc, md);
	::ReleaseDC(m_hPopupWnd, hdc);

	*pVal = pt.y / 10.; // ~Pʂ

	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_AutoReleaseClassObject(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = m_bAutoReleaseClassObject ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_AutoReleaseClassObject(BOOL newVal)
{
	m_bAutoReleaseClassObject = newVal;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::get_DefaultAction(BOOL *pVal)
{
	if (!pVal) {
		return E_POINTER;
	}

	*pVal = m_bDefaultAction ? VB_TRUE : VB_FALSE;

	return S_OK;
}

STDMETHODIMP COverlappedWindow::put_DefaultAction(BOOL newVal)
{
	m_bDefaultAction = newVal;
	return S_OK;
}

STDMETHODIMP COverlappedWindow::SetClipboardText(BSTR text)
{
	SafeCreateWnd();
	if (::OpenClipboard(m_hPopupWnd)) {
		::EmptyClipboard();
		if (text) {
			int len = SysStringByteLen(text);
			HGLOBAL hGlobal = GlobalAlloc(GMEM_DDESHARE, (len + 1) * sizeof(WCHAR));
			LPWSTR p = (LPWSTR)GlobalLock(hGlobal);
			StringCchCopyW(p, len + 1, text);
			GlobalUnlock(hGlobal);
			::SetClipboardData(CF_UNICODETEXT, hGlobal);
		}
		::CloseClipboard();
	}
	return S_OK;
}

STDMETHODIMP COverlappedWindow::GetClipboardText(VARIANT *pVarText)
{
	SafeCreateWnd();
	::VariantInit(pVarText);
	if (::OpenClipboard(m_hPopupWnd)) {
		if (IsClipboardFormatAvailable(CF_UNICODETEXT)) {
			// UNICODE񂪂΁AD悵Ď擾
			HGLOBAL hGlobal = ::GetClipboardData(CF_UNICODETEXT);
			if (hGlobal) {
				LPCWSTR p = (LPCWSTR)GlobalLock(hGlobal);
				if (p) {
					CComBSTR wstr(p);
					GlobalUnlock(hGlobal);
					pVarText->bstrVal = wstr.Detach();
					pVarText->vt = VT_BSTR;
				}
			}

		}
		else if (IsClipboardFormatAvailable(CF_TEXT)) {
			// UNICODE񂪂Ȃꍇ
			HGLOBAL hGlobal = ::GetClipboardData(CF_TEXT);
			if (hGlobal) {
				LPCSTR p = (LPCSTR)GlobalLock(hGlobal);
				if (p) {
					CComBSTR wstr(p);
					GlobalUnlock(hGlobal);
					pVarText->bstrVal = wstr.Detach();
					pVarText->vt = VT_BSTR;
				}
			}
		}
		::CloseClipboard();
	}
	return S_OK;
}
