// PrivateProfile.cpp : CPrivateProfile ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "PrivateProfile.h"
#include "profilesection.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CPrivateProfile

STDMETHODIMP CPrivateProfile::get_ProfilePath(BSTR *pVal)
{
	return m_bstr_profilepath.CopyTo(pVal);
}

STDMETHODIMP CPrivateProfile::put_ProfilePath(BSTR newVal)
{
	m_bstr_profilepath = newVal;
	return S_OK;
}

STDMETHODIMP CPrivateProfile::OpenSection(VARIANT text, VARIANT* pVal)
{
	::VariantInit(pVal);
	CComVariant varText;

	HRESULT hr;
	if (FAILED(hr = varText.ChangeType(VT_BSTR, &text))) {
		return hr;
	}

	if (m_bstr_profilepath.Length() <= 0) {
		return Error(IDS_ERR_PROFILEPATH);
	}

	CComObject<CProfileSection>* pSection = NULL;
	if (FAILED(hr = CComObject<CProfileSection>::CreateInstance(&pSection))) {
		return hr;
	}
	ATLASSERT(pSection);

	CComPtr<IUnknown> pUnk = NULL;
	if (FAILED(hr = pSection->QueryInterface(&pUnk))) {
		delete pSection;
		return hr;
	}
	ATLASSERT(pUnk);

	pSection->m_szProfilePath = m_bstr_profilepath;
	pSection->m_szSectionName = varText.bstrVal;

	pVal->vt = VT_UNKNOWN;
	pVal->punkVal = pUnk.Detach();
	return S_OK;
}
