// Shell.cpp : CShell ̃Cve[V
#include "stdafx.h"

#include "SeraphyScriptTools.h"
#include "Shell.h"
#include "generic.h"

#include <list>
#include <vector>

#pragma comment(lib, "Version.lib")

/////////////////////////////////////////////////////////////////////////////
// CShell

STDMETHODIMP CShell::ShellExecute(VARIANT path, VARIANT param, VARIANT initdir, VARIANT show, VARIANT *punkVal)
{
	ATL::CString szPath;
	CComVariant varPath;
	if (varPath.ChangeType(VT_BSTR, &path) == S_OK) {
		szPath = varPath.bstrVal;
	}

	ATL::CString szParam;
	CComVariant varParam;
	if (varParam.ChangeType(VT_BSTR, &param) == S_OK) {
		szParam = varParam.bstrVal;
	}

	ATL::CString szInitDir;
	CComVariant varInitDir;
	if (varInitDir.ChangeType(VT_BSTR, &initdir) == S_OK) {
		szInitDir = varInitDir.bstrVal;
	}

	int nShow = SW_SHOWNORMAL;
	CComVariant varMode;
	if (varMode.ChangeType(VT_I2, &show) == S_OK) {
		switch (varMode.iVal) {
			case 0:
			nShow = SW_HIDE;
			break;

			case 1:
			default:
			nShow = SW_SHOWNORMAL;
			break;

			case 2:
			nShow = SW_SHOWMAXIMIZED;
			break;

			case 3:
			nShow = SW_SHOWMINIMIZED;
			break;

			case 4:
			nShow = SW_SHOWMINNOACTIVE;
			break;
		}
	}

	//
	SHELLEXECUTEINFO info = {0};
	info.cbSize = sizeof(SHELLEXECUTEINFO);
	info.fMask = SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	info.hwnd = GetMainWindow();
	info.lpVerb = _TEXT("OPEN");
	info.lpFile = szPath;
	info.lpParameters = szParam;
	info.lpDirectory = szInitDir;
	info.nShow = nShow;
	if (ShellExecuteEx(&info)) {
		// ShellExecObj̐
		HRESULT hr;
		CComObject<CShellExecObj>* pExec = NULL;
		if (FAILED(hr = CComObject<CShellExecObj>::CreateInstance(&pExec))) {
			return hr;
		}
		pExec->m_hProcess = info.hProcess;
		
		IUnknown* pUnk = NULL;
		if (FAILED(hr = pExec->QueryInterface(&pUnk))) {
			delete pExec;
			return hr;
		}
		punkVal->vt = VT_UNKNOWN;
		punkVal->punkVal = pUnk;
	}
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CShellExecObj


STDMETHODIMP CShellExecObj::Wait(VARIANT tim, VARIANT *pVal)
{
	::VariantInit(pVal);
	BOOL bExit = true;
	if (m_hProcess) {
		CComVariant varTim;
		DWORD dwWaitTime = 0;
		if (varTim.ChangeType(VT_I4, &tim) == S_OK) {
			if (varTim.lVal < 0) {
				// ܂
				dwWaitTime = INFINITE;
			}
			else {
				dwWaitTime = (DWORD)varTim.lVal;
			}
		}
		DWORD ret = WaitForSingleObject(m_hProcess, dwWaitTime);
		if (ret == WAIT_TIMEOUT) {
			// vZX͏IĂȂ
			bExit = false;
		}
	}
	pVal->vt = VT_BOOL;
	pVal->boolVal = bExit ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CShellExecObj::get_ExitCode(long *pVal)
{
	if (m_hProcess) {
		GetExitCodeProcess(m_hProcess, (DWORD*)pVal);
	}
	return S_OK;
}

class SPECIALFOLDERPAIR
{
public:
	SPECIALFOLDERPAIR(LPCTSTR arg_name, int arg_id) {
		name = arg_name;
		id = arg_id;
	}
	LPCTSTR name;
	int id;
};

STDMETHODIMP CShell::GetSpecialFolderLocations(IUnknown *punkVal)
{
	if (!punkVal) {
		return E_FAIL;
	}

	IObjectMap* pMap = NULL;
	if (punkVal->QueryInterface(IID_IObjectMap, (void**)&pMap) != S_OK) {
		return DISP_E_TYPEMISMATCH;
	}

	// VXeo[W`FbN
	BOOL bWinNT;
	get_IsWindowNT(&bWinNT);
	// NTn̏ꍇ9xn̏ꍇƂ͎擾łtH_̎ނ̂ŕĂ
	std::list<SPECIALFOLDERPAIR> lst;
	if (bWinNT) {
		// WINNT
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("ADMINTOOLS"), CSIDL_ADMINTOOLS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("ALTSTARTUP"), CSIDL_ALTSTARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("APPDATA"), CSIDL_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_ADMINTOOLS"), CSIDL_COMMON_ADMINTOOLS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_ALTSTARTUP"), CSIDL_COMMON_ALTSTARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_APPDATA"), CSIDL_COMMON_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_DESKTOPDIRECTORY"), CSIDL_COMMON_DESKTOPDIRECTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_DOCUMENTS"), CSIDL_COMMON_DOCUMENTS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_FAVORITES"), CSIDL_COMMON_FAVORITES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_PROGRAMS"), CSIDL_COMMON_PROGRAMS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_STARTMENU"), CSIDL_COMMON_STARTMENU));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_STARTUP"), CSIDL_COMMON_STARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_TEMPLATES"), CSIDL_COMMON_TEMPLATES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COOKIES"), CSIDL_COOKIES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("DESKTOPDIRECTORY"), CSIDL_DESKTOPDIRECTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("FAVORITES"), CSIDL_FAVORITES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("FONTS"), CSIDL_FONTS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("HISTORY"), CSIDL_HISTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("INTERNET_CACHE"), CSIDL_INTERNET_CACHE));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("LOCAL_APPDATA"), CSIDL_LOCAL_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("MYPICTURES"), CSIDL_MYPICTURES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("NETHOOD"), CSIDL_NETHOOD));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PERSONAL"), CSIDL_PERSONAL));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PRINTHOOD"), CSIDL_PRINTHOOD));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROFILE"), CSIDL_PROFILE));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAM_FILES"), CSIDL_PROGRAM_FILES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAM_FILES_COMMON"), CSIDL_PROGRAM_FILES_COMMON));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAMS"), CSIDL_PROGRAMS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("RECENT"), CSIDL_RECENT));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("SENDTO"), CSIDL_SENDTO));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("STARTMENU"), CSIDL_STARTMENU));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("STARTUP"), CSIDL_STARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("SYSTEM"), CSIDL_SYSTEM));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("TEMPLATES"), CSIDL_TEMPLATES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("WINDOWS"), CSIDL_WINDOWS));
	}
	else {
		// Win9x
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("ADMINTOOLS"), CSIDL_ADMINTOOLS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("ALTSTARTUP"), CSIDL_ALTSTARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("APPDATA"), CSIDL_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_ADMINTOOLS"), CSIDL_ADMINTOOLS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_ALTSTARTUP"), CSIDL_ALTSTARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_APPDATA"), CSIDL_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_DESKTOPDIRECTORY"), CSIDL_DESKTOPDIRECTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_DOCUMENTS"), CSIDL_COMMON_DOCUMENTS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_FAVORITES"), CSIDL_FAVORITES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_PROGRAMS"), CSIDL_PROGRAMS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_STARTMENU"), CSIDL_STARTMENU));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_STARTUP"), CSIDL_STARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COMMON_TEMPLATES"), CSIDL_TEMPLATES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("COOKIES"), CSIDL_COOKIES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("DESKTOPDIRECTORY"), CSIDL_DESKTOPDIRECTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("FAVORITES"), CSIDL_FAVORITES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("FONTS"), CSIDL_FONTS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("HISTORY"), CSIDL_HISTORY));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("INTERNET_CACHE"), CSIDL_INTERNET_CACHE));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("LOCAL_APPDATA"), CSIDL_LOCAL_APPDATA));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("MYPICTURES"), CSIDL_MYPICTURES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("NETHOOD"), CSIDL_NETHOOD));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PERSONAL"), CSIDL_PERSONAL));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PRINTHOOD"), CSIDL_PRINTHOOD));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROFILE"), CSIDL_PROFILE));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAM_FILES"), CSIDL_PROGRAM_FILES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAM_FILES_COMMON"), CSIDL_PROGRAM_FILES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("PROGRAMS"), CSIDL_PROGRAMS));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("RECENT"), CSIDL_RECENT));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("SENDTO"), CSIDL_SENDTO));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("STARTMENU"), CSIDL_STARTMENU));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("STARTUP"), CSIDL_STARTUP));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("SYSTEM"), CSIDL_SYSTEM));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("TEMPLATES"), CSIDL_TEMPLATES));
		lst.push_back(SPECIALFOLDERPAIR(_TEXT("WINDOWS"), CSIDL_WINDOWS));
	}

	std::list<SPECIALFOLDERPAIR>::iterator p = lst.begin();
	while (p != lst.end()) {
		LPITEMIDLIST pid = NULL;
		if (SHGetSpecialFolderLocation(NULL, (*p).id, &pid) == NOERROR) {
			TCHAR buf[MAX_PATH] = {0};
			if (SHGetPathFromIDList(pid, buf)) {
				CComVariant key((*p).name);
				CComVariant value(buf);
				pMap->put_Value(key, value);
			}
			m_pMalloc->Free(pid);
		}
		p++;
	}
	pMap->Release();
	return S_OK;
}

STDMETHODIMP CShell::get_IsWindowNT(BOOL *pVal)
{
	OSVERSIONINFO vinfo = {0};
	vinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&vinfo);
	*pVal = (vinfo.dwPlatformId == VER_PLATFORM_WIN32_NT);
	return S_OK;
}


STDMETHODIMP CShell::get_WindowsVersion(long *pVal)
{
	// win9x0ANT̓o[WԂ
	*pVal = 0;
	OSVERSIONINFO vinfo = {0};
	vinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&vinfo);
	if (vinfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		*pVal = (long)vinfo.dwMajorVersion;
	}
	return S_OK;
}

STDMETHODIMP CShell::GetDLLVersion(VARIANT text, VARIANT min, VARIANT *pVal)
{
	ATL::CString lpszDllName;
	CComVariant varText;
	if (varText.ChangeType(VT_BSTR, &text) == S_OK) {
		lpszDllName = varText.bstrVal;
	}

	BOOL bMin = false;
	CComVariant varMin;
	if (varMin.ChangeType(VT_I2, &min) == S_OK) {
		bMin = varMin.iVal;
	}

	CComVariant ret;
	DWORD siz = GetFileVersionInfoSize(lpszDllName, 0);
	if (siz) {
		std::vector<BYTE> buf(siz + 1);
		LPBYTE pBuf = &buf[0];
		if (GetFileVersionInfo(lpszDllName, 0, siz, pBuf)) {
			// o[W擾
			VS_FIXEDFILEINFO* pverInfo;
			UINT sz = 0;
			if (VerQueryValue(pBuf, _TEXT("\\"), (void**)&pverInfo, &sz)) {
				// o[WmF\ł
				TCHAR mes[256];
				if (bMin) {
					// ڍ
					wsprintf(mes, _TEXT("%d.%d.%d.%d"),
						HIWORD(pverInfo->dwFileVersionMS),
						LOWORD(pverInfo->dwFileVersionMS),
						HIWORD(pverInfo->dwFileVersionLS),
						LOWORD(pverInfo->dwFileVersionLS)
						);
				}
				else {
					// ʏ
					wsprintf(mes, _TEXT("%d.%d"),
						HIWORD(pverInfo->dwFileVersionMS),
						LOWORD(pverInfo->dwFileVersionMS)
						);
				}
				ret = mes;
			}
		}
	}
	ret.Detach(pVal);
	return S_OK;
}

STDMETHODIMP CShell::ParseName(VARIANT text, VARIANT *pVal)
{
	::VariantInit(pVal);

	HRESULT hr;
	CComVariant varText;
	if (FAILED(hr = varText.ChangeType(VT_BSTR, &text))) {
		return hr;
	}

	// COMIuWFNg̍쐬
	CComObject<CParseName>* pParse = NULL;
	if (FAILED(hr = CComObject<CParseName>::CreateInstance(&pParse))) {
		return hr;
	}

	// COMX}[g|C^ɕێ.([X)
	CComPtr<ISeraphyScriptTool_ParseName> pIntf;
	if (FAILED(hr = pParse->QueryInterface(
		IID_ISeraphyScriptTool_ParseName, reinterpret_cast<void**>(&pIntf)))) {
		delete pParse;
		return hr;
	}

	// pXݒ肷.
	if (FAILED(hr = pIntf->put_PathName(varText.bstrVal))) {
		return hr;
	}

	// IUnknownɕϊ
	IUnknown* pUnk = NULL;
	if (FAILED(hr = pIntf->QueryInterface(IID_IUnknown, (void**)&pUnk))) {
		return hr;
	}

	pVal->vt = VT_UNKNOWN;
	pVal->punkVal = pUnk;
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CParseName

STDMETHODIMP CParseName::get_PathName(BSTR *pVal)
{
	return m_bstr_path.CopyTo(pVal);
}

STDMETHODIMP CParseName::put_PathName(BSTR newVal)
{
	m_bstr_path = newVal;
	return S_OK;
}

STDMETHODIMP CParseName::get_FileName(BSTR *pVal)
{
	LPWSTR st = m_bstr_path;
	LPWSTR p = st;
	while (*p) p++;
	while (p > st) {
		if (*p == '\\' || *p == '/') {
			// ŏɔꂽtH_v[XŎ~܂
			p++;
			break;
		}
		p--;
	}
	*pVal = SysAllocString(p);
	return S_OK;
}

STDMETHODIMP CParseName::put_FileName(BSTR newVal)
{
	WCHAR buf[MAX_PATH];
	lstrcpyW(buf, m_bstr_path);
	LPWSTR p = buf;
	while (*p)p++;
	while (p > buf) {
		if (*p == '\\' || *p == '/') {
			// ŏɔꂽtH_v[XŎ~܂
			p++;
			break;
		}
		p--;
	}
	lstrcpyW(p, newVal);
	m_bstr_path = buf;
	return S_OK;
}

STDMETHODIMP CParseName::get_Extention(BSTR *pVal)
{
	BOOL bFind = false;
	LPWSTR p = m_bstr_path;
	while (*p)p++;
	while (p > (LPCWSTR)m_bstr_path) {
		if (*p == '.') {
			bFind = true;
			p++;
			break;
		}
		if (*p == '\\' || *p == '/') {
			// tH_v[XŒ~
			break;
		}
		p--;
	}
	if (!bFind) {
		while (*p) p++;
	}
	*pVal = SysAllocString(p);
	return S_OK;
}

STDMETHODIMP CParseName::put_Extention(BSTR newVal)
{
	WCHAR buf[MAX_PATH];
	lstrcpyW(buf, m_bstr_path);
	BOOL bFind = false;
	LPWSTR p = buf;
	while (*p) p++;
	while (p > buf) {
		if (*p == '.') {
			bFind = true;
			p++;
			break;
		}
		if (*p == '\\' || *p == '/') {
			// tH_v[XŒ~
			break;
		}
		p--;
	}
	if (!bFind) {
		// ȂΖɒǉ
		while (*p) p++;
		lstrcpyW(p, L".");
	}
	lstrcpyW(p, newVal);
	m_bstr_path = buf;
	return S_OK;
}

STDMETHODIMP CParseName::get_Name(BSTR *pVal)
{
	WCHAR buf[MAX_PATH];
	lstrcpyW(buf, m_bstr_path);
	LPWSTR p = buf;
	while (*p)p++;
	while (p > buf) {
		if (*p == '\\' || *p == '/') {
			p++;
			break;
		}
		p--;
	}
	LPWSTR p2 = p;
	while (*p2) {
		if (*p2 == '.') {
			*p2 = 0;
			break;
		}
		p2++;
	}
	*pVal = SysAllocString(p);
	return S_OK;
}

STDMETHODIMP CParseName::put_Name(BSTR newVal)
{
	WCHAR buf[MAX_PATH];
	WCHAR ext[MAX_PATH] = {0};
	lstrcpyW(buf, m_bstr_path);
	LPWSTR p = buf;
	while (*p)p++;
	while (p > buf) {
		if (*p == '\\' || *p == '/') {
			p++;
			break;
		}
		p--;
	}
	LPWSTR p2 = p;
	while (*p2) {
		if (*p2 == '.') {
			p2++;
			lstrcpyW(ext, p2);
			break;
		}
		p2++;
	}
	lstrcpyW(p, newVal);
	while (*p)p++;
	*p++ = '.';
	lstrcpyW(p, ext);
	m_bstr_path = buf;
	return S_OK;
}

STDMETHODIMP CParseName::get_Drive(BSTR *pVal)
{
	WCHAR buf[MAX_PATH];
	lstrcpyW(buf, m_bstr_path);
	LPWSTR p = buf;
	while (*p) {
		if (*p == ':') {
			// hCu؂A܂̓vgR𔭌
			*(p + 1) = 0;
			p = buf;
			break;
		}
		p++;
	}
	*pVal = SysAllocString(p);
	return S_OK;
}

STDMETHODIMP CParseName::put_Drive(BSTR newVal)
{
	WCHAR buf[MAX_PATH];
	lstrcpyW(buf, newVal);
	LPWSTR p2 = buf;
	while (*p2)p2++;
	LPWSTR p = m_bstr_path;
	BOOL bFind = false;
	while (*p) {
		if (*p == ':') {
			// hCu؂A܂̓vgR𔭌
			p++;
			bFind = true;
			break;
		}
		p++;
	}
	if (!bFind) {
		p = m_bstr_path;
	}
	lstrcpyW(p2, p);
	m_bstr_path = buf;
	return S_OK;
}

STDMETHODIMP CParseName::get_Directory(BSTR *pVal)
{
	WCHAR buf[MAX_PATH];
	LPWSTR p = m_bstr_path;
	BOOL bFind = false;
	while (*p) {
		if (*p == ':') {
			// hCu؂A܂̓vgR𔭌
			p++;
			bFind = true;
			break;
		}
		p++;
	}
	if (!bFind) {
		p = m_bstr_path;
	}
	lstrcpyW(buf, p);
	p = buf;
	while (*p)p++;
	while (p >= buf) {
		if (*p == '\\' || *p == '/') {
			// tH_vCX𔭌
			if (p - 1 > buf && (*(p - 1) == '\\' || *(p - 1) == '/')) {
				// lbg[NpXɓBꍇ͖
				break;
			}
			p++;
			*p = 0;
			break;
		}
		p--;
	}
	*pVal = SysAllocString(buf);
	return S_OK;
}

///////////////////////////////////////////////////

STDMETHODIMP CShell::get_Confirm(BOOL *pVal)
{
	*pVal = (m_bConfirm) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CShell::put_Confirm(BOOL newVal)
{
	m_bConfirm = newVal;
	return S_OK;
}

STDMETHODIMP CShell::get_Silent(BOOL *pVal)
{
	*pVal = (m_bSilent) ? VB_TRUE : VB_FALSE;
	return S_OK;
}

STDMETHODIMP CShell::put_Silent(BOOL newVal)
{
	m_bSilent = newVal;
	return S_OK;
}

STDMETHODIMP CShell::Copy(VARIANT from, VARIANT to, VARIANT *pVal)
{
	return FileOperationCore(FO_COPY, 0, &from, &to, pVal);
}

STDMETHODIMP CShell::CopyRenameOnCollision(VARIANT from, VARIANT to, VARIANT *pVal)
{
	return FileOperationCore(FO_COPY, FOF_RENAMEONCOLLISION, &from, &to, pVal);
}

STDMETHODIMP CShell::Move(VARIANT from, VARIANT to, VARIANT *pVal)
{
	return FileOperationCore(FO_MOVE, 0, &from, &to, pVal);
}

STDMETHODIMP CShell::Delete(VARIANT from, VARIANT *pVal)
{
	return FileOperationCore(FO_DELETE, 0, &from, NULL, pVal);
}

HRESULT CShell::FileOperationCore(UINT wFunc, FILEOP_FLAGS flag, VARIANT *from, VARIANT *to, VARIANT *pResult)
{
	::VariantInit(pResult);
	CComVariant result;

	ATL::CString szTo;
	if (to) {
		CComVariant varTo;
		if (to->vt != VT_NULL && to->vt != VT_ERROR || to->vt == VT_EMPTY
			|| varTo.ChangeType(VT_BSTR, to) != S_OK) {
			return DISP_E_TYPEMISMATCH;
		}
		szTo = varTo.bstrVal;
	}
	int len = szTo.GetLength();
	LPTSTR pTo = szTo.GetBufferSetLength(len + 2); // _ukI[
	pTo[len] = 0;
	pTo[len + 1] = 0;

	std::vector<TCHAR> buf;
	if (!CreateDNStringFromVariant(*from, buf)) {
		return DISP_E_TYPEMISMATCH;
	}

	SHFILEOPSTRUCT info = {0};
	info.fFlags = flag | FOF_ALLOWUNDO | (m_bSilent ? FOF_SILENT : 0) | (m_bConfirm ? 0 : (FOF_NOCONFIRMMKDIR | FOF_NOCONFIRMATION));
	info.hwnd = GetMainWindow();
	info.pFrom = &buf[0];
	info.pTo = pTo;
	info.wFunc = wFunc;
	int ret = SHFileOperation(&info);

	result = (bool)(!ret && !info.fAnyOperationsAborted);
	result.Detach(pResult);
	return S_OK;
}

bool CShell::CreateDNStringFromVariant(VARIANT &from, std::vector<TCHAR> &buf)
{
	CComVariant varFrom;

	// ɕϊ\H
	if (varFrom.ChangeType(VT_BSTR, &from) == S_OK) {
		ATL::CString tmp(varFrom.bstrVal);
		int bufsiz = tmp.GetLength() + 2; // _ukI[
		buf.resize(bufsiz, 0);
		LPTSTR pBuf = &buf[0];
		StringCchCopy(pBuf, bufsiz, tmp);
		return true;
	}

	// Unknown -> IObjectVector ɕϊ\?
	if (varFrom.ChangeType(VT_UNKNOWN, &from) == S_OK) {
		IObjectVector* pVector = NULL;
		if (varFrom.punkVal->QueryInterface(IID_IObjectVector, (void**)&pVector) != S_OK) {
			// IObjectVectorł͂ȂȂG[
			return false;
		}

		// z擾
		long mx = 0;
		pVector->get_Count(&mx);
		long cnt = 0;
		// zŜ̃TCY߂
		DWORD needsize = 0;
		for (cnt = 0; cnt < mx; cnt++) {
			CComVariant tmp;
			CComVariant idx((long)cnt);
			pVector->get_Value(idx, &tmp);
			if (tmp.ChangeType(VT_BSTR) != S_OK) {
				// ɕϊs\
				return false;
			}
			ATL::CString czTmp(tmp.bstrVal);
			needsize += czTmp.GetLength() + 1; // +1̓kI[
		}
		needsize += 1; // _ukI[

		// z_ukɓWJ
		buf.resize(needsize, 0);
		LPTSTR pBuf = &buf[0];
		LPTSTR p = pBuf;
		for (cnt = 0; cnt < mx; cnt++) {
			CComVariant tmp;
			CComVariant idx((long)cnt);
			if (SUCCEEDED(pVector->get_Value(idx, &tmp))) {
				if (tmp.ChangeType(VT_BSTR) == S_OK) {
					ATL::CString szTmp(tmp.bstrVal);
					StringCchCopy(p, needsize, szTmp);
					int len = szTmp.GetLength() + 1;
					p += len;
					needsize -= len;
				}
			}
		}
		*p = 0; // dobule null
		pVector->Release();
		return true;
	}

	// SafeArray?
	VARTYPE vt = VT_EMPTY;
	SAFEARRAY* pArray = GetArrayFromVariant(from, &vt);
	if (!pArray || vt != VT_VARIANT) {
		// SafeArrayłȂA^
		return false;
	}

	long lb = 0;
	long ub = 0;
	int dm = SafeArrayGetDim(pArray);
	SafeArrayGetLBound(pArray, 1, &lb); // ̓Y
	SafeArrayGetUBound(pArray, 1, &ub);
	if (dm != 1 || lb != 0) {
		// 1złȂA0x[XłȂ
		return false;
	}

	DWORD needsize = 0;
	long dim[1];
	// obt@ɕKvȃTCY߂
	for (long cnt = 0; cnt <= ub; cnt++) {
		CComVariant tmp;
		dim[0] = cnt;
		SafeArrayGetElement(pArray, dim, &tmp);
		if (tmp.ChangeType(VT_BSTR) != S_OK) {
			// ɕϊs\
			return NULL;
		}
		ATL::CString szTmp(tmp.bstrVal);
		needsize += szTmp.GetLength() + 1;
	}
	needsize += 1; // _ukI[

	// obt@mۂWJ
	buf.resize(needsize);
	LPTSTR pBuf = &buf[0];
	LPTSTR p = pBuf;
	for (long cnt = 0; cnt <= ub; cnt++) {
		CComVariant tmp;
		dim[0] = cnt;
		SafeArrayGetElement(pArray, dim, &tmp);
		if (tmp.ChangeType(VT_BSTR) != S_OK) {
			// ɕϊs\
			return NULL;
		}

		ATL::CString szTmp(tmp.bstrVal);
		StringCchCopy(p, needsize, szTmp);
		int len = szTmp.GetLength() + 1;
		p += len;
		needsize -= len;
	}
	*p = 0; // _ukI[
	return true;
}

STDMETHODIMP CShell::EmptyRecycleBin(VARIANT dir)
{
	LPCTSTR pTarget = NULL;

	if (dir.vt == VT_NULL || dir.vt == VT_ERROR || dir.vt == VT_EMPTY) {
		// ׂđΏۂƂ
		pTarget = NULL;
	}
	else {
		ATL::CString szPath;
		CComVariant varDir;
		if (varDir.ChangeType(VT_BSTR, &dir) == S_OK) {
			// ̃hCu^[Qbg
			szPath = varDir.bstrVal;
			if (!szPath.IsEmpty()) {
				// 󕶎łȂ
				pTarget = szPath;
			}
		}
		else {
			// ϊs
			return DISP_E_TYPEMISMATCH;
		}
	}

	SHEmptyRecycleBin(NULL, pTarget, (m_bConfirm ? 0 : SHERB_NOCONFIRMATION) | (m_bSilent ? (SHERB_NOPROGRESSUI | SHERB_NOSOUND) : 0));
	return S_OK;
}

STDMETHODIMP CShell::RecentDocs(VARIANT text)
{
	LPCTSTR pTarget = NULL;

	if (text.vt == VT_NULL || text.vt == VT_ERROR || text.vt == VT_EMPTY) {
		// NA
		pTarget = NULL;
	}
	else {
		ATL::CString szPath;
		CComVariant varText;
		if (varText.ChangeType(VT_BSTR, &text) == S_OK) {
			// ̃t@Cǉ
			szPath = varText.bstrVal;
			if (!szPath.IsEmpty()) {
				// 󕶎łȂ
				pTarget = szPath;
			}
		}
		else {
			// ϊs
			return DISP_E_TYPEMISMATCH;
		}
	}
	SHAddToRecentDocs(SHARD_PATH, pTarget);
	return S_OK;
}

STDMETHODIMP CShell::SetMainWindow(VARIANT varUnk)
{
	// ̃C^[tFCX̉
	if (m_pMainWindow) {
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	// C^[tFCX̎擾
	CComVariant tmp;
	if (tmp.ChangeType(VT_UNKNOWN, &varUnk) == S_OK) {
		if (tmp.punkVal->QueryInterface(IID_IOverlappedWindow, (void**)&m_pMainWindow) == S_OK) {
			return S_OK;
		}
	}
	return DISP_E_UNKNOWNINTERFACE;
}

STDMETHODIMP CShell::IsExist(VARIANT name, VARIANT *pVal)
{
	CComVariant varRet;

	CComVariant varName;
	if (varName.ChangeType(VT_BSTR, &name) != S_OK) {
		return DISP_E_TYPEMISMATCH;
	}

	ATL::CString szPath(varName.bstrVal);

	DWORD attr = GetFileAttributes(szPath);
	if (attr != (DWORD)-1) {
		if (attr & FILE_ATTRIBUTE_DIRECTORY) {
			varRet = 2;
		}
		else {
			varRet = 1;
		}
	}
	varRet.Detach(pVal);
	return S_OK;
}
