﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// プラグインコードの生成
    /// </summary>
    public class PluginFrame : CodeGeneratorEnvironment, ICodeGenerator
    {
        /// <summary>
        /// インタフェースジェネレータ
        /// </summary>
        private IEnumerable<ICodeGenerator> generators = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="generators"></param>
        public PluginFrame( IEnumerable<ICodeGenerator> generators )
        {
            this.generators = generators;
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            string code = "#!/usr/bin/env python\n" + 
                          "# -*- coding: utf-8 -*-\n" + 
                          "import re\r\n" +
                          "\r\n" +
                          "from genshi.builder import tag\r\n" +
                          "\r\n" +
                          "from trac.core import *\r\n";

            foreach ( ICodeGenerator generator in generators ) {
                code += generator.GetImportCode();
            }

            code += "\r\n";

            return code;
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            string code = "class {0}(Component):\r\n" +
                          "    implements( ";

            foreach ( ICodeGenerator generator in generators ) {
                code += generator.GetDefinationCode() + ", ";
            }

            // 最後の", "を取り除く
            code = code.Substring( 0, code.Length - 2 );
            code += " )\r\n" +
                    "\r\n";
            return code;
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            string code = null;

            foreach ( ICodeGenerator generator in generators ) {
                code += generator.GetImplementCode() + "\r\n";
            }

            return code;
        }
    }
}
