﻿using System;
using System.Xml;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker
{
    public class XmlHelper
    {
        /// <summary>
        /// 子要素の作成
        /// </summary>
        /// <param name="xml"></param>
        /// <param name="parent"></param>
        /// <param name="tag"></param>
        /// <returns></returns>
        public static XmlNode AppendChild( XmlDocument xml, XmlNode parent, string tag )
        {
            return parent.AppendChild( xml.CreateElement( tag ) );
        }

        /// <summary>
        /// 子要素の作成
        /// </summary>
        /// <param name="xml"></param>
        /// <param name="parent"></param>
        /// <param name="tag"></param>
        /// <param name="text"></param>
        /// <returns></returns>
        public static XmlNode AppendChild( XmlDocument xml, XmlNode parent, string tag, string text )
        {
            XmlNode child = xml.CreateElement( tag );
            child.AppendChild( xml.CreateTextNode( text ) );
            parent.AppendChild( child );

            return child;
        }

    }
}
