from trac.core import *
from trac.config import Option, Configuration
from trac.web.chrome import add_script,add_stylesheet,ITemplateProvider
from trac.web.main import IRequestHandler, IRequestFilter
from trac.web.api import ITemplateStreamFilter
from trac.util.html import Markup

from genshi.filters.transform import Transformer
from genshi.template import MarkupTemplate
import json

class CompleteUserWeb(Component):
    implements(IRequestHandler, IRequestFilter, ITemplateProvider, ITemplateStreamFilter)

    def filter_stream(self, req, method, filename, stream, data):
        single_fields = Option('complete-user','single_fields',['owner','reporter'], u"""Pꃆ[U⊮tB[hݒ肵܂B""");
        composite_fields = Option('complete-user','composite_fields','cc', u"""[U⊮tB[hݒ肵܂B""");
        name_check = BoolOption('complete-user','name_check', 'True', u"""[UۂNameݒ肳Ă郆[Û݂邩ǂݒ肵܂B""");
        popup_delay = Option('complete-user','popup_delay','1.5',
                        u"""⊮EBhẼ|bvAbv\܂ł̒xԂݒ肵܂B
                        
                        Pʂ͕bŏ_p邱Ƃł܂
                        """)

#        single_fields = Configuration.getlist(self.config,"complete-user","single_fields",['owner','reporter']);
#        composite_fields = Configuration.getlist(self.config,"complete-user","composite_fields","cc");
#        popup_delay = Configuration.get(self.config,"complete-user","popup_delay","1.5")

        script = "<script type='text/javascript'>\n"
        script = script+"(function($){\n"
        script = script+"$(function(){\n"
        script = script+"  ultimania.trac.POPUP_DELAY = " + popup_delay + ";\n"

        script = script+"  ultimania.trac.setAutoComplete('action_reassign_reassign_owner','" + req.base_path + "/completeuser',false);\n"
        script = script+"  ultimania.trac.setAutoComplete('gp_subject','" + req.base_path + "/completeuser',false);\n"
        script = script+"  ultimania.trac.setAutoComplete('sg_subject','" + req.base_path + "/completeuser',false);\n"
        script = script+"  ultimania.trac.setAutoComplete('bmod_value_owner','" + req.base_path + "/completeuser',false);\n"
        script = script+"  ultimania.trac.setAutoComplete('bmod_value_cc','" + req.base_path + "/completeuser',true);\n"
        for field in single_fields:
           script = script+"  ultimania.trac.setAutoComplete('field-" + field + "','" + req.base_path + "/completeuser',false);\n"
        for field in composite_fields:
           script = script+"  ultimania.trac.setAutoComplete('field-" + field + "','" + req.base_path + "/completeuser',true);\n"
        script = script+"})\n"
        script = script+"})(jQuery);\n"
        script = script+"</script>"
        return stream | Transformer('//div[@id="footer"]').before(MarkupTemplate(script).generate())

    # IRequestFilter methods
    def pre_process_request(self, req, handler):
        return handler
        
    def post_process_request(self, req, template, content_type):
        return (template, content_type)

    def post_process_request(self, req, template, data, content_type):
        add_stylesheet(req, 'completeuser/js/yui/autocomplete/assets/skins/sam/autocomplete.css')
        add_stylesheet(req, 'completeuser/css/trac-completeuser.css')
        add_script(req, 'completeuser/js/yui/utilities/utilities.js')
        add_script(req, 'completeuser/js/yui/autocomplete/autocomplete-min.js')
        add_script(req, 'completeuser/js/trac-completeuser.js')
        return (template, data, content_type)

    # IRequestHandler methods
    def match_request(self, req):
        if req.path_info in ('/login/completeuser', '/completeuser'):
            self.log.debug("%s matches %s" % (req.path_info, True))
            return True
        return False

    def process_request(self, req):
        query = req.args.get('query')
        db = self.env.get_db_cnx()
        cursor = db.cursor();
        q = ""
        if query != None:
            q = ("AND s.sid LIKE '%%%s%%'") % (query)

        if name_check:
            sql = ("SELECT s.sid, sa.value FROM session s JOIN session_attribute sa ON s.sid = sa.sid WHERE s.authenticated = 1 AND sa.name = 'name' %s") % (q)
        else:
            sql = ("SELECT s.sid, sa.value FROM session s left outer join session_attribute sa ON s.sid = sa.sid AND sa.name = 'name' WHERE s.authenticated = 1  %s") % (q)

        cursor.execute(sql)
        userlist = []
        for sid, value in cursor:
            userlist.append({"Id":sid, "Name": value});
        response = json.write({"UserList":userlist});
        self.log.debug("%s matches %s" % (req.path_info, True))

        req.send_response(200)
        req.send_header('Content-Type', 'application/json; charset=utf-8')
        req.send_header('Content-Length', len(response.encode("utf-8")))

        req.end_headers()
        req.write(response)

    # ITemplateProvider methods
    def get_templates_dirs(self):
        return []

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('completeuser', resource_filename(__name__, 'htdocs'))]
