﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// INavigationContributor インタフェースの生成
    /// </summary>
    public class NavigationContributor : CodeGeneratorEnvironment, ICodeGenerator
    {
        public NavigationContributor()
        {
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.web.chrome import INavigationContributor\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "INavigationContributor";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "INavigationContributor.py.template" );
        }
    }
}
