# -*- encoding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#   Authors: 
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

from datetime import date, datetime
from unittest import TestCase

from trac.util.datefmt import FixedOffset, get_timezone, localtz, utc

from agilo.test import TestEnvHelper
from agilo.utils.days_time import date_to_datetime, datetime_str_to_datetime, now


class DateConvenienceFunctionsTest(TestCase):
    def setUp(self):
        teh = TestEnvHelper()
        self.env = teh.get_env()
    
    def test_date_to_datetime_conversion_returns_datetimes_unmodified(self):
        some_datetime = now()
        self.assertEqual(some_datetime, date_to_datetime(some_datetime))
    
    def test_can_convert_date_to_datetime(self):
        expected_datetime = datetime(2009, 5, 23, 0, 0, tzinfo=localtz)
        some_datetime = date_to_datetime(date(2009, 5, 23))
        self.assertNotEqual(None, some_datetime.tzinfo)
        self.assertEqual(expected_datetime, some_datetime)
    
    def test_can_parse_datetime_str(self):
        self.assertEqual(datetime(2009, 9, 10, 14, 55, 11), 
                                  datetime_str_to_datetime('2009-09-10 14:55:11'))
    
    def test_can_parse_datetime_str_with_tz(self):
        self.assertEqual(datetime(2009, 9, 10, 14, 55, 11, tzinfo=utc), 
                         datetime_str_to_datetime('2009-09-10 14:55:11+00:00'))
        berlin = get_timezone('GMT +2:00')
        self.assertEqual(datetime(2009, 9, 10, 14, 55, 11, tzinfo=berlin), 
                         datetime_str_to_datetime('2009-09-10 14:55:11+02:00'))
        teheran = FixedOffset(3*60+30, 'GMT +3:30')
        self.assertEqual(datetime(2009, 9, 10, 14, 55, 11, tzinfo=teheran), 
                         datetime_str_to_datetime('2009-09-10 14:55:11+03:30'))

