﻿using System;
using System.Windows.Forms;
using Microsoft.VisualStudio.Tools.Applications.Runtime;
using Word = Microsoft.Office.Interop.Word;
using Office = Microsoft.Office.Core;
using ImageConverter;

namespace WordTracAddIn
{
    public partial class ThisAddIn
    {
        private const string commandBarName = "WrodTracAddIn";

        private Office.CommandBarButton btnDownload = null;
        private Office.CommandBar menubar = null;

        //TracProxy.TicketManager trac = null;

        private void ThisAddIn_Startup(object sender, System.EventArgs e)
        {
            try
            {
                // メニューバーを追加
                menubar = Application.CommandBars.Add(commandBarName, missing, missing, false);
                menubar.Visible = true;

                // コマンドバーを上部にドッキングさせる
                Application.CommandBars[commandBarName].Position = Microsoft.Office.Core.MsoBarPosition.msoBarTop;

                // ロードボタン
                btnDownload = (Office.CommandBarButton)menubar.Controls.Add(1, missing, missing, missing, missing);
                btnDownload.Style = Office.MsoButtonStyle.msoButtonIcon;
                btnDownload.FaceId = 3;
                btnDownload.Tag = "1";
                btnDownload.Picture = ImageConverter.ImageConverter.getImage(Properties.Resources.download);
                btnDownload.TooltipText = "Wiki を Trac から取得";
                btnDownload.Click += new Office._CommandBarButtonEvents_ClickEventHandler(CommandBarButton_DownloadClick);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void ThisAddIn_Shutdown(object sender, System.EventArgs e)
        {
        }

        #region VSTO で生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler(ThisAddIn_Startup);
            this.Shutdown += new System.EventHandler(ThisAddIn_Shutdown);
        }

        #endregion

        void CommandBarButton_DownloadClick(Office.CommandBarButton Ctrl, ref bool CancelDefault)
        {
            try
            {
                Application.Documents.Add( ref missing, ref missing, ref missing, ref missing);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}
