# -*- encoding: utf-8 -*-
#   Copyright 2008 Agile42 GmbH, Berlin (Germany)
#   Copyright 2007 Andrea Tomasini <andrea.tomasini_at_agile42.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Andrea Tomasini <andrea.tomasini_at_agile42.com>

from datetime import datetime

from agilo.test.functional import AgiloTestCase

from agilo.utils import BacklogType, Type, Key
from agilo.test import TestEnvHelper
from agilo.utils.sorting import SortOrder


class TestBacklogPerformance(AgiloTestCase):
    """Tests the performance of a Backlog object, purely from a 
    computational point of view"""
    def _test_global_backlog(self):
        """Test performance in loading and sorting a global Backlog with 100 items"""
        for num_items in [10, 100, 200]:
            gb = self.teh.create_backlog(name="Performance %d" % num_items,
                                         num_of_items=num_items)
            self.assertEqual(num_items, gb.count())
            start = datetime.now()
            gb.reload()
            stop = datetime.now()
            load_time = stop - start
            print "Load backlog with %d items: %s" % (num_items, load_time)
            # test sorting with one key only
            start = datetime.now()
            gb.sort()
            stop = datetime.now()
            sort_time = stop - start
            print "Sort backlog with %d items: %s" % (num_items, sort_time)
            self._tester.delete_all_tickets()
    
    def _test_sprint_backlog(self):
        """Test performance in loading and sorting a global Backlog with 100 items"""
        for num_items in [10, 100, 200]:
            s = self.teh.create_sprint("TestSprint%s" % num_items)
            start = datetime.now()
            sb = self.teh.create_backlog(name="Sprint Backlog %d" % num_items,
                                         ticket_types=[Type.REQUIREMENT, Type.USER_STORY, Type.TASK],
                                         sorting_keys=[(Key.BUSINESS_VALUE, SortOrder.DESCENDING),
                                                       (Key.STORY_PRIORITY, SortOrder.DESCENDING),
                                                       (Key.REMAINING_TIME, SortOrder.DESCENDING)],
                                         num_of_items=num_items, 
                                         b_type=BacklogType.SPRINT,
                                         scope=s.name)
            #f num_items != sb.count():
                # print the backlog for debugging
                #from agilo.scrum.backlog.tests.backlog_test import print_backlog
                #print_backlog(sb)
            create_time = datetime.now() - start
            print "Created %s ticket in %s sec. (avg: %s)" % (num_items, create_time, create_time/num_items)
            start = datetime.now()
            sb.reload()
            stop = datetime.now()
            load_time = stop - start
            print "Load sprint backlog with %d items: %s" % (num_items, load_time)
            # test sorting with one key only
            start = datetime.now()
            sb.sort()
            stop = datetime.now()
            sort_time = stop - start
            print "Sort sprint backlog with %d items: %s" % (num_items, sort_time)
            self._tester.delete_all_tickets()
    
    def runTest(self):
        """Runs all the tests in the test case"""
        # We need to build a real environment at least we will test 
        # the IO
        self.teh = TestEnvHelper(env=self._testenv.get_trac_environment())
        self._test_global_backlog()
        self._test_sprint_backlog()


if __name__ == '__main__':
    from agilo.test.testfinder import run_all_tests
    run_all_tests(__file__)


