﻿using System;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.VisualStudio.Tools.Applications.Runtime;
using Excel = Microsoft.Office.Interop.Excel;
using Office = Microsoft.Office.Core;
using System.Runtime.InteropServices;

namespace TicketImportTemplate
{
    public partial class Sheet1
    {
        private void Sheet1_Startup( object sender, System.EventArgs e )
        {
            try {
                // セルのダブルクリックイベント
                BeforeDoubleClick += new Excel.DocEvents_BeforeDoubleClickEventHandler( Sheet1_BeforeDoubleClick );

                // セルをすべて文字列扱いにする
                Cells.NumberFormatLocal = "@";
            }
            catch ( Exception ex ) {
                MessageBox.Show( ex.Message );
            }
        }

        private void Sheet1_Shutdown(object sender, System.EventArgs e)
        {
        }

        // セルのダブルクリックイベント
        private void Sheet1_BeforeDoubleClick( Excel.Range Target, ref bool Cancel )
        {
            int raw = Target.Row;
            int col = Target.Column;

            Excel.Range title = (Excel.Range)Cells[1, Target.Column];
            // "開始日"と"終了日"の場合はカレンダーを表示する
            if ( (title.Text.ToString() == "due_assign") || (title.Text.ToString() == "due_close") ) {
                Calendar cal = new Calendar();
                cal.StartPosition = FormStartPosition.Manual;
                cal.Location = Cursor.Position;
                DialogResult ret = cal.ShowDialog( null );
                if ( ret == DialogResult.OK ) {
                    Target.set_Value( null, cal.SelectDate.ToShortDateString() );
                }

                // セルの入力はさせたくないので、キャンセル扱いにする
                Cancel = true;
            }
        }

        #region VSTO で生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler(Sheet1_Startup);
            this.Shutdown += new System.EventHandler(Sheet1_Shutdown);
        }

        #endregion

    }
}
