// ---------------------------------------------------------------
module("backlog reordering");

test("smoke", function(){
	var backlog = buildBacklogFromURL("/backlog/Sprint%20Backlog/Demo Sprint", "");
	ok(backlog !== null);
});


test("can extract name from url for backlog without scope", function(){
	var backlog = buildBacklogFromURL("/foobar/backlog/ProductBacklog", "");
	equals(backlog.name, "ProductBacklog");
	equals(backlog.scope, null);
});

/*
test("can extract url escaped name from url", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog");
	equals(backlog.name, "Maintenance Backlog");
});
 */

test("can extract backlog name from url in multi environment", function(){
	var backlog = buildBacklogFromURL("/foo/backlog/MaintenanceBacklog/DemoSprint", "");
	equals(backlog.name, "MaintenanceBacklog");
});

test("can extract scope from url", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog/DemoSprint", "");
	equals(backlog.scope, "DemoSprint");
});

test("can extract quoted scope from url", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog/Demo%20Sprint", "");
	equals(backlog.scope, "Demo Sprint");
});

test("can extract quoted scope from query string", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog", "?bscope=Demo+Sprint&view=View");
	equals(backlog.scope, "Demo Sprint");
});

test("can extract quoted scope from query string even if path ends with slash", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog/", "bscope=DemoSprint&view=View");
	equals(backlog.scope, "DemoSprint");
});

test("can extract quoted scope from query string even if scope is the only parameter", function(){
	var backlog = buildBacklogFromURL("/backlog/Maintenance%20Backlog", "bscope=DemoSprint");
	equals(backlog.scope, "DemoSprint");
});

test("can extract scope and name from path even if there are query parameters", function(){
	var backlog = buildBacklogFromURL("/backlog/MaintenanceBacklog/Demo%20Sprint", "foo=var");
	equals(backlog.name, "MaintenanceBacklog");
	equals(backlog.scope, "Demo Sprint");
});

test("can correctly encode special characters in the sprint name", function() {
	var backlog = buildBacklogFromURL("http://localhost:8012/backlog/Sprint%20Backlog", "bscope=Sprint+%232");
	equals(backlog.name, 'Sprint Backlog');
	equals(backlog.scope, 'Sprint #2');
	var url = notifyServerAboutPositionChangeURL(backlog);
	equals('/json/backlogs/Sprint%20Backlog/Sprint%20%232', url);
	
});