$(function (){
    var base_url = $("input#base_url").val();
    var trac_wiki = new Array("CamelCase",  "InterMapTxt",  "InterTrac",  "InterWiki",  "RecentChanges",  "SandBox",  "TitleIndex",  "TracAccessibility",  "TracAdmin",  "TracBackup",  "TracBrowser",  "TracCgi",  "TracChangeset",  "TracEnvironment",  "TracFastCgi",  "TracGuide",  "TracImport",  "TracIni",  "TracInstall",  "TracInterfaceCustomization",  "TracJa",  "TracLinks",  "TracLogging",  "TracModPython",  "TracNotification",  "TracPermissions",  "TracPlugins",  "TracQuery",  "TracReports",  "TracRevisionLog",  "TracRoadmap",  "TracRss",  "TracSearch",  "TracStandalone",  "TracSupport",  "TracSyntaxColoring",  "TracTermsJa",  "TracTickets",  "TracTicketsCustomFields",  "TracTimeline",  "TracUnicode",  "TracUpgrade",  "TracWiki",  "WikiDeletePage",  "WikiFormatting",  "WikiHtml",  "WikiMacros",  "WikiNewPage",  "WikiPageNames",  "WikiProcessors",  "WikiRestructuredText",  "WikiRestructuredTextLinks" ,"checkwiki.py");
    var split_count = 0;
    var pos = base_url.indexOf("/");
    while ( pos != -1 ) {
       split_count++;
       pos = base_url.indexOf("/",pos+1);
    }
    split_count = split_count + 2;
    
    var check_attribute = function(key) {
        return $( "#" + key ).attr("checked")? "&" + key + "=on": "";
    }


    $("span#loading").hide();
    $("span#loading").ajaxStart(function(){ $(this).show(); });
    $("span#loading").ajaxStop(function(){ $(this).hide(); });

    $("span#search_title").hide();
    $("span#search_title2").hide();

    var projects = new Object();
    all_p_elem = $("select#projects");
    project_elem = $("option", all_p_elem);
    project_elem.each(function(){
       href_attr = $(this).val();
       projects[ href_attr ] = { pj_name:href_attr, pj_title:$(this).html(), pj_url:base_url + href_attr };
    });

    var search_into_project = function(project) {
        return function(data, status) {
            var temp_elem = $(document.createElement("div"));
            temp_elem.html(data);

            if (check_attribute("remove_trac")) {
                var remove_count = 0;
                $("dl#results dt", temp_elem).each(function() {
                    trac_flg = false;
                    temp_text = $(this).text();
                    $.each(trac_wiki, function( i ) {
                        if (temp_text.match(new RegExp("^" + trac_wiki[i] + ":")) != undefined) {
                            trac_flg = true;
                            remove_count++;
                        }
                    });
                    if (trac_flg) {
                        $(this).next().remove();
                        $(this).next().remove();
                        $(this).remove();
                    }

                });
            }
            var res_elem = $("dl#results",temp_elem);
            $("a", res_elem).attr("target", "_blank");

            var res_area_elem = $(document.createElement("div"));
            res_area_elem.addClass("indiv_result"); 
            $("div#search_result").append( res_area_elem );
            var h3_elem = $(document.createElement("h3"));
            var h3m_elem = $(document.createElement("h3"));
            var a_elem = $(document.createElement("a"));
            a_elem.html(project.pj_title);
            a_elem.attr("href", project.pj_url);
            a_elem.attr("target", "_blank");
            h3_elem.append(a_elem);
            var a2_elem = $(document.createElement("a"));
            h3_elem.append("&nbsp;&nbsp;&nbsp;");
            a2_elem.html("[&nbsp;more ...&nbsp;]");
            a2_elem.attr("href", this.url);
            a2_elem.attr("target", "_blank");
            h3_elem.append(a2_elem);
            if ($("div#paging", temp_elem).text()!="") {
                h3_elem.append("&nbsp;&nbsp;&nbsp;&nbsp;There are more than 10 results.");
            }
            
            res_area_elem.append( h3_elem );
            if (res_elem.size() == 0) { 
                res_area_elem.append("We did not find results..." );
                res_area_elem.append("<hr>");
            } else {
                if (remove_count >= 10) {
	            res_area_elem.append("Please confirm detail retrieval. (Search result is all in default Wiki pages.)");
       	            res_area_elem.append("<hr>");
				} else {
	                res_area_elem.append( res_elem );
	            }
            }       
        }       
    }

    $("#whole_search").click(function(){
        $("div#search_result").empty();
        var elem_selected = false;
        var project_elems = $("option.project");
        $.each( project_elems, function ( i ) { 
                if (this.selected) {
                    elem_selected = true; 
                    var req_url = base_url + projects[ this.value ].pj_name + "/search?q=" + encodeURIComponent($( "#q" ).val()) + check_attribute("wiki") + check_attribute( "discussion" ) + check_attribute( "changeset" ) + check_attribute( "ticket" );
                    $.get( req_url, search_into_project( projects[ this.value ] ) );
                }
            }
        );
        if (!elem_selected) {
            $.each( projects, function( i ) {
                    var req_url = base_url + this.pj_name + "/search?q=" + encodeURIComponent($( "#q" ).val()) + check_attribute("wiki") + check_attribute( "discussion" ) + check_attribute( "changeset" ) + check_attribute( "ticket" );
                    $.get( req_url, search_into_project(this) );
                }
            );
        }
        $("span#search_title").show();
        $("span#search_title2").show();
    });
});
