﻿using System;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    // 使うときはこうやって使ってください
    using Resolution = TracNameAndValueField<IResolution>;

    /// <summary>
    /// 解決方法
    /// </summary>
    public interface IResolution : ITracNameAndValueField
    {
        /// <summary>
        /// すべての解決方法を取得する
        /// </summary>
        /// <returns>解決方法一覧</returns>
        [XmlRpcMethod( "ticket.resolution.getAll" )]
        new string[] GetAll();

        /// <summary>
        /// 指定された解決方法の順序を取得する
        /// </summary>
        /// <param name="name">取得する解決方法の名称</param>
        /// <returns>解決方法の順序</returns>
        [XmlRpcMethod( "ticket.resolution.get" )]
        new string Get( string name );

        /// <summary>
        /// 指定された解決方法を削除する
        /// </summary>
        /// <param name="name">削除する解決方法の名称</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.resolution.delete" )]
        new int Delete( string name );

        /// <summary>
        /// 新しい解決方法を作成する
        /// </summary>
        /// <param name="name">作成する解決方法の名称</param>
        /// <param name="value">作成する解決方法の順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.resolution.create" )]
        new int Create( string name, string value );

        /// <summary>
        /// 指定された解決方法を更新する
        /// </summary>
        /// <param name="name">更新する解決方法の名称</param>
        /// <param name="value">更新する順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.resolution.update" )]
        new int Update( string name, string value );
    }
}
