﻿using System;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    // 使うときはこうやって使ってください
    using Severity = TracNameAndValueField<ISeverity>;

    /// <summary>
    /// 重要度
    /// </summary>
    public interface ISeverity : ITracNameAndValueField
    {
        /// <summary>
        /// 重要度の一覧を取得する
        /// </summary>
        /// <returns></returns>
        [XmlRpcMethod( "ticket.severity.getAll" )]
        new string[] GetAll();

        /// <summary>
        /// 指定された重要度の詳細を取得する
        /// </summary>
        /// <param name="name">取得する重要度の名称</param>
        /// <returns>重要度の順序</returns>
        [XmlRpcMethod( "ticket.severity.get" )]
        new string Get( string name );

        /// <summary>
        /// 指定された重要度を削除する
        /// </summary>
        /// <param name="name">削除する重要度の名称</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.severity.delete" )]
        new int Delete( string name );

        /// <summary>
        /// 重要度を作成する
        /// </summary>
        /// <param name="name">作成する重要度の名称</param>
        /// <param name="value">順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.severity.create" )]
        new int Create( string name, string value );

        /// <summary>
        /// 指定された重要度を更新する
        /// </summary>
        /// <param name="name">更新する重要度の名称</param>
        /// <param name="value">更新する順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.severity.update" )]
        new int Update( string name, string value );
    }
}
