﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// 環境の拡張
    /// </summary>
    public class EnvironmentSetupParticipant : CodeGeneratorEnvironment, ICodeGenerator
    {
        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.env import IEnvironmentSetupParticipant\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "IEnvironmentSetupParticipant";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "IEnvironmentSetupParticipant.py.template" );
        }
    }
}
