﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TracPluginTemplateMaker
{
    public partial class Form1 : Form
    {
        private PluginInfo developper = new PluginInfo();

        public Form1()
        {
            InitializeComponent();

            // データソースを設定
            bindingSourcePluginInfo.DataSource = developper;
        }

        private void buttonMake_Click( object sender, EventArgs e )
        {
            try {
                PluginTemplateMaker maker = new PluginTemplateMaker( textBoxPluginName.Text, developper.OutputDirectory );
                maker.Make( developper, GetGenerateInterface() );

                MessageBox.Show( "テンプレートを生成しました", Text );
            }
            catch ( Exception ex ) {
                MessageBox.Show( ex.Message, Text );
            }
        }

        /// <summary>
        /// 生成するインタフェースを取得
        /// </summary>
        /// <returns></returns>
        private IEnumerable<PluginTemplateMaker.GenerateInterface> GetGenerateInterface()
        {
            if ( checkBoxAdminPanelProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IAdminPanelProvider;
            }

            if ( checkBoxAuthenticator.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IAuthenticator;
            }

            if ( checkBoxMenu.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.INavigationContributor;
                yield return PluginTemplateMaker.GenerateInterface.IRequestHandler;
            }

            if ( checkBoxTemplateProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITemplateProvider;
            }

            if ( checkBoxTemplateStreamFilter.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITemplateStreamFilter;
            }

            if ( checkBoxTicketManipulator.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITicketManipulator;
            }

            if ( checkBoxTicketChangeListener.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITicketChangeListener;
            }

            if ( checkBoxTicketActionController.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITicketActionController;
            }

            if ( checkBoxTicketReportRenderer.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITicketReportRenderer;
            }

            if ( checkBoxEnvironmentSetupParticipant.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IEnvironmentSetupParticipant;
            }

            if ( checkBoxPermissionRequestor.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IPermissionRequestor;
            }

            if ( checkBoxPermissionGroupProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IPermissionGroupProvider;
            }

            if ( checkBoxPermissionStore.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IPermissionStore;
            }

            if ( checkBoxPermissionPolicy.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IPermissionPolicy;
            }
            
            if ( checkBoxTimelineEventProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.ITimelineEventProvider;
            }

            if ( checkBoxRequestFilter.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IRequestFilter;
            }

            if ( checkBoxHTMLPreviewRenderer.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IHTMLPreviewRenderer;
            }

            if ( checkBoxHTMLPreviewAnnotator.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IHTMLPreviewAnnotator;
            }

            if ( checkBoxContentConverter.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IContentConverter;
            }

            if ( checkBoxWikiChangeListener.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IWikiChangeListener;
            }

            if ( checkBoxWikiPageManipulator.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IWikiPageManipulator;
            }

            if ( checkBoxWikiMacroProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IWikiMacroProvider;
            }

            if ( checkBoxWikiSyntaxProvider.Checked ) {
                yield return PluginTemplateMaker.GenerateInterface.IWikiSyntaxProvider;
            }
        }

        /// <summary>
        /// フォルダの参照ボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonBrowseFolder_Click( object sender, EventArgs e )
        {
            DialogResult ret = folderBrowserDialog.ShowDialog();
            if ( ret == DialogResult.OK ) {
                developper.OutputDirectory = folderBrowserDialog.SelectedPath;
            }
        }
    }
}
