﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// IRequestHandler インタフェースの生成
    /// </summary>
    public class RequestHandler : CodeGeneratorEnvironment, ICodeGenerator
    {
        public RequestHandler()
        {
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.web.api import IRequestHandler\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "IRequestHandler";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "IRequestHandler.py.template" );
        }
    }
}
