using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Globalization;

namespace XmlRpcProxy
{
    [XmlRoot("methodCall")]
    public class MethodCall
    {
        private string _methodName;

        private List<Param> _paramArray;

        [XmlElement("methodName")]
        public string MethodName
        {
            get
            {
                return _methodName;
            }
            set
            {
                _methodName = value;
            }
        }

        [XmlArray("params")]
        [XmlArrayItem("param")]
        public List<Param> ParamArray
        {
            get
            {
                return _paramArray;
            }
            set
            {
                _paramArray = value;
            }
        }

        public MethodCall()
            : this(null, new object[] { })
        {
        }

        public MethodCall(string methodName, object[] paramArray)
        {
            _methodName = methodName;
            _paramArray = new List<Param>();
            foreach (object param in paramArray)
            {
                _paramArray.Add(new Param(param));
            }
        }
    }
}

    
