module('url helpers', {
	setup: function() {
		BASE_URL = '';
	}
});

test("url method concatenates arguments to paths", function() {
	equals(encodedURLFromComponents('foo', 'bar', 'baz'), '/foo/bar/baz');
});

test("url method can encode special characters correctly", function() {
	equals(encodedURLFromComponents('fnord'), '/fnord');
	equals(encodedURLFromComponents('these.are_non!probl', 'ematic-characters'), '/these.are_non!probl/ematic-characters');
	
	equals(encodedURLFromComponents('/'), '/%2F');
	equals(encodedURLFromComponents('#'), '/%23');
	equals(encodedURLFromComponents(':'), '/%3A');
	equals(encodedURLFromComponents('%'), '/%25');
	equals(encodedURLFromComponents('$'), '/%24');
	equals(encodedURLFromComponents('?'), '/%3F');
	equals(encodedURLFromComponents(' '), '/%20');
	equals(encodedURLFromComponents(','), '/%2C');
	equals(encodedURLFromComponents('+'), '/%2B');
});

test("url method respects base path", function() {
	BASE_URL = 'fnord';
	equals(encodedURLFromComponents(), 'fnord');
	equals(encodedURLFromComponents('foo', 'bar'), 'fnord/foo/bar');
});

test("url method can cope with extra slashes in the base url", function() {
	BASE_URL = 'fnord/';
	equals(encodedURLFromComponents(), 'fnord');
	equals(encodedURLFromComponents('foo'), 'fnord/foo');
	
});

test("can encode dictionary to query parameters", function() {
	equals(encodedQueryParametersFromDict({}), '');
	equals(encodedQueryParametersFromDict({foo:'bar'}), '?foo=bar');
	equals(encodedQueryParametersFromDict({foo:'bar', baz:'quux'}), '?foo=bar&baz=quux');
	equals(encodedQueryParametersFromDict({foo:'bar baz'}), '?foo=bar%20baz');
});

test("encodedURLFromComponents supports dictionary to query string as last paremeter", function() {
	equals(encodedURLFromComponents({}), '');
	equals(encodedURLFromComponents('fnord', {}), '/fnord');
	equals(encodedURLFromComponents('fnord', {foo:'bar'}), '/fnord?foo=bar');
});

test("url encoding doesn't confuse number with dictionary", function() {
	equals(encodedURLFromComponents('ticket', 23), '/ticket/23');
});