# -*- encoding: utf-8 -*-
#   Copyright 2008 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

import twill
from twill.errors import TwillAssertionError
from trac.tests.functional import tc
import trac.tests.functional.better_twill
from trac.tests.functional.better_twill import twill_write_html

__all__ = []

def replacement_that_writes_html_on_error(original_twill_function):
    def closure(*args, **kwargs):
        try:
            original_twill_function(*args, **kwargs)
        except TwillAssertionError, e:
            filename = twill_write_html()
            if e.args[-1] == filename:
                raise
            args = e.args + (filename,)
            raise twill.errors.TwillAssertionError(*args)
    return closure

tc.code = replacement_that_writes_html_on_error(tc.code)
tc.title = replacement_that_writes_html_on_error(tc.title)
tc.follow = replacement_that_writes_html_on_error(tc.follow)

# tidy (even in with the latest version in Fedora 9 which is 
# '0.99.0-17.20070615.fc9') manipulates the HTML source code so that empty 
# options ('<option></option>') will be removed completely. That affects our
# unit tests because you get always a sprint set etc.
# So we have to make sure that tidy is not used at all. We add this to 
# _orig_options so that the value is added again as soon as the browser is 
# reset without special action on our side.
#
# Actually the trac guys found the problem too (#5497) but they only added it to
# the options which are lost after a reset_browser.
twill.commands._orig_options['use_tidy'] = False
# ------------------------------------------------------------------------------

# tc.fv is just a shortcut to formvalue - but its initialized before better_twill
# monkey-patches it - so we have to do it ourselves (see #8331)
tc.fv = tc.formvalue

# ------------------------------------------------------------------------------
# Taken from trac (http://trac.edgewall.org/changeset/7606) so that we don't 
# have to patch our local trac installations.
class _BrowserProxy(object):
    def __getattribute__(self, name):
        return getattr(twill.get_browser(), name)
    
    def __setattr(self, name, value):
        setattr(twill.get_browser(), name, value)

trac.tests.functional.better_twill.b = _BrowserProxy()
# ------------------------------------------------------------------------------

