# -*- coding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
# 
# Authors:
#     - Felix Schwarz <felix.schwarz__at__agile42.com>

from unittest import TestCase

from agilo.core import Field, PersistentObject, PersistentObjectManager
from agilo.test import TestEnvHelper
from agilo.api.controller import ICommand
from agilo.api.validator import StringValidator


class MyCommandPO(PersistentObject):
    class Meta(object):
        name = Field(primary_key=True)

class MyCommand(ICommand):
    parameters = {'name': StringValidator}

class TestCommand(TestCase):
    
    def setUp(self):
        self.teh = TestEnvHelper()
        self.env = self.teh.get_env()
        self.cmd = MyCommand(self.env)
        self.pom = PersistentObjectManager(self.env)
        self.pom.create_table(MyCommandPO)
    
    def test_return_items_in_lists_as_dict(self):
        input = [MyCommandPO(self.env, name='foo')]
        self.assertEqual([{'name': 'foo', 'exists': False}], 
                         self.cmd.return_as_value_object(input))

