from setuptools import find_packages, setup

setup(
    name='TracMailArchive',
    author='wadahiro',
    author_email='wadahiro@gmail.com',
    version='0.4.2',
    license = "New BSD",
    packages=find_packages(exclude=['*.tests*']),
    package_data={'mailarchive': ['templates/*.html',
                                  'templates/*.txt',
                                  'htdocs/css/*.css',
                                  'htdocs/js/*.js',
                                  'htdocs/png/*']},
    entry_points = {
        'trac.plugins': [
            'mailarchive.web_ui = mailarchive.web_ui',
            'mailarchive.env = mailarchive.env',
            'mailarchive.wikisyntax = mailarchive.wikisyntax',
        ],
        'console_scripts': [
            'TracMailArchive-admin = mailarchive:run'
        ]
    }
)
