﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    /// <summary>
    /// ITicketManipulator インタフェースの生成
    /// </summary>
    public class TicketManipulator : CodeGeneratorEnvironment, ICodeGenerator
    {
        public TicketManipulator()
        {
        }

        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.ticket.api import ITicketManipulator\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "ITicketManipulator";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "ITicketManipulator.py.template" );
        }
    }
}
