$(function(){

$(".commitcount").each(function(){
var idstr = this.id.split("_")[1];
var opt_upper = $("#commitcountopt_"+idstr+" .upper").text().toLowerCase();
var opt_linestep = $("#commitcountopt_"+idstr+" .linestep").text().toLowerCase();
var opt_linepoint = $("#commitcountopt_"+idstr+" .linepoint").text().toLowerCase();
var opt_ymax = $("#commitcountopt_"+idstr+" .ymax").text().toLowerCase();
var opt_gwidth = $("#commitcountopt_"+idstr+" .gwidth").text().toLowerCase();
var ymax = parseInt(opt_ymax)
var gwidth = parseInt(opt_gwidth)
var linestep = new Boolean();
var linepoint = new Boolean();
linestep = opt_linestep == "true" ? true : false;
linepoint = opt_linepoint == "true" ? true : false;

var tzoffset = (new Date()).getTimezoneOffset()*60*1000;

var datas = [];
var labels = [];
var a, b, c, pre_c;
var i = 0;
$("#commitcounttable_"+idstr+" tbody tr td").each(function(){
  switch (i ++ % 3){
  case 0:
    a = $(this).text(); break;
  case 1:
    b = new Date($(this).text()).getTime()-tzoffset; break;
  default:
    c = $(this).text();
    if (typeof datas[a] == "undefined"){
      datas[a] = [];
      labels.push(a);
    }
    
    if (datas[a].length == 0 || c != pre_c){
      datas[a].push([b, c]);
      pre_c = c;
    }
  }
});

var msdatas = [];
var tmp_a,tmp_b;
i = 0;
$("#commitcountmstable_"+idstr+" tbody tr td").each(function(){
  switch (i ++ % 2){
  case 0:
    tmp_a = $(this).text();break;
  default:
    tmp_b = $(this).text();
    if (typeof msdatas == "undefined"){
      msdatas = [];
    }
    msdatas.push([tmp_b, tmp_a]);//data,milestone
    break;
  }
});
//alert(msdatas);
var vals = [];
var la;
i = labels.length;
while (i -- > 0){
  la = labels[i];
  vals[i] = { label: la, data: datas[la] };
}

if (msdatas.length) //milestone
{
  vals[labels.length] = { label: "", data: [null] , xaxis: 2 }; //no data/legend display
}

var posit = opt_upper == "true" ? "se" : "ne";

function showTooltip(x, y, contents){
  $('<div id="tooltip">'+contents+"</div>").css({
    position: "absolute",
    display: "none",
    top: (y + 5)+"px",
    left: (x + 5)+"px",
    border: "1px solid #fdd",
    padding: "2px",
    "background-color": "#fee",
    opacity: 0.80
  }).appendTo("body").fadeIn(200);
}


$.plot($("#placeholder_"+idstr), vals, {
  legend: { show: true, position: posit },
  lines: { show: true , steps: linestep },
  points: { show: linepoint },
  xaxis: { mode: "time", timeformat: "%y/%m/%d", minTickSize: [1,"day"] },
  x2axis: { min: 0 , max: gwidth , ticks: msdatas },
  yaxis: { min: 0, tickDecimals: 0,autoscaleMargin: 0.05, max: parseInt(ymax) },
  grid: { hoverable: true, clickable: false }
});

var previousPoint = null;
$("#placeholder_"+idstr).bind("plothover", function (event, pos, item){

  if (item){
    if (previousPoint != item.datapoint){
      previousPoint = item.datapoint;
      
      $("#tooltip").remove();
      var x = item.datapoint[0],
          y = item.datapoint[1];
      var d = new Date(x);
      showTooltip(item.pageX, item.pageY,
                  item.series.label+"<br/>"
                   +d.getFullYear()+"/"+(d.getMonth()+1)+"/"+d.getDate()+" : "
                   +y);
    }
  }
  else {
    $("#tooltip").remove();
    previousPoint = null;
  }
});

});
});

