//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// DispositionControl.h: DispositionControl NX̃C^[tFCX
// zuf[^
//	F
// $Log: DispositionControl.h,v $
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.7  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.6  2001/07/01 01:03:43  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.5  2001/05/17 12:34:10  fujiwara
// nGTv쐬
//
// Revision 1.4  2001/05/12 12:48:28  fujiwara
// zuGfB^쐬ɔύXEǉ
//
// Revision 1.3  2001/05/12 00:50:48  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISPOSITIONCONTROL_H__B18EC6D6_B30C_4A24_B747_D0EBBC6F71F2__INCLUDED_)
#define AFX_DISPOSITIONCONTROL_H__B18EC6D6_B30C_4A24_B747_D0EBBC6F71F2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
namespace sf {
	namespace application {
		namespace scene {
			class DispositionEditor;
		};

		namespace disposition {

	// zuR}hIuWFNg
	namespace command { 
		// ----------------------------------------------------
		// R}hf[^̈Ӗit@CɕۑĂ鎞j 
		// position float Yʒu
		// command  string R}h
		// parameter ... p[^(eR}hƂɒ͈قȂj
		// ----------------------------------------------------
		
		const int MAX = 5;// R}h̍ő吔
		enum TYPE {
			RESET = 0,
			SET_SCROLLSPEED = 1,
			SET_RESTARTPOSITION = 2,
			SET_ENEMY = 3,
			SET_ARMY = 4
		};

		// --- Rei[pC^[tF[X --- //

		class Interface : 
			public sf::system::input::keyboard::Listener
			,public sf::system::input::mouse::Listener 
		{
			
			// LIFECYCLE //

		public:
			Interface(){;};
			virtual ~Interface(){;};

			// OPERATORS //

			// C^[tF[X̍l炷΂͔sׁI
			// ZqvirtualɂłȂ̂ŁDDD
			Interface &operator=( Interface &rSrc )
			{
				return copy(rSrc);
			};

			
			// OPERATIONS //

			virtual void exec(const float position) = 0;
			// Xg[̃[h
			virtual void load(std::istream &is) = 0;
			// Xg[̃Z[u
			virtual void save(std::ostream &os) = 0;

			// zuGfB^`
			virtual void draw(sf::application::scene::DispositionEditor * const pEditor
								,const float position,const bool bMouse) = 0;
			
			// ACCESS //

			// R}ȟ^Ԃ
			virtual const TYPE id(void) const = 0;
			// GameV[ւ̃|C^
			virtual sf::application::scene::Game * const game(void) const = 0;
			virtual void game(sf::application::scene::Game * const pGame) = 0;
			// R}h̃VAԍ(݂͖gp)
			virtual void serialNo(const int value) = 0;
			virtual const int serialNo(void) const = 0;
			// zu}bv\pXvCgւ̃|C^
			virtual sf::system::console::sprite::Sprite * const sprite (void) const = 0;
			// zuGfB^p
			virtual const int max(void) const = 0;
			virtual void load(void) = 0;
			virtual Interface& copy(Interface &rSrc) = 0;

		};// Interface

		// --- ۃNX  ||||||||||||||||||||||||

		class Abstract : public Interface {

			// LIFECYCLE //
		
		public:
			Abstract()
			{	mSerialNo = 0;
				mpGame = NULL;
			};

			~Abstract(){;};
		
			// OPERATORS //

			
			// OPERATIONS //

			virtual void draw(sf::application::scene::DispositionEditor * const pEditor
				,const float position
				,const bool bMouse);

			// }EXEL[{[hXi
			// }EXXi[
			void leftButtonDown(const int screenX,const int screenY,const DWORD mkey){;};
			void leftButtonUp(const int screenX,const int screenY,const DWORD mkey){;};
			void leftButtonDoubleClick(const int screenX,const int screenY,const DWORD mkey){;};
			void rightButtonDown(const int screenX,const int screenY,const DWORD mkey){;};
			void rightButtonUp(const int screenX,const int screenY,const DWORD mkey){;};
			void rightButtonDoubleClick(const int screenX,const int screenY,const DWORD mkey){;};
			virtual void mouseMove(const int screenX,const int screenY,const DWORD mkey){;};
			void mouseWheel(const int screenX,const int screenY,const DWORD mkey){;};
			void mouseTalkerIsDeleted(void){;};
		
			void keyDown(const DWORD keyCode,const DWORD extKeyCode){};
			void keyUp(const DWORD keyCode,const DWORD extKeyCode){};
			void keyboardTalkerIsDeleted(void){;};

			// R}h̃Rs[Ƃ //
			Interface &copy(Interface &rSrc)
			{
//				position(rSrc.position());
				game(rSrc.game());
				return (*this);
			};

			// ACCESS //
			
			// VAԍ //
			void serialNo(const int value){ mSerialNo = value;};
			const int serialNo(void) const {return mSerialNo;};
			// Q[V[ւ̃|C^ 
			sf::application::scene::Game * const game(void) const { return mpGame;};
			void game(sf::application::scene::Game * const pGame){mpGame = pGame;};

			const int max(void) const { return 1;};

			sf::system::console::sprite::Sprite * const sprite(void) const {return NULL;};

			// INQUIRY //
		
			const bool isListeningMouse(void) const {return false;};
			const bool isListeningKeyboard(void) const {return false;};
		
		private:
			sf::application::scene::Game * mpGame;
			int mSerialNo;
		};// Abstract
		
		// ZbgR}h		|||||||||||||||||||||||||
		class Reset : public Abstract {

			// LIFECYCLE //

		public:
			Reset(){;};
			virtual ~Reset(){;};

			// OPERATORS //


			// OPERATIONS //

			void exec(const float position){;};
			
			void load(std::istream &is){;};
			void save(std::ostream &os){;};
			void load(void){;};
			// IuWFNg̐
			static Interface * const create(void) { return new Reset;};

			// ACCESS //

			const TYPE id(void) const {return RESET;};
		};// Reset
		
		// XN[Xs[h ̐ݒ |||||||||||||||||||||
		class SetScrollSpeed : public Abstract {

			// LIFECYCLE //

		public:
			SetScrollSpeed(){mSpeed = 0;};
			virtual ~SetScrollSpeed(){unloadResource();};

			// OPERATORS //


			// OPERATIONS //

			void exec(const float position){ game()->scrollSpeed(mSpeed);};

			const TYPE id(void) const {return SET_SCROLLSPEED;};

			void load(std::istream &is){ is >> mSpeed; };
			void save(std::ostream &os){ os << " " << mSpeed;};

			static void loadResource(void);
			static void unloadResource(void);

			void load(void){loadResource();};

			static Interface * const create(void) { return new SetScrollSpeed;};

			// R}h̃Rs[Ƃ //
			Interface &copy(Interface &rSrc)
			{
				SetScrollSpeed &tmp = dynamic_cast<SetScrollSpeed &>(rSrc);
				speed(tmp.speed());
				game(tmp.game());
				return (*this);
			};
	
			// ACCESS //

			const float	speed(void) const {return mSpeed;};
			void		speed(const float value){mSpeed = value;};

			sf::system::console::sprite::Sprite * const sprite(void) const {return mspSprite.get();};
		private:
		
			float mSpeed;

			static sf::system::console::sprite::PSprite mspSprite;
			static const sf::system::console::sprite::Info msSpriteInfo;
			static int msRefCount; 
		};// SetScrollSpeed
		
		// -- X^[gʒu̐ݒ |||||||||||||||||||||
		class SetRestartPosition : public Abstract {
			
			// LIFECYCLE // 

		public:
			SetRestartPosition(){;};
			virtual ~SetRestartPosition(){;};

			// OPERATORS //

			
			// OPERATIONS //

			// R}h̎s 
			void exec(const float position)
			{	game()->restartPosition(position);
			};

			// R}h̃Rs[Ƃ 
			Interface &copy(Interface &rSrc)
			{
				SetRestartPosition &tmp = dynamic_cast<SetRestartPosition &>(rSrc);
				game(tmp.game());
				return (*this);
			};

			

			void load(std::istream &is){;};
			void save(std::ostream &os){;};
			
			void load(void){loadResource();};

			static void loadResource(void);
			static void unloadResource(void);

			static Interface * const create(void) { return new SetRestartPosition;};

			// ACCESS //

			const TYPE id(void) const {return SET_RESTARTPOSITION;};

			sf::system::console::sprite::Sprite * const sprite(void){return mspSprite.get();};
		private:
			static sf::system::console::sprite::PSprite mspSprite;
			static const sf::system::console::sprite::Info msSpriteInfo;
		};// SetRestartPosition
		
		// Gzu //////////////////////////////////////////////////
		// p[^ 
		// int ... Փx
		// int ... Ghc
		// float ... oʒuw
		// float ... oʒux

		// 󒆓G̔zuR}h ||||||||||||||||||||||||
		class SetEnemy : public Abstract {

			// LIFECYCLE //

		public:
			SetEnemy();
			virtual ~SetEnemy();

			// OPERATORS //


			// OPERATIONS //

			// R}h̃Rs[Ƃ 
			Interface &copy(Interface &rSrc)
			{
				SetEnemy &tmp = dynamic_cast<SetEnemy &>(rSrc);
				game(tmp.game());
				x(tmp.x());
				y(tmp.y());
				z(tmp.z());
				enemyNo(tmp.enemyNo());
				difficulty(tmp.difficulty());
				return (*this);
			};

			void exec(const float position);
			// Xg[f[^[h
			void load(std::istream &is);
			// Xg[փf[^Z[u
			void save(std::ostream &os);
			// \[X̃[h
			void load(void){loadResource();};
			static void loadResource(void);
			// \[X̃A[h
			static void unloadResource(void);
			// zuf[^֕` 
			void draw(sf::application::scene::DispositionEditor * const pEditor,const float position,const bool bMouse);
			// IuWFNg̐ 			
			static Interface * const create(void) { return new SetEnemy;};
			// }EXړ̏ 
			void mouseMove(const int screenX,const int screenY,const DWORD mkey)
			{
				x((float)screenX - game()->background()->startOffsetX());
				y((float)screenY - game()->background()->startOffsetY());
				z(sf::application::enemy::Z_OFFSET_ENEMYS);
			};
			// L[̏ 
			void keyDown(const DWORD keyCode,const DWORD extKeyCode);

			// ACCESS //

			// zuf[^ʒu@X
			const float x() const {return mX;};
			void x(const float value){mX = value;};
			// zuf[^ʒu@Y
			const float y() const {return mY;};
			void y(const float value){mY = value;};
			// zuf[^ʒu@Z
			const float z() const {return mZ;};
			void z(const float value){mZ = value;};
			// G̎
			const int enemyNo() const {return mEnemyNo;};
			void enemyNo(const int value){mEnemyNo = value;};
			// Փx 
			const sf::application::scene::Game::DIFFICULTY difficulty() const {return mDifficulty;};
			void difficulty(const sf::application::scene::Game::DIFFICULTY value){mDifficulty = value;};
			// G̍ő
			const int max(void) const;
			// R}h̎
			const TYPE id(void) const {return SET_ENEMY;};
			
			// INQUIRY //

			const bool isListeningMouse(void) const {return true;};
			const bool isListeningKeyboard(void) const {return true;};

		private:

			int mEnemyNo;
			sf::application::scene::Game::DIFFICULTY mDifficulty;

			float mX;
			float mY;
			float mZ;

			static  const sf::system::console::sprite::Info msSpriteInfos[sf::application::enemy::MAX_TYPE];
			static  sf::system::console::sprite::PSprite mspSprites[sf::application::enemy::MAX_TYPE];

		};// SetEnemy

		// nGzuR}h |||||||||||||||||||||||||
		class SetArmy : public Abstract
		{
			
			// LIFECYCLE //
		
		public:
			
			SetArmy();
			virtual ~SetArmy();
			
			// OPERATORS //

			
			// OPERATIONS //

			// R}h̃Rs[Ƃ 
			Interface &copy(Interface &rSrc)
			{
				SetArmy &tmp = dynamic_cast<SetArmy &>(rSrc);
				game(tmp.game());
				x(tmp.x());
				y(tmp.y());
				z(tmp.z());
				enemyNo(tmp.enemyNo());
				difficulty(tmp.difficulty());
				return (*this);
			};
			
			// R}h̎s 
			void exec(const float position);
			// Xg[R}h̃[h
			void load(std::istream &is);
			// Xg[փR}hZ[u
			void save(std::ostream &os);
			// \[X̃[h
			void load(void){loadResource();};
			static void loadResource(void);
			// \[X̃A[h 
			static void unloadResource(void);
			// zu}bvɕ`
			void draw(sf::application::scene::DispositionEditor * const pEditor,const float position,const bool bMouse);
			// IuWFNg̐
			static Interface * const create(void) { return new SetArmy;};
			// L[R[h̏ 
			void keyDown(const DWORD keyCode,const DWORD extKeyCode);

			// ACCESS //

			// oʒu X 
			const float x() const {return mX;};
			void x(const float value){mX = value;};
			// oʒu Y 
			const float y() const {return mY;};
			void y(const float value){mY = value;};
			// oʒu Z
			const float z() const {return mZ;};
			void z(const float value){mZ = value;};
			// G̎ 			
			const int enemyNo() const {return mEnemyNo;};
			void enemyNo(const int value){mEnemyNo = value;};
			// Փx 
			const sf::application::scene::Game::DIFFICULTY difficulty() const {return mDifficulty;};
			void difficulty(const sf::application::scene::Game::DIFFICULTY value){mDifficulty = value;};
			// G̎ލő 
			const int max(void) const ;
			// IuWFNg̃^CvԂ 
			const TYPE id(void) const {return SET_ARMY;};
		
			// INQUIRY //
			
			const bool isListeningMouse(void) const {return true;};
			const bool isListeningKeyboard(void) const {return true;};
		
		private:
			// Gԍ
			int mEnemyNo;
			// Փx
			sf::application::scene::Game::DIFFICULTY mDifficulty;
			
			float mX;// oXW
			float mY;// oYW
			float mZ;// oZW

			static  const sf::system::console::sprite::Info msSpriteInfos[sf::application::enemy::MAX_ARMYS_TYPE];
			static  sf::system::console::sprite::PSprite mspSprites[sf::application::enemy::MAX_ARMYS_TYPE];

		};// SetArmy	

	}// command

	// R}h |||||||||||||||||||||||||||||
	class ControllerImpl : public Controller
	{
	public:
	
		// LIFECYCLE 
		
		ControllerImpl();
		~ControllerImpl();
		
		// OPERATIONS
		
		// zuf[^j
		void unload(void);
		// zuf[^t@C̃[h
		void load(const char * const pFileName);
		// zuf[^t@C̃Z[u
		void save(const char * const pFileName = NULL);
		// zuf[^s 		
		void exec(const float position);
		// w肵ʒuɃCe[^ړ
		void restart(const float position);

		void insertCommand(const float position,command::Interface * const pInterface)
		{	
			typedef std::pair<float,command::Interface * > value_type;
			pInterface->serialNo(mSerialNo++);
			mData.insert(value_type(position,pInterface));
		};// insertCommand()
		// VANoŔzuf[^폜
		void deleteCommand(const int serialNo){
			CommandList::iterator it = mData.begin();
			while(it != mData.end()){
				if(it->second->serialNo() == serialNo){
					mData.erase(it);
					break;
				}
				it++;
			}
		};// deleteCommand()

		// zu}bv̈ʒuœG폜 
		void deleteCommand(const float x,const float y,const float position,const command::TYPE type);
		// R}hIuWFNg̐ 
		static command::Interface * const create(const command::TYPE type){return (*mpCreateFunc[type])();};

		// ACCESS //

		// GameIuWFNgւ̃|C^
		sf::application::scene::Game * game(void){ return mpGame;};
		void game(sf::application::scene::Game *pGame){mpGame = pGame;};
		
		CommandList& commandList(void){return mData;};

		static const int commandMax(void) {return command::MAX;};

	private:
//		command::Interface * create(command::TYPE command_id);
		const int findCommand(const std::string &s);

		CommandList mData;
		CommandList::iterator mDataIter;
		std::string mFileName;
		sf::application::scene::Game * mpGame;
		int mSerialNo;
		// command parsep string table 
		static const std::string mCommand[command::MAX];
		static const CreateFuncPtr mpCreateFunc[command::MAX];

	};// ControllerImpl()

}
}
}

#endif // !defined(AFX_DISPOSITIONCONTROL_H__B18EC6D6_B30C_4A24_B747_D0EBBC6F71F2__INCLUDED_)
