//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// Effects.cpp: Effects NX̃Cve[V
//	F
// $Log: Effects.cpp,v $
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.6  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.5  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.4  2001/05/13 20:04:23  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.3  2001/05/12 08:17:25  fujiwara
// ʕیᔽNBUGC
//
// Revision 1.2  2001/05/12 00:50:48  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
///////////////////////////////////////////////////////////////////////////////

#pragma warning( disable : 4786 )	//STĽxO
// [[Nop
#include "sfdebug.h"

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>

#include "stdio.h"
#include "math.h"

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Effects.h"
#include "explosion.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace sf::application::effect;
using namespace sf::application;


IMPLEMENT_SINGLETON(Effects,Effects)

const Effects::LoaderFuncPtr Effects::mpLoaders[MAX_TYPE] = 
{	&Explosion::load
};

const int Effects::INIT_EFFECTS = 16;

const Effects::CreateFuncPtr Effects::mpFunctions[MAX_TYPE] = 
{	&Explosion::create };

// RXgN^ |||||||||||||||||||||||||||||
Effects::Effects()
{
	int i;
	mCount = 0;
	mMax = INIT_EFFECTS;
	
	for(i = 0;i < MAX_EFFECTS;i++){
		mpEffects[i] = NULL;
	}

}// Effects()

// fXgN^ ||||||||||||||||||||||||||||||
Effects::~Effects()
{
	int i;
	for(i = 0;i < MAX_EFFECTS;i++)
	{
		if(mpEffects[i]){
			delete mpEffects[i];
			mpEffects[i] = NULL;
		}
	}
}// ~Effects()

//  |||||||||||||||||||||||||||||||||
void Effects::initialize(){
	
	int i;
	for(i = 0;i < MAX_EFFECTS;i++)
	{
		if(mpEffects[i]){
			delete mpEffects[i];
			mpEffects[i] = NULL;
		}
	}

	// rbg}bṽ[h
	for(i = 0;i < MAX_TYPE;i++){
		(*mpLoaders[i])();
	}
	
	mCount = 0;
}// initialize()

// ëړ ||||||||||||||||||||||||||||||||
void Effects::move(void)
{
	int count = 0;
	for(int i = 0;i < MAX_EFFECTS;i++)
	{
		if(mpEffects[i]){
			mpEffects[i]->move();
		}
	}
}// move()

// e𐶐 ||||||||||||||||||||||||||||||
Character * const Effects::create(const TYPE id,const float x,const float y,const float z,sf::application::scene::Game *pGame,sf::application::Character *pCharacter)
{
	if(id >= MAX_TYPE)
		return NULL;

	if(mCount >= mMax)
		return NULL;
	
	for(int i = 0 ; i < MAX_EFFECTS; i++){
		if(mpEffects[i] == NULL){
			mpEffects[i] = (*mpFunctions[id])(x,y,z,pGame,pCharacter,i);
			mCount++;
			return mpEffects[i];
		}
	}
	return NULL;
}// create()

// 蔻 ||||||||||||||||||||||||||||||||
const bool Effects::hitCheck(Character * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_EFFECTS;i++){
		if(mpEffects[i]){
			if(mpEffects[i]->hitCheck(pDest)){
				mpEffects[i]->hit(pDest);
				pDest->hit(mpEffects[i]);
				return_ = true; 
			};
		}
	}
	return return_;
}// hitCheck(Character * const pDest)

const bool Effects::hitCheck(Characters * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_EFFECTS;i++){
		if(mpEffects[i]){
			if(pDest->hitCheck(mpEffects[i]))
				return_ = true;
		}
	}

	return return_;
}// hitCheck(Characters * const pDest)