//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// MyGroundBullets.cpp: MyGroundBullets NX̃Cve[V
//	F
// $Log: MyGroundBullets.cpp,v $
// Revision 1.1  2001/10/28 21:40:36  fujiwara
// DLLɕ
//
// Revision 1.4  2001/07/09 20:30:09  fujiwara
// Ȏgݍ
//
// Revision 1.3  2001/07/01 21:30:34  fujiwara
// [N`FbN
//
// Revision 1.2  2001/07/01 01:03:44  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.1  2001/06/10 21:17:34  fujiwara
// npǉ
//
// Revision 1.4  2001/05/29 01:12:35  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.3  2001/05/13 20:04:24  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.2  2001/05/12 00:49:34  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>

#include "stdio.h"
#include "math.h"

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Enemys.h"
#include "Armys.h"
#include "DispositionControl.h"
#include "AbstractCharacter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "MyGroundBullets.h"
#include "Target.h"
#include "Effects.h"
#include "Explosion.h"
#include "Enemys.h"


using namespace sf::application;
using namespace sf::system::console;
using namespace sf::application::player::bullet;

//////////////////////////////////////////////////////////////////////
// GroundBullets 
//////////////////////////////////////////////////////////////////////

const int GroundBullets::INIT_GROUNDBULLETS = 1;

// IuWFNg\bhւ̃|C^ 
const GroundBullets::CreateFuncPtr GroundBullets::mpFunctions[MAX_GROUNDTYPE] = {
	&GroundNormal::create
};

// eNX`[_[ւ̃|C^
const GroundBullets::LoaderFuncPtr GroundBullets::mpLoaders[MAX_GROUNDTYPE] = {
	&GroundNormal::load
};

int GroundNormal::mSoundID = 0;

// VOgp^[[܂邽߂̃}N
IMPLEMENT_SINGLETON(GroundBullets,GroundBullets)

// RXgN^ |||||||||||||||||||||||||||||
GroundBullets::GroundBullets()
{
	int i;
	for(i = 0;i < MAX_GROUNDBULLETS;i++){
		mpGroundBullets[i] = NULL;
	}

	mMax = INIT_GROUNDBULLETS;
	mCount = 0;
}// GroundBullets()

// fXgN^ ||||||||||||||||||||||||||||||
GroundBullets::~GroundBullets()
{
	int i;

	for(i = 0;i < MAX_GROUNDBULLETS;i++)
	{
		if(mpGroundBullets[i]){
			delete mpGroundBullets[i];
			mpGroundBullets[i] = NULL;
		}
	}


}// ~GroundBullets()

//  |||||||||||||||||||||||||||||||||
void GroundBullets::initialize(){
	
	int i;
	for(i = 0;i < MAX_GROUNDBULLETS;i++)
	{
		if(mpGroundBullets[i]){
			delete mpGroundBullets[i];
			mpGroundBullets[i] = NULL;
		}
	}

	// rbg}bṽ[h
	for(i = 0;i < MAX_GROUNDTYPE;i++){
		(*mpLoaders[i])();
	}
	mCount = 0;
}// initialize()

// ëړ ||||||||||||||||||||||||||||||||
void GroundBullets::move(void)
{
	int count = 0;
	for(int i = 0;i < MAX_GROUNDBULLETS;i++)
	{
		if(mpGroundBullets[i]){
			mpGroundBullets[i]->move();
		}
	}
}// move()

// e𐶐 ||||||||||||||||||||||||||||||
const bool GroundBullets::create(const TYPE id,const float x,const float y,const float z,sf::application::scene::Game * const pGame)
{
	if(id >= MAX_GROUNDTYPE)
		return false;

	if(mCount >= mMax)
		return false;
	
	for(int i = 0 ; i < MAX_GROUNDBULLETS; i++){
		if(mpGroundBullets[i] == NULL){
			mpGroundBullets[i] = (*mpFunctions[id])(x,y,z,pGame,i);
			mCount++;
			return true;
		}
	}
	return false;
}// create()

// 蔻 ||||||||||||||||||||||||||||||||
const bool GroundBullets::hitCheck(Character * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_GROUNDBULLETS;i++){
		if(mpGroundBullets[i]){
			if(mpGroundBullets[i]->hitCheck(pDest)){
				mpGroundBullets[i]->hit(pDest);
				pDest->hit(mpGroundBullets[i]);
				return_ = true;
			};
		}
	}
	return return_;
}// hitCheck(Character * const pDest)

const bool GroundBullets::hitCheck(Characters * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_GROUNDBULLETS;i++){
		if(mpGroundBullets[i]){
			if(pDest->hitCheck(mpGroundBullets[i]))
				return_ = true;
		}
	}

	return return_;
}// hitCheck(Characters * const pDest)

// |||||||||||||||||||||||||||||||||||||
// m[}e
// |||||||||||||||||||||||||||||||||||||

const console::sprite::Info GroundNormal::mSpriteInfo = {
	"media\\groundnormal.png",0.0f,0.0f,0.0f,0.0f,0xff000000,console::sprite::SPRITE2D
};

const float GroundNormal::mTextureHeight = 32.0f;
const float GroundNormal::mTextureWidth = 32.0f;
const float GroundNormal::INIT_SPEED = -3.0f;
const float GroundNormal::INIT_ACCEL = 1.0f;
std::auto_ptr<sf::system::console::sprite::Sprite> GroundNormal::mpSprite;

//  |||||||||||||||||||||||||||||||||
void GroundNormal::initialize()
{
	mHitRect.offsetTop(-4.0f);
	mHitRect.offsetLeft(-4.0f);
	mHitRect.offsetBottom(4.0f);
	mHitRect.offsetRight(4.0f);

	mHitRect.isChecking(false);
	mHitRect.characterPtr(this);
	mbHit = false;
	
	mObj.x(x());
	mObj.y(y());
	mObj.z(z() + GROUND_Z_OFFSET);

	mObj.color(0xc0ffffff);
	mObj.drawMode(DRAW_ADD);

	mObj.sprite(mpSprite.get());
	mObj.visibility(true);

	mObj.scalingX(1.0f);
	mObj.scalingY(1.0f);

	mObjTarget.x(x());
	mObjTarget.y(y() + Target::OFFSET_Y);
	mObjTarget.z(z() + GROUND_Z_OFFSET);

	mObjTarget.color(0x40ff0000);
	mObjTarget.drawMode(DRAW_ADD);

	mObjTarget.sprite(Target::sprite());
	mObjTarget.visibility(true);

	mObjTarget.scalingX(1.0f);
	mObjTarget.scalingY(1.0f);
	
	speed(INIT_SPEED * sf::system::instance()->deltaTime());
	
	mOffsetY = - Target::OFFSET_Y;

	direction(sf::system::PI);
	life(1);
	sf::system::instance()->sound()->play(mSoundID,1,false,false);
	mState = MOVE;
}// GroundNormal::initialize

// e̓ ||||||||||||||||||||||||||||||||
void GroundNormal::move(void){
	
	
	switch(mState){
	case MOVE:
		main();
		return;
	case BOMB:
		die();
		return;
	}


}// GroundNormal::move()

void GroundNormal::main(void)
{
		y(y() + speed());
		mObj.angle(mObj.angle() + 0.25f);
		mObj.y(y());
		mObj.scalingX(mObj.scalingX() - 0.02f);
		mObj.scalingY(mObj.scalingY() - 0.02f);
		
		mObjTarget.y(mObjTarget.y() + game()->scrollSpeed());
		
		mOffsetY += speed();
		mOffsetY -= game()->scrollSpeed();

		if(mOffsetY < 0.0f)
		{
			mState = BOMB;
			mHitRect.isChecking(true);
//			mTimer = 3;
		}
		

		if(mbHit || y() < (viewport::Y - mTextureHeight / 2.0f)){
			delete this;
			return;
		}
		
		// 蔻̕␳ 

		mHitRect.offsetBottom(mHitRect.offsetTop() - speed() );
}// main()

void GroundNormal::die(void)
{
	using namespace sf::application;
	direction(3.0f * sf::system::PI / 2.0f );
	speed( - game()->scrollSpeed());

	effect::Explosion *pExp = (effect::Explosion*)effect::Effects::instance()->create(effect::Effects::EXPLOSION,x(),y(),enemy::Z_OFFSET_ARMYS - 0.01f,game(),this);
	if(pExp){
		pExp->scaling(0.8f);
	}
	delete this;

}// die()

// eNX`ETEh̃[h |||||||||||||||||||||||||||
void GroundNormal::load(void){
	using namespace sf::system::console::sprite;
	if(!mpSprite.get()){
		std::auto_ptr<sf::system::console::sprite::Sprite> ptemp(sf::system::instance()->console()->createSprite(&mSpriteInfo)); 
		mpSprite = ptemp;
//		mpSprite = std::auto_ptr<sf::system::console::sprite::Sprite *>(sf::system::instance()->console()->createSprite(&mSpriteInfo));
	}
	using namespace sf::system;
	mSoundID = instance()->sound()->load("gnormal.wav");
}// GroundNormal::load()

Character * const GroundNormal::create(float x,float y ,float z,sf::application::scene::Game * const pGame,int index)
{
	GroundNormal * ptemp = new GroundNormal;
	ptemp->x(x);
	ptemp->y(y);
	ptemp->z(z);
	ptemp->index(index);
	ptemp->game(pGame);
	ptemp->initialize();
	return ptemp;
}// create();
