//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// ZK01.cpp: ZK01 NX̃Cve[V
//	F
// $Log: ZK01.cpp,v $
// Revision 1.1  2001/10/28 21:40:37  fujiwara
// DLLɕ
//
// Revision 1.9  2001/07/09 20:30:10  fujiwara
// Ȏgݍ
//
// Revision 1.8  2001/07/01 21:30:34  fujiwara
// [N`FbN
//
// Revision 1.7  2001/07/01 01:03:45  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.6  2001/06/03 09:22:32  fujiwara
// nGNXюGG̔
//
// Revision 1.5  2001/05/29 01:12:10  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.4  2001/05/17 12:31:29  fujiwara
// nGTv쐬
//
// Revision 1.3  2001/05/13 20:04:24  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.2  2001/05/12 00:48:35  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>

#include "stdio.h"
#include "math.h"

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Enemys.h"
#include "Armys.h"
#include "AbstractEnemy.h"
#include "EnemyBullets.h"
#include "DispositionControl.h"
#include "Effects.h"
#include "Explosion.h"


#include "ZK01.h"
#include "EB01.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace sf::application;
using namespace sf::application::enemy;

sf::system::console::sprite::PSprite ZK01::mspSprite;

int ZK01::mBalletTimer = 0;
int ZK01::mBalletTimerInit = 0;

const sf::system::console::sprite::Info ZK01::msSpriteInfo = 
{
	"media\\zk01.png",0.0f,0.0f,64.0f,64.0f,0xff000000,console::sprite::SPRITE2D
};

const int ZK01::SCORE = 20;

// RXgN^ |||||||||||||||||||||||||||||
ZK01::ZK01()
{
}// ZK01()

// fXgN^ ||||||||||||||||||||||||||||||
ZK01::~ZK01()
{
	Enemys::instance()->clear(index());
}// ~ZK01()


//  |||||||||||||||||||||||||||||||||
void ZK01::initialize()
{
	// 蔻 
	mHitRect.offsetTop(-24.0f);
	mHitRect.offsetBottom(24.0f);
	mHitRect.offsetLeft(-24.0f);
	mHitRect.offsetRight(24.0f);

	mHitRect.isChecking(true);
	mHitRect.characterPtr(this);
	direction((float)atan2((double)(game()->player()->y() - y()),(double)(game()->player()->x() - x())));
	
 	mDeltaTime = sf::system::instance()->deltaTime();
	mDeltaTimeRev = 1.0f / mDeltaTime;
	speed(3.0f * mDeltaTime);

	mDx = cosf(direction()) * speed();
	mDy = sinf(direction()) * speed();
	
	// Body  
	mObj.index(0);

	if(!mspSprite.get())
		load();

	mObj.sprite(mspSprite.get());
	
	mObj.z(z() + (float)index() * 0.0001f );
	mObj.x(x());
	mObj.y(y());
	mObj.visibility(true);
	mObj.color(0xffffffff);
	mObj.drawMode(sf::system::console::DRAW_TRANS);
	mObj.angle(direction());

	// Light
	mObjLight.z(z() + (float)index() * 0.0001f + 0.00001f);
	mObjLight.x(x());
	mObjLight.y(y());

	initLight();
	
	mbHit = false;
	mDirCount = 18.0f * mDeltaTime;
	mDirSpeed = (rand() & 1) ? -0.02f * mDeltaTime : 0.02f * mDeltaTime;
	
	mState = MOVE;
	
	mShootTimer = (int)((20.0f + (float)(rand() & 0x7)) * mDeltaTimeRev);
	mbShoot = false;
	mAccel = 0.2f * mDeltaTime;

	if(!mBalletTimerInit)
	{
		mBalletTimer = mBalletTimerInit = (3.0f - game()->currentDifficulty()) * mDeltaTimeRev;
		mbShoot = false;
	} else {
		mBalletTimer--;
		if(!mBalletTimer){
			mBalletTimer = mBalletTimerInit;
			mBalletTimerInit = (3.0f - game()->currentDifficulty()) * mDeltaTimeRev;
			mbShoot = false;
		} else {
			mbShoot = true;
		}
	}

}// initialize()

// eNX`̃[h |||||||||||||||||||||||||||
void ZK01::load(void){
	using namespace sf::system::console::sprite;
	if(!mspSprite.get()){
		sf::system::console::sprite::PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfo)); 
		mspSprite = ptemp;
	}
	Bullets::instance()->load(Bullets::EB01);
	AbstractEnemy::loadLight();
}// load()

// eNX`̃A[h |||||||||||||||||||||||||
void ZK01::unload(void){
	using namespace sf::system::console::sprite;
	PSprite ptmp(NULL);
	mspSprite = ptmp;
}// unload()

// G̓ ||||||||||||||||||||||||||||||||
void ZK01::move()
{
	using namespace sf::application;
	float tx,ty;

	y(y() + mDy);
	x(x() + mDx);

	switch(mState){
	case MOVE:
		// ̃C
		if(!--mDirCount){
			mDirCount = (int)(2.0f * mDeltaTimeRev);
			direction(direction() + mDirSpeed);
			speed(speed() + mAccel);
			mDx = cosf(direction()) * speed();
			mDy = sinf(direction()) * speed();
		}

		// WʒuApx̐ݒ		
		mObj.x(x());
		mObj.y(y());
		mObj.angle(direction());

		mObjLight.x(x());
		mObjLight.y(y());
		moveLight();
		
		// e 
		if(!mbShoot){
			if(!(mShootTimer--) ){
				tx = x() + 20.0f * cosf(direction());
				ty = y() + 20.0f * sinf(direction());
				EB01 *peb = (EB01 *)Bullets::instance()->create(Bullets::EB01,tx,ty,z() + 0.01f,game());
				peb->direction(Util::calcDirection(x(),y(),game()->player()->x(),game()->player()->y()));
				mbShoot = true;
			}
		}
		
		// eɂǂ̔
		if(mbHit)
		{
			die();
			return;
		}
		break;// case MOVE:

	case DEAD:
		if(!--mDirCount){
			delete this;
			return;
		}
		mObj.x(x());
		mObj.y(y());
		break;
	}

	// ʏ
	if(Util::checkArea(x(),y(),64.0f,64.0f))
		delete this;
}//move()



// eɂƂ̏ |||||||||||||||||||||||||
void ZK01::hit(Character * const pDest)
{
	mHitRect.isChecking(false);
	mbHit = true;

};

// G̐ ||||||||||||||||||||||||||||||||
sf::application::Character * const ZK01::create(float x,float y ,float z,sf::application::scene::Game * const pGame,int index)
{
	ZK01 * ptemp = new ZK01;
	ptemp->x(x);
	ptemp->y(y);
	ptemp->z(z);
	ptemp->index(index);
	ptemp->game(pGame);
	ptemp->initialize();
	return ptemp;
;}// create

//@񂾂Ƃ̏  |||||||||||||||||||||||||||
void ZK01::die(void)
{
	effect::Explosion *pExp = (effect::Explosion*)effect::Effects::instance()->create(effect::Effects::EXPLOSION,x(),y(),0.1f,game(),this);
	if(pExp){
		pExp->scaling(1.5f);
	}
	mDirCount = 2;
	mState = DEAD;
	game()->score(game()->score() + SCORE);

};// die()

//  SCxg ||||||||||||||||||||||||||||
void ZK01::allBomb(void)
{
	die();
}// allBomb()