//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// DispositionEditorImpl.cpp: DispositionEditorImpl NX̃Cve[V
//	F
// $Log: DispositionEditorImpl.cpp,v $
// Revision 1.1.1.1  2001/11/06 21:29:04  fujiwara
// no message
//
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.9  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.8  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.7  2001/07/01 01:03:43  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.6  2001/05/29 01:13:06  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.5  2001/05/17 12:34:10  fujiwara
// nGTv쐬
//
// Revision 1.4  2001/05/12 12:48:28  fujiwara
// zuGfB^쐬ɔύXEǉ
//
// Revision 1.3  2001/05/12 00:50:48  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

#pragma warning( disable : 4786 )	//STĽxO
// [[Nop
#include "sfdebug.h"

// SYSTEM INCLUDES

#include <stack>
#include <list>
#include <vector>
#include <map>
#include <fstream>

// PROJECT INCLUDES


#include "exception.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "Scene.h"
#include "main.h"
#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjQuadrangle.h"
#include "ObjRectangle.h"
#include "Background.h"
#include "AbstractScene.h"
#include "character.h"
#include "hit.h"
#include "MySHip.h"
#include "Enemys.h"
#include "Armys.h"
#include "Game.h"
#include "DispositionControl.h"
#include "DispositionEditorImpl.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

using namespace sf::application::scene;
using namespace sf;
using namespace sf::system::console;

const DWORD DispositionEditorImpl::CURRENT_SPECULAR = 0x202080;
const DWORD DispositionEditorImpl::NORMAL_SPECULAR = 0;

// RXgN^ |||||||||||||||||||||||||||||
DispositionEditorImpl::DispositionEditorImpl() : AbstractScene()
{
	mbCallBack = false;
	mbListening = false;
	
	mEditType = application::disposition::command::SET_ENEMY;
	mpEditCommand = sf::application::disposition::Controller::create(mEditType);
	mpEditCommand->load();

	mpGame = NULL;

	mState = INITIALIZE;
	mDifficulty = sf::application::scene::Game::EASY;

	visibility(false);
}// DispositionEditorImpl()

// fXgN^ ||||||||||||||||||||||||||||||
DispositionEditorImpl::~DispositionEditorImpl()
{
	mbCallBack = false;
	
	if(mpInput){
		mpInput->removeMouseListener(this);
		mpInput->removeKeyboardListener(this);
	
		mpInput->hideMouseCursor();
	
		mpInput->removeKeyboardListener(mpEditCommand);
		mpInput->removeMouseListener(mpEditCommand);
	}
	
	unload();
	delete mpEditCommand;

}// ~DispositionEditorImpl()


void DispositionEditorImpl::move(void)
{
	switch(mState)
	{
	case INITIALIZE:
		initialize();
		return;
	case MAIN:
		// dwhsL[ꂽH
		if(mpInput->exit(true)) {
			exitKeyPressed(this);
			return;
		}
		mpGame->printEditInfo();
		return;
	}
}

//  |||||||||||||||||||||||||||||||||
void DispositionEditorImpl::initialize(void)
{
	mpInput->addMouseListener(this);
	mpInput->addKeyboardListener(this);
	mpInput->showMouseCursor();

	mpInput->addKeyboardListener(mpEditCommand);
	mpInput->addMouseListener(mpEditCommand);
	
	mState = MAIN;
	mbCallBack = true;
	mbListening = true;
	mpGame->background()->edit(true);

	load();
	z(0.1f);
	visibility(true);
}

//DispositionEditorImpl Scene ̏I ---------------------------------------------------------
void DispositionEditorImpl::endOfScene(Scene *pScene)
{
	mpGame->background()->edit(false);
	mpGame->controllerPtr()->restart(mpGame->scrollY());
	callSceneEvent(&sf::application::scene::Listener::endOfScene);
	delete this;
} //endOfScene()

// exit key ꂽI ------------------------------------------------------
void DispositionEditorImpl::exitKeyPressed(Scene *pScene)
{
	mpGame->background()->edit(false);
	mpGame->controllerPtr()->restart(mpGame->scrollY());
	callSceneEvent(&sf::application::scene::Listener::exitKeyPressed);
	delete this;
} //endOfScene()

// }EXzC[ |||||||||||||||||||||||||
void DispositionEditorImpl::mouseWheel(const int screenX,const int screenY,const DWORD mkey)
{
	using namespace sf::system::input::mouse;
	int wheel = (int)(mkey & 0xffff0000) / 65536;
	
	float speed = 1.0f;

	if(MKEY_SHIFT & mkey)
		speed = 8.0f;

	if(MKEY_CONTROL & mkey)
		speed = 32.0f;
	
	if(wheel > 0)
		mpGame->scrollY(mpGame->scrollY() + speed);
	else
		mpGame->scrollY(mpGame->scrollY() - speed);
	
	if(mpEditCommand)
		mpEditCommand->mouseWheel(screenX,screenY,mkey);
	
}// mouseWheel()

// L[{[hꂽI
void DispositionEditorImpl::keyDown(const DWORD keyCode,const DWORD extKeyCode)
{	
	using namespace sf::system::input;
	using namespace sf::application::disposition::command;

	float speed = 1.0f;
	int max = 0;
	
	if(extKeyCode & keyboard::SHIFT)
		speed = 8.0f;

	switch((char)keyCode)
	{
	case 'G':
		endOfScene(this);
		break;
	case 'S':
		mpGame->controllerPtr()->save();
		break;
	case VKEY_DOWN:
		mpGame->background()->startOffsetY(mpGame->background()->startOffsetY() + speed);
		break;
	case VKEY_UP:
		mpGame->background()->startOffsetY(mpGame->background()->startOffsetY() - speed);
		break;
	case VKEY_LEFT:
		mpGame->background()->startOffsetX(mpGame->background()->startOffsetX() - speed);
		break;
	case VKEY_RIGHT:
		mpGame->background()->startOffsetX(mpGame->background()->startOffsetX() + speed);
		break;
	case '1':
//		if((int)selectedObj() > 0)
//			selectedObj(selectedObj() - 1);
		break;
	case '2':
//		max = (mEditType == SET_ENEMY)?(sf::application::enemy::MAX_TYPE):(sf::application::enemy::MAX_ARMYS_TYPE);
//		if((int)selectedObj() < max)
//			selectedObj(selectedObj() + 1);
		break;
	case '3':
		mpInput->removeKeyboardListener(mpEditCommand);
		mpInput->removeMouseListener(mpEditCommand);
		delete mpEditCommand;
		
		if((int)mEditType == (disposition::command::MAX - 1)){
			mEditType = disposition::command::SET_SCROLLSPEED;
		} else {
			mEditType = (disposition::command::TYPE)((int)mEditType + 1);
		}
		mpEditCommand = sf::application::disposition::Controller::create(mEditType);

		mpEditCommand->load();
		mpEditCommand->game(mpGame);
	
		mpInput->addKeyboardListener(mpEditCommand);
		mpInput->addMouseListener(mpEditCommand);

		break;
	}

}// keyDown()

// ENbN  ||||||||||||||||||||||||||||||
void DispositionEditorImpl::rightButtonDown(const int screenX,const int screenY,const DWORD mkey)
{
	using namespace sf::application::disposition;
	mpGame->controllerPtr()->deleteCommand((float)screenX,(float)screenY,mpGame->scrollY(),mEditType);
}// rightButtonDown

// NbNꂽ ||||||||||||||||||||||||||
void DispositionEditorImpl::leftButtonDown(const int screenX,const int screenY,const DWORD mkey)
{
	using namespace sf::application::disposition;
	
	// R}h}B //
	
	mpInput->removeKeyboardListener(mpEditCommand);
	mpInput->removeMouseListener(mpEditCommand);

	mpGame->controllerPtr()->insertCommand(mpGame->scrollY(),mpEditCommand);
	
	command::Interface *mpi = sf::application::disposition::Controller::create(mEditType);
	mpi->copy(*mpEditCommand); 
	mpEditCommand = mpi;
//	mpEditCommand->load();
//	mpEditCommand->game(mpGame);		

	mpInput->addKeyboardListener(mpEditCommand);
	mpInput->addMouseListener(mpEditCommand);

}// leftButtonDown();

// G̃eNX`[h |||||||||||||||||||||||
void DispositionEditorImpl::load(void){
}// load()

// G̃eNX`̃A[h |||||||||||||||||||||||
void DispositionEditorImpl::unload(void){
}// unload()

// }bv̕\ |||||||||||||||||||||||||||
void DispositionEditorImpl::draw(){
	if(!visibility())
		return;

	using namespace sf::application::disposition;

	Controller::CommandList::iterator it = mpGame->controllerPtr()->commandList().begin();
	while(it != mpGame->controllerPtr()->commandList().end())
	{
		it->second->load();
		it->second->draw(this,it->first,false);
		it++;
	}

	// J[\ʒu

	mpEditCommand->draw(this,0.0f,true);

}// draw()

