/**
 * @file Input.h
 * @brief ́iL[{[hE}EXEWCXeBbNj̃C^[tF[XA萔`Ȃǂs.
 * ۂ̏́AOSˑ̎NXɔC܂B
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dǂݍݖh~}N
#if !defined(AFX_INPUT_H__D4B94DF3_02D8_42CE_AC7A_A98CCC9D0115__INCLUDED_)
#define AFX_INPUT_H__D4B94DF3_02D8_42CE_AC7A_A98CCC9D0115__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "sf.h"
extern "C" {
namespace sf{
	namespace system {
		/// ͎̃NXE萔Ȃǂׂ͂ĂɊ܂܂܂B
		namespace input {
			/// }EX֘ÃNXE萔Ȃǂׂ͂ĂɊ܂܂܂
			namespace mouse {
				/// }EXCxgœɉꂽL[R[h񋓂
				enum MKEY_CODE {
					MKEY_CONTROL = 0x1,///< Rg[L[}XN
					MKEY_LBUTTON = 0x2,///< }EX{^}XN
					MKEY_RBUTTON = 0x4,///< }EXE{^}XN
					MKEY_SHIFT = 0x8,///< VtgL[}XN
					WHEEL_MASK = 0xffff0000///< }EXzC[}XN
				};

				/** }EXCxgXi|
				 *
				 * }EXCxg̃Xi[łB}EX̃Cxgׂ͂ẴXi[C^[tF[Xʂčs܂B<br>
				 * }EXCxgꍇÃC^[tF[XpĎACxg𔭍sInputC^[tF[X
				 * Input::addMouseListener()\bhœo^܂B
				 */
				class Listener 
				{
				public:

					/** {^ꂽ.
					 * }EX̍{^ꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void leftButtonDown(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** {^ꂽ.
					 * }EX̍{^ꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void leftButtonUp(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** {^_uNbNꂽ.
					 * }EX̍{^_uNbNꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void leftButtonDoubleClick(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** E{^ꂽ.
					 * }EX̉E{^ꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE*/
					virtual void rightButtonDown(const int screenX,const int screenY,const DWORD mkey) = 0;
				
					/** E{^ꂽ.
					 * }EX̉E{^ꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void rightButtonUp(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** E{^_uNbNꂽ.
					 * }EX̉E{^_uNbNꂽƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void rightButtonDoubleClick(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** }EXJ[\Wω.
					 * }EXJ[\WωƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void mouseMove(const int screenX,const int screenY,const DWORD mkey) = 0;

					/** }EXzC[̈ʒuω.
					 * }EXzC[̈ʒuωƂɌĂяo郁\bhłB
					 * @param screenX XN[̃}EXXW
					 * @param screenY XN[̃}EXYW
					 * @param mkey ɉꂽL[R[h @ref MKEY_CODE */
					virtual void mouseWheel(const int screenX,const int screenY,const DWORD mkey) = 0;
					
					/** }EXCxg󂯎Ԃǂ₢킹.
					 * @retval true ݃}EXCxg󂯎Ă
					 * @retval false ݃}EXCxgۂĂ */
					virtual const bool isListeningMouse(void) const = 0;

					/** }EXCxg𔭍sTalker폜ꂽ. 
					 * }EXCxg𔭍sTalker폜鎞ɌĂ΂܂B
					 * ̃\bhĂ΂ꂽȍ~́AXi[Input::removeMouseListener()ĂяoĂ͂܂B*/					 
					virtual void mouseTalkerIsDeleted(void) = 0;
				};
			};

			/// L[{[h֘A̒萔ENXׂ͂ĂɊ܂܂܂B
			namespace keyboard {
				/// L[R[h
				enum EXTEND_KEYCODE {
					CONTROL = 0x1,///< Rg[L[
					SHIFT   = 0x8///< VtgL[
				};

				/// zL[R[h
				enum VIRTUAL_KEYCODE {
					VKEY_LEFT = 0x25,///< J[\L[ 
					VKEY_UP = 0x26,///< J[\L[
					VKEY_RIGHT = 0x27,///< EJ[\L[
					VKEY_DOWN = 0x28///< J[\L[
				};

				/** zL[R[hNX. 
				 * @note ȂȃNX̂ݕs
				 */
				class SFDLL VKey {
				public:
					static const int UP;///< J[\L[
					static const int DOWN;///< J[\L[
					static const int LEFT;///< J[\L[
					static const int RIGHT;///< EJ[\L[
				};

				/** L[{[hCxgXi|.
				 *
				 * L[{[hCxg̃Xi[łBL[{[h̃Cxgׂ͂ẴXi[C^[tF[Xʂčs܂B<br>
				 * L[{[hCxgꍇÃC^[tF[XpĎACxg𔭍sInputC^[tF[X
				 * Input::addKeyboardListener()\bhœo^܂B*/
	            class Listener 
				{
				public:
					/** L[ꂽ. 
				     * L[ꂽꍇɌĂяo܂B
					 * @param keyCode L[R[h
					 * @param extKeyCode gL[R[h EXTEND_KEYCODE Q */
					virtual void keyDown(const DWORD keyCode,const DWORD extKeyCode) = 0;

					/** L[ꂽ. 
				     * L[ꂽꍇɌĂяo܂B
					 * @param keyCode L[R[h
					 * @param extKeyCode gL[R[h @ref EXTEND_KEYCODE Q */
					virtual void keyUp(const DWORD keyCode,const DWORD extKeyCode) = 0;

					/** L[{[hCxg󂯎Ԃǂ₢킹.
					 * TalkerListener݃L[{[hCxg󂯎Ԃɂ邩ǂmF邽߂̃\bhłB<br>
					 * ꎞIɃL[{[hCxg󂯎肽Ȃꍇ͂̃\bhĂ΂ꂽƂfalseԂ܂B
					 * @retval true ݃L[{[hCxg󂯎Ă
					 * @retval false ݃L[{[hCxgۂĂ */
					virtual const bool isListeningKeyboard(void) const = 0;
					
					/** L[{[hCxg𔭍sTalker폜ꂽ. 
					 * L[{[hCxg𔭍sTalker폜鎞ɌĂ΂܂B<br>
					 * ꂪĂ΂ꂽATalkerg̓ɑ݂ȂƂɂȂ̂ŁA
					 * ̃\bhĂ΂ꂽȍ~́AXi[͐΂Input::removeKeyboardListener()ĂяoĂ͂܂B
					 * ČĂяȍԂ͕sƂȂ܂B */					 
					virtual void keyboardTalkerIsDeleted(void) = 0;
				};
			};
			
			/// ͋@Rg[.
			/*! CvbgfoCX̃Rg[sC^[tF[Xł */
			class Input  
			{
				// LIFECYCLE //
			public:
				/// RXgN^
				Input(){};
				/// fXgN^
				virtual ~Input(){};
				// OPERATORS //
				// OPERATIONS //
				/// InputC^[tF[X̏
				/*! InputC^[tF[X̎NX邽߂ɗpӂĂ܂B<br>
				    ʏ탉Cu𗘗p鑤炱̃\bhĂяoƂ͂܂B 
					@throw FatalErrorException Ɏsꍇ͓̓foCXȂꍇ */
				virtual void initialize(void) = 0;

				/** ̓foCX̏Ԃ̍XV. 
				 * ̓foCX̏ԂǂݎA֘AϐXV܂B*/
				virtual void update(void) = 0;

				/** }EXXi[̓o^.
				 * mouse::Listener o^܂B<br>
				 * }EXCxg󂯎肽NXmouse::ListenerC^[tF[XA
				 * ̃\bhœo^邱Ƃɂ}EXCxg󂯎邱Ƃł܂B 
				 * @param pListener mouse::Listener C^[tF[X̃|C^ */
				virtual void addMouseListener(mouse::Listener * const pListener) = 0;
				
				/** }EXXi[̍폜.
				 * mouse::Listener 폜܂B<br>
				 * mouse::Listener g폜ƂÃ\bhĂяoāATalkerɎg̍폜ʒm܂B
				 * @param pListener mouse::Listener C^[tF[X̃|C^ */
				virtual	void removeMouseListener(mouse::Listener * const pListener) = 0;

				/** L[{[hXi[̓o^.
				 * keyboard::Listener o^܂B<br>
				 * L[{[hCxg󂯎肽NXkeyboard::ListenerC^[tF[XA
				 * ̃\bhœo^邱ƂɂL[{[hCxg󂯎邱Ƃł܂B 
				 * @param pListener keyboard::Listener C^[tF[X̃|C^ */
				virtual void addKeyboardListener(keyboard::Listener * const pListener) = 0;

				/** L[{[hXi[̍폜.
				 * keyboard::Listener 폜܂B<br>
				 * keyboard::Listener g폜ƂÃ\bhĂяoāATalkerɎg̍폜ʒm܂B
				 * @param pListener keyboard::Listener C^[tF[X̃|C^ */
				virtual void removeKeyboardListener(keyboard::Listener * const pListener) = 0;

				// ACCESS //

				/** {^ꂽǂ. 
				 * {^(WCXeBbNEJ[\L[jꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool left(const bool bTrig = false) const = 0;

				/** E{^ꂽǂ. 
				 * E{^(WCXeBbNEJ[\L[jꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool right(const bool bTrig = false) const = 0;

				/** {^ꂽǂ. 
				 * {^(WCXeBbNEJ[\L[jꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool up(const bool bTrig = false) const = 0;

				/** {^ꂽǂ. 
				 * {^(WCXeBbNEJ[\L[jꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool down(const bool bTrig = false) const = 0;

				/** A{^ꂽǂ. 
				 * A{^(WCXeBbNA{^EL[{[hZjꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool buttonA(const bool bTrig = false) const = 0;

				/** B{^ꂽǂ. 
				 * B{^(WCXeBbNB{^EL[{[hXjꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool buttonB(const bool bTrig = false) const = 0;

				/** C{^ꂽǂ. 
				 * C{^(WCXeBbNC{^EL[{[hCjꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool buttonC(const bool bTrig = false) const = 0;

				/** D{^ꂽǂ. 
				 * D{^(WCXeBbND{^EL[{[hVjꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool buttonD(const bool bTrig = false) const = 0;

				/** start{^ꂽǂ. 
				 * start{^(WCXeBbNA{^EL[{[hspacejꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool start(const bool bTrig = false) const = 0;

				/** exit{^ꂽǂ. 
				 * exit{^(L[{[hESCjꂽꍇtrueԂ܂B<br>
				 * @param bTrig false ̎́AςȂ̏ꍇłtrueԋp܂B<br>
				 * truȅꍇ́AۂɃ{^ꂽƂ̂݁Atrueԋp܂B
				 * @retval true {^Ă
				 * @retval false {^ĂȂ@*/
				virtual const bool exit(const bool bTrig = false) const = 0;

				/** }EXJ[\\ */
				virtual void showMouseCursor(void) = 0;
				/** }EXJ[\B */
				virtual void hideMouseCursor(void) = 0; 
				/** ݂̃}EXJ[\̏Ԃ₢킹 
				 @retval true }EXJ[\͕\Ă܂B
				 @retval false }EXJ[\͔\ƂȂĂ܂B*/
				virtual const bool mouseCursorVisibility(void) const = 0;

				// INQUIRY //
				/** ݂InputC^[tF[X̏Ԃ₢킹 
				 * @retval true ݁Ap\łB
				 * @retval false ݁Aps\łB*/
				virtual const bool isEnabled(void) const = 0;
			};
			// ----------------------------------------------------------------
			/// CxgXi[NX 
			// ----------------------------------------------------------------
			class Listener
			{
			public:
				virtual void deviceStateChanged(Input * const pInput) = 0;
				virtual void eventTalkerIsDeleted(void) = 0;
			};// Listener
			

		}// namespace input
	}// namespace system
}// namespace sf
}
#endif // !defined(AFX_INPUT_H__D4B94DF3_02D8_42CE_AC7A_A98CCC9D0115__INCLUDED_)
