/**
 * @file Sound.h
 * @brief TEh̃NXA萔Aϐ`sB
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_SOUND_H__87CC9C63_C71A_4276_9ACF_912DC2A4DD44__INCLUDED_)
#define AFX_SOUND_H__87CC9C63_C71A_4276_9ACF_912DC2A4DD44__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
extern "C" {
namespace sf{
	namespace system {
		/// TEh֌W̃NXE萔Ȃǂׂ͂ĂɊ܂܂܂B
		namespace sound {
			const int OBJECT_MAX = 128;///< TEhIuWFNg̍ő吔
			const int LOAD_ERROR = -1; ///< [hG[
			/// TEh̃^Cv
			enum TYPE
			{
				NONE,///< ȂȂ
				TEST///< TEST
			};

			/// TEhE{[
			namespace volume {
				const int MAX = 0;///< ő剹
				const int MIN = -9600;///< ŏ
			};

			/** TEh𐧌䂷.
			 * BGMEʉ𐧌䂷C^[tF[XłB*/
			class Sound 
			{
				// LIFECYCLE //
			public:
				/// RXgN^
				Sound(){};
				/// fXgN^
				virtual ~Sound(){};
				// OPERATORS //
				// OPERATIONS //
				/** TEhC^[tF[X̏s 
				@@throw FatalErrorException Ɏsꍇ */
				virtual void initialize(void) = 0;
	
				/** w肵TEhԍɃTEht@C̃[hs.
				 * @param ObjNo [hTEhIuWFNg̔ԍ
				 * @param pFileName t@Cl[̃|C^ */
				virtual void load(const int ObjNo,const char * const pFileName) = 0;

				/** TEht@C̃[hs.
				 * ĂTEhԍ΁AɃ[hA[hԍԂ܂B
				 * @param pFileName TEht@CPATH
				 * @return TEhԍ(0 - OBJECT_MAX) */
				virtual const int load(const char * const pFileName) = 0;

				/** TEh\[X̃A[hs.
				 * TEh\[XJ܂ */
				virtual void unload() = 0;

				/** TEh̍Đs.
				 * @param ObjNo TEhԍ
				 * @param Repeat s[g(0́)
				 * @param bPrimary vC}obt@ōĐ邩ǂ
				 * @param bSync BGMɓčĐ邩ǂ*/
				virtual void play(const int ObjNo,const DWORD Repeat,const bool bPrimary,const bool bSync) = 0;

				/** TEhĐ~߂. 
				 * @param ObjNo ~߂TEh̔ԍ */
				virtual void stop(const int ObjNo = 0) = 0;

				/** TEhIuWFNg̍XVȂ.
				 * Đ̍XVƂs܂B*/
				virtual void update() = 0;
				// ACCESS //

				/** }X^[{[(Ŝ̉)Zbg. 
				 * @param value  volume::MIN ` volume::MAX Ԃł̒l */
				virtual void masterVolume(const int value) = 0;

				/** }X^[{[(Ŝ̉)ǂݏo. 
				* @return   volume::MIN ` volume::MAX Ԃł̒l*/
				virtual const int masterVolume() const = 0;
				
				/**@ő剹ʂZbg. 
				 * @param value  volume::MIN ` volume::MAX Ԃł̒l*/
				virtual void volumeMax(const int value) = 0;

				/** ő剹ʂǂݏo. 
				* @return   volume::MIN ` volume::MAX Ԃł̒l*/
				virtual const int volumeMax()  const = 0;
				
				// INQUIRY //
				
				/**  TEhIuWFNg̏Ԃ₢킹
				 * @retval true ݎgp\
				 * @retval false ݎgps*/
				virtual const bool isEnabled(void) const = 0;

			};
		}
	}
}
}
#endif // !defined(AFX_SOUND_H__87CC9C63_C71A_4276_9ACF_912DC2A4DD44__INCLUDED_)
