/**
 * @file System.h
 * @brief OSւ̃C^[tF[Xł
 *
 * @author S.F.
 * @version $Id:
 * 
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */
#if !defined(AFX_System_H__DD8D138F_B5A2_4C7B_B543_6BCE1BFB1ED5__INCLUDED_)
/// 2dCN[hh~邽߂̒`
#define AFX_System_H__DD8D138F_B5A2_4C7B_B543_6BCE1BFB1ED5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>
#include "sf.h"

extern "C" {

/** S.F.̖O.
 * ͑̃CuƖȌՓ˂邽߂ɒ`Ă܂B 
 * S.F.`閼OԁENXEϐE萔ׂ͂Ă̒Ɋ܂܂܂B */
namespace sf {

/** DWORD ̒` */
typedef unsigned long DWORD;///< ́AWindowsAPĨCu荞܂ȂĂ悢悤DWORD`Ă܂B

namespace application {
	class Main;
}

/** VXeO. 
 *̖OԂ́AVXe\[X̃ANZXsNXA
 *ǂ̂悤ȖOԂłgp{IȒ萔i[܂B
 */
namespace system {

const float PI = 3.1415926f;///< 
const int MAX_PATH_ = 256;///< őt@CPATH̒

namespace console {
	class Console;
}

namespace sound {
	class Sound;
}

namespace input {
	class Input;
}

// System ̃C^[tF[X --------------------------------------------------

const DWORD TIMER_INTERVAL = 32;///< 1t[̎(ms)

const float FRAME_SEC = 30.0f;///< Frame Per Second (FPS)

/** VXeNX.
 * o͂ȂǁAVXe\[Xւ̃ANZX𒊏ۉ邽߂
 * `ĂC^[tF[XłB
 * sf::system::instance()ŃC^[tF[X̃|C^iۂ͎NX̃CX^X̃|C^LXǵj擾AANZX܂B
 */
class System
{
	// LIFECYCLE
public:
	/// RXgN^(_~[)
	System(){}; ///< RXgN^(_~[).
	/// fXgN^i_~[j
	virtual ~System(){}; ////< fXgN^(_~[).
	// OPERATORS

	// OPERATIONS

	virtual void wait(void) = 0; ///< ̃t[̃^C~O܂ő҂
	
	/** G[bZ[W\ăAvP[VI.
	 * G[bZ[W_CAO\(Windowsn̏ꍇ)āAAvP[VI܂B
	 * @param errString o͕ւ̃|C^ */
	virtual void errorTerminate(const wchar_t *errString) = 0;
	/** G[bZ[W\.
	 * @param errString o͕ւ̃|C^ */
	virtual void outputError(const wchar_t *errString) = 0;

	// ACCESS
	
	/** t[Ԋuݒ肷. 
	 * @param msValue 1t[̊ԊumsPʂŎw肷 */
	virtual void timerInterval(const unsigned long msValue) = 0;
	
	/** t[Ԋu擾
	 * @return 1t[̊Ԋu(ms) */
	virtual const unsigned long timerInterval (void) const = 0;
	
	/** msPʂ̃VXeԂ擾.
	 * @return msPʂ̃VXe */
	virtual const DWORD	time(void) const = 0;

	/** R\[C^[tF[X̃|C^擾.
	 * `(XvCgEwi摜) p̃C^[tF[X̃|C^擾܂B
	 * ʂւ̕`Ƃ͂̃|C^ʂčs܂B
	 * @return Console C^[tF[Xւ̃|C^ */
	virtual console::Console * const console(void) = 0;

	/** TEhC^[tF[X̃|C^擾.
	 * TEhóiBGMEʉjp̃C^[tF[X̃|C^擾܂B
	 * TEho͂͂̃|C^ʂčs܂B
	 * @return Sound C^[tF[X̃|C^ */
	virtual sound::Sound * const sound(void) = 0;
	
	/** ̓C^[tF[X̃|C^擾.
	 * ́iL[{[hE}EXEWCXeBbNjp̃C^[tF[X̃|C^擾܂.
	 * @return Input C^[tF[X̃|C^ */
	virtual input::Input * const input(void) = 0;

	/** CC^[tF[X̃|C^擾.
	 * Q[AvP[VCC^[tF[X̃|C^擾܂B
	 * ̃C^[tF[X́ASceneRg[邽߂ɂ܂B
	 * @return Main C^[tF[Xւ̃|C^ */
	virtual application::Main * const main() = 0;
	
	/** CC^[tF[Xւ̃|C^Zbg 
	 * @return pMain CC^[tF[Xւ̃|C^
 	 */
	virtual void main(application::Main * const pMain ) = 0;
	
	/** 30FPSƂ̔䗦擾.
	 * ̒l1t[ł̈ړ̂̈ړlƂȂA30FPS̏ꍇ1.0fA60FPS̏ꍇ0.5fƂȂ܂B
	 * VXẽftHg30FPSł̂ŁA60FPSȂǂɂꍇAG̈ړx{ɂȂ̂ŃQ[ɂȂ܂B
	 * ̂悤ȏꍇdeltaTime̒l𗘗pēG̈ړx𒲐܂B
	 * @return 䗦(TIMER_INTERVAL / 32.0f) */
	virtual const float deltaTime(void) = 0;
	
	/** ݂FPS擾.
	 * ݐݒ肳ĂFPSl擾܂
	 * @return FPSl */
	virtual	const float	framePerSec(void) = 0;
	
	// INQUIRY
	/** VXeANeBuł邩ǂ₢킹
	 * @retval true 
	 * @retval false łȂ̂SystemC^[tF[X͎gpł܂*/
	 virtual bool isActive(void) = 0;
}; // System

/** SystemCX^Xւ̃|C^𓾂.
 * SystemC^[tF[Xւ̃|C^擾܂B
 * ̃\bhgpāASystemC^[tF[X擾AVXe\[XɃANZX܂B
 * @return System C^[tF[X̃|C^ */
SFDLL System * const instance(void);

} // namespace system
} // namespace sf
}
#endif // !defined(AFX_System_H__DD8D138F_B5A2_4C7B_B543_6BCE1BFB1ED5__INCLUDED_)
