/**
 * @file SystemWin32.h
 * @brief Windowsւ̃C^[tF[Xł
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_SYSTEMWIN32_H__9E630867_3321_4C17_8D1A_E0EAC93A1647__INCLUDED_)
#define AFX_SYSTEMWIN32_H__9E630867_3321_4C17_8D1A_E0EAC93A1647__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sfinterface.h"
namespace sf {
	namespace system {

/** WindowMessageC^[tF[X. 
 * WindowbZ[W邽߂̃C^[tF[XłB
 * ́Astd::mapƑgݍ킹āAWindowbZ[WIɏ邽߂ɒ`Ă܂B
 * @note ̕ӂ̎̍ĺA<a href="http://puyon.pns.to/program/afl/h0003.html">Ղ悧񂳂̃Cũy[W</a> QƂĂB<br>
 * ኱Ղ悧񂳂̃CuĂԂԂ͂܂B*/
class SF_INTERFACE WindowMessage
{
public:
	/// fXgN^
	virtual ~WindowMessage(){;};
	/** bZ[Ws 
	 * @param hwnd HWND EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM 
	 * @return LRESULT */
	virtual LRESULT call(const HWND hwnd,const WPARAM wParam,const LPARAM lParam) = 0;
};

/** WindowMessageC^[tF[X̎NX */
template<class T> class WindowMessageImpl : public WindowMessage
{
public:
	/// RXgN^
	WindowMessageImpl();
	/// fXgN^
	virtual ~WindowMessageImpl(){}
	/** RXgN^.
     * @param pClass Ăяo\bhLĂNX̃CX^X̃|C^
	 * @param pAddress Ăяoo\bh̃AhXĂ|C^ */
	WindowMessageImpl(T* const pClass,LRESULT (T::* pAddress)(const HWND,const WPARAM,const LPARAM));
	
	/** Ăяo\bh̏Zbg. 
     * @param pClass Ăяo\bhLĂNX̃CX^X̃|C^
	 * @param pAddress Ăяoo\bh̃AhXĂ|C^ */
	void setAddress(T* const pClass,LRESULT (T::* pAddress)(const HWND,const WPARAM,const LPARAM));

	LRESULT call(const HWND hwnd,const WPARAM wParam,const LPARAM lParam);
private:
	T* mpClass;///< Ăяo\bhĂNX̃CX^X̃|C^
	LRESULT (T::* mpAddress)(const HWND,const WPARAM,const LPARAM);///< Ăяoo\bh̃AhX
};

template<class T> WindowMessageImpl<T>::WindowMessageImpl()
{
	mpClass = NULL;
	mpAddress = NULL;
};

template<class T> WindowMessageImpl<T>::WindowMessageImpl(T* const pClass,LRESULT (T::* pAddress)(const HWND,const WPARAM,const LPARAM))
{
	mpClass = pClass;
	mpAddress = pAddress;
};


template<class T> void WindowMessageImpl<T>::setAddress(T* const pClass,LRESULT (T::* pAddress)(const HWND,const WPARAM,const LPARAM))
{
	mpClass = pClass;
	mpAddress = pAddress;
};

template<class T> LRESULT WindowMessageImpl<T>::call(const HWND hwnd,const WPARAM wParam,const LPARAM lParam)
{
	if(mpClass && mpAddress)
		return (mpClass->*mpAddress)(hwnd,wParam,lParam);
	return 0;
};

/// Win32 C^[tF[X
class SF_INTERFACE Win32  
{
public:
	/// RXgN^
	Win32(){};
	/// fXgN^
	virtual ~Win32(){};
	
	/// WinMain bp[ 
	virtual int winMain (const HINSTANCE hThisInstance, const HINSTANCE hPrevInstance,
			const LPSTR lpszCmdParam, const int nCmdShow) = 0;
	
	/** Window Message̓o^ 
	 * @param value WindowbZ[W
	 * @param pWindowMessage WindowMessagẽ|C^ */
	virtual const bool addWindowMessage(const DWORD value,WindowMessage * pWindowMessage) = 0;
	
};
	}
}

#endif // !defined(AFX_SYSTEMWIN32_H__9E630867_3321_4C17_8D1A_E0EAC93A1647__INCLUDED_)
