/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main;

import java.awt.Component;
import java.sql.SQLException;
import java.util.logging.Level;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/**
 * メッセージを画面とログに出力します。
 * 
 * @author sima
 * 
 */
public class ShowDialog {

	private static JFrame appjframe;

	public static void setJFrame(JFrame jframe) {
		appjframe = jframe;
	}
	/**
	 * 例外発生時のメッセージ出力。画面表示とログ出力を行います。画面表示は、SwingUtilities. invokeLaterを使用しEDTで実行されます。
	 * 
	 * @param t
	 *            例外
	 */
	public static void errorMessage(final Throwable t) {
		try {
			SQLException nextSqlException = null;
			if (t instanceof SQLException) {
				nextSqlException = ((SQLException) t).getNextException();
			}

			Jdbcacsess2.logger.log(Level.SEVERE, "ERROR", t);

			final String msg = t.toString() + (nextSqlException != null ? "\n" + nextSqlException.toString() : "");


			// EDT以外で呼ばれる事も想定し、EDTで実行する。
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					JOptionPane.showMessageDialog(appjframe, msg, "ERRORが発生しました", JOptionPane.ERROR_MESSAGE);
				}
			});
		} catch (Throwable e) {
			// ダイアログ表示時はエラーは全て握りつぶす
			e.printStackTrace();
		}
	}

	/**
	 * インフォレベルの画面表示。ログ出力も行います。画面表示は、SwingUtilities.invokeLaterを使用しEDTで実行されます。
	 * 
	 * @param message
	 *            メッセージ本文
	 * @param title
	 *            メッセージタイトル
	 */
	public static void infomationMessage(final Component component, final String message, final String title) {
		Jdbcacsess2.logger.info("(" + title + ")" + message);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JOptionPane.showMessageDialog(component, message, title, JOptionPane.INFORMATION_MESSAGE);
			}
		});
	}

	/**
	 * ワーニングレベルの画面表示。ログ出力も行います。画面表示は、SwingUtilities.invokeLaterを使用しEDTで実行されます。
	 * 
	 * @param message
	 *            メッセージ本文
	 * @param title
	 *            メッセージタイトル
	 */
	public static void warningMessage(final String message, final String title) {
		Jdbcacsess2.logger.warning("(" + title + ")" + message);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JOptionPane.showMessageDialog(null, message, title, JOptionPane.WARNING_MESSAGE);
			}
		});
	}
}
