import java.util.ArrayList;
import java.util.List;

public class Logger {
	public static final int TICK = 1;
	public static final int NUM_OF_MARISA = 0;
	public static final int NUM_OF_REIMU = 1;
	public static final int NUM_OF_ALICE = 2;
	public static final int NUM_OF_TARINAI = 3;
	public static final int NUM_OF_WASAREIMU= 4;
	public static final int NUM_OF_ETC_YUKKURI_TYPE = 5;
	public static final int NUM_OF_BABY = 6;
	public static final int NUM_OF_CHILD = 7;
	public static final int NUM_OF_ADULT = 8;
	public static final int NUM_OF_SICK = 9;
	public static final int NUM_OF_SHIT = 10;
	public static final int NUM_OF_LOGDATA_TYPE = 11;
	
	private static int[] prevLogData = new int[NUM_OF_LOGDATA_TYPE];
	private static int[] logDataSum = new int[NUM_OF_LOGDATA_TYPE];
	private static List<Integer> logList = new ArrayList<Integer>();

	public static void run(){
		
		int logData[] = new int[NUM_OF_LOGDATA_TYPE];

		for ( Body b : Terrarium.bodyList) {
			if ( !b.dead ){
				switch(b.getType()){
					case Marisa.type:
						logData[NUM_OF_MARISA]++;
						break;
						
					case Reimu.type:
						logData[NUM_OF_REIMU]++;
						break;

					case Alice.type:
						logData[NUM_OF_ALICE]++;
						break;

					case Tarinai.type:
						logData[NUM_OF_TARINAI]++;
						break;					

					case WasaReimu.type:
						logData[NUM_OF_WASAREIMU]++;	
						break;						
						
					default:
						logData[NUM_OF_ETC_YUKKURI_TYPE]++;	
						break;
				}

				switch(b.ageState){
					case BABY:
						logData[NUM_OF_BABY]++;
						break;

					case CHILD:
						logData[NUM_OF_CHILD]++;
						break;

					default:
					case ADULT:
						logData[NUM_OF_ADULT]++;
						break;
					}

				if ( b.sick == true ){
					logData[NUM_OF_SICK]++;
				}
			}
		}
			
		for ( Shit s : Terrarium.shitList) {
			logData[NUM_OF_SHIT]++;
		}

		for ( int i = 0 ; i < NUM_OF_LOGDATA_TYPE ; i++ ) {
			logList.add( logData[i] );
			logDataSum[i] += logData[i] - prevLogData[i];
			prevLogData[i] = logData[i];
		}
	}
	
	public static int getNumOfLogData(){
		return logList.size();
	}
	
	public static int[] getLog( int logRecord ){
		if (( logRecord >= 0 ) && ( NUM_OF_LOGDATA_TYPE * logRecord < logList.size() ) && ( logList.size() != 0 ) ){
			int[] logDataReturn = new int[NUM_OF_LOGDATA_TYPE];
			for ( int i = 0 ; i < NUM_OF_LOGDATA_TYPE ; i++ ) {
				logDataReturn[i] = logList.get(NUM_OF_LOGDATA_TYPE * ( logRecord ) + i );
			}
			return logDataReturn;
		}
		return null;
		
	}

	public static int[] getNumOfObjSumLog(){
		return logDataSum;
		
	}
	
	public static int[] getNumOfObjNowLog(){
		return prevLogData;
		
	}

	public static void clearLog(){
		logList.clear();
		run();
	}
}