class Marisa extends Body {
	@Override
	protected void showWantFood() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"͂񂵂̂ɂ̂", "͂񂵂̂ɂ̂", "͂񂳂̂ɂ̂"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"The shmell of mishder food, je!", "Smelled mishder food, je!", "It's the smell of mister food, ze!"};
			setMessage(messagesE[ageState]);
			break;
		}
	}
	
	@Override
	public void showNoFood() {
		if (toFood == false) {
			return;
		}
		toFood = false;
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"͂񂵂ɂႢI", "͂񂵂ɂႢɂ傶H΂Ȃ́Hɂ́H", "͂񂳂Ȃ̂H΂Ȃ́Hʂ́H"},
									{"͂񂵂񂩂āAAA", "͂񂵂񂩂āAAA", "͂񂳂񂪂łAAA"}};
			setMessage(messagesJ[damageState][ageState]);
			break;
		case ENGLISH:
			String messagesE[][] = {{"Mishder food ish nod here!", "Mishder food ish nod here, je! Are you shtoopid?  Wand choo die?", "Mister food is not here, ze?  Are you stupid? Want to die?"},
									{"Gib back mishder food...", "Gib back mishder food...", "Pwease give back mister food..."}};
			setMessage(messagesE[damageState][ageState]);
			break;
		}
		stay();
	}
	
	@Override
	protected void showExcite() {
		if (excitement) {
			switch (language) {
			case JAPANESE:
				setMessage("肶̂`I");
				break;
			case ENGLISH:
				setMessage("Want to refresh, ze~!");
				break;
			}
		}
	}

	@Override
	protected void showRelax() {
		if (rnd.nextInt(2) == 0) {
			switch (language) {
			case JAPANESE:
				String messagesJ[] = {"Ӂ[Ӂ[", "܂肿͂傤ɂ傶I", "܂肳͂傤Ȃ̂I"};
				setMessage(messagesJ[ageState], 30);
				break;
			case ENGLISH:
				String messagesE[] = {"Relax-relax~", "Mawisha ish da shdrongest, je!", "Marisa is the strongest, ze!"};
				setMessage(messagesE[ageState], 30);
				break;
			}
			furifuri = true;
			stay(30);
		}
		else {
			switch (language) {
			case JAPANESE:
				String messagesJ[] = {"肵ĂˁI", "肵ĂˁI", "肵ĂĂˁI"};
				setMessage(messagesJ[ageState]);
				break;
			case ENGLISH:
				String messagesE[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
				setMessage(messagesE[ageState]);
				break;
			}
			stay();
		}
	}
	
	@Override
	protected void showWakeup() {
		switch (language) {
		case JAPANESE:
			String messages[] = {"肵ĂˁI", "肵ĂˁI", "肵ĂĂˁI"};
			setMessage(messages[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
			setMessage(messagesE[ageState]);
			break;
		}
		stay();
	}

	@Override
	protected void showSleep() {
		if (sleep != 0) {
			switch (language) {
			case JAPANESE:
				setMessage("[₷[");
				break;
			case ENGLISH:
				setMessage("Sleep-Sleep---");
				break;
			}
		}		
	}
	
	@Override
	protected void showScream() {
		messageBuf = null; // show message immediately
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"[I", "ႢIՂ[̂I", "߂񂾂IՂ[I"},
									{"߂ɂ߂ɂAAA", "߂ɂႿႢ߂ˁAAA", "˂΂A߂łAAA"}};
			setMessage(messagesJ[damageState][ageState]);
			break;
		case ENGLISH:
			String messagesE[][] = {{"YUNYA-!!", "ID HURD!  Going choo pyuff-pyuff, je!", "Stop it, ze!  Puff, ze!"},
									{"Shdop id, shdop id...", "Mawisha ish showwy sho pwease shdop id...", "Pwease, sdop id pwease..."}};
			setMessage(messagesE[damageState][ageState]);
			break;
		}
		strike = true;
		stay();
	}
	
	@Override
	protected void showDieing() {
		messageBuf = null;	// show message immediately
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"ׂI", "ՂI", "ԂڂI"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Yubee!", "Puff!", "Blarf!"};
			setMessage(messagesE[ageState]);
			break;
		}
		stay();
	}
	
	@Override
	protected void showDead() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"ႩAAA", "ႩAAA", "Ƃ肵AAA"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Wanted choo chake id eajy more...", "Wanted choo chake id eajy more...", "Wanted to take it easy more..."};
			setMessage(messagesE[ageState]);
			break;
		}
	}
	
	@Override
	protected void showEating() {
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"ށ`ށ`A킿[", "ށ[ށ[A킿[", "ށ[ށ[A킹["},
									{"ނނAAA", "ނނA͂ӂ͂", "ނނA߂Ⴄ߂"}};
			setMessage(messagesJ[hungryState][ageState]);
			break;
		case ENGLISH:
			//Yoga Note* Check ͂ӂ͂
			String messagesE[][] = {{"Myunch-Myunch, happinesh~", "Myunch~ Myunch~ Happinesh~", "Munch munch, Happiness~"},
									{"Myunch myunch...", "Myunch Myunch, nom nom", "Munch munch, this shit's good, ze!"}};
			setMessage(messagesE[hungryState][ageState]);
			break;
		}
		eating = true;
		stay();
	}
	
	@Override
	protected void showFull() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"ɂႩςAAA", "ɂႩςAAA", "ׂȂ̂AAA"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Tummy ish full...", "Tummy ish full...", "Can't eat anymore ze..."};
			setMessage(messagesE[ageState]);
			break;
		}
		stay();
	}
	
	@Override
	protected void showHealing() {
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"݂Ⴀ݂I", "タ̂I", "肵̂I"},
									{"݂Ⴀ݂", "タ", "肵̂"}};
			setMessage(messagesJ[damageState][ageState]);
			break;
		case ENGLISH:
			String messagesE[][] = {{"Shweet-shweet!", "Weally eajy, je!", "Can take it easy, ze!"},
									{"Shweet-shweet", "Can chake id eajy", "Can take it easy, ze."}};
			setMessage(messagesE[damageState][ageState]);
			break;
		}
		stay();
	}
	
	@Override
	protected void showSukkiri() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"I", "I", "I"};
			setMessage(messagesJ[ageState], 30);
			break;
		case ENGLISH:
			String messagesE[] = {"Wefweshed!", "Wefeshed!", "Refreshed!"};
			setMessage(messagesE[ageState], 30);
			break;
		}
		sukkiri = true;
		stay(30);
	}
	
	@Override
	protected void showBirth() {
		switch (language) {
		case JAPANESE:
			setMessage("ĂˁI", 30);
			break;
		case ENGLISH:
			setMessage("Chake id eajy!", 30);
			break;
		}
		stay(30);
	}

	@Override
	protected void showShit() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"񂤂I", "܂肿̂[҂[񂤂񂿂Ⴂ݂ɂ傶I", "܂肳̂[ρ[񂤂񂽂ނ̂I"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Poo-pooing!", "Id'sh Mawisha's shuupa poo-poo time je!!", "It's Marisa's super poo-poo time, ze!"};
			setMessage(messagesE[ageState]);
			break;
		}
	}
	
	@Override
	protected void showShit2() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"I", "[I", "[I"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Wefeshed!", "Wefeshed-!!", "Refreshed~!"};
			setMessage(messagesE[ageState]);
			break;
		}
		furifuri = true;
		stay();
	}
	
	@Override
	protected void showSurisuri() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"肿", "[肿[", "[肷["};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Wub-wub", "Wub-wub", "Rub-rub"};
			setMessage(messagesE[ageState]);
			break;
		}
		stay();
	}

	@Override
	protected void showPeroPero() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"؂؂", "؁[؁[", "؁[؁["};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Wick-wick~", "Wick-wick~", "Lick-lick~"};
			setMessage(messagesE[ageState]);
			break;
		}
		peropero = true;
		stay();
	}
	
	@Override
	protected void showBreed() {
		switch (language) {
		case JAPANESE:
			setMessage("A΂AAA");
			break;
		case ENGLISH:
			setMessage("B...Being born...");
			break;
		}
	}
	
	@Override
	protected void showBreed2() {
		messageBuf = null;
		switch (language) {
		case JAPANESE:
			setMessage("肵ĂĂˁI");
			break;
		case ENGLISH:
			setMessage("Take it easy!");
			break;
		}
		furifuri = true;
		stay();
	}
	
	@Override
	public void showHateShit() {
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"ႢI", "񂤂񂭂ႢIガɂカI", "񂤂񂩂ÂĂˁIłI"},
									{"ႢAAA", "ႢAłɂႢAAA", "AłȂAAA"}};
			setMessage(messagesJ[damageState][ageState]);
			break;
		case ENGLISH:
			String messagesE[][] = {{"Shmelly~!", "Poo-poo shdinky!!  Help eajy!!", "Hurry up and save me from poo-poo!! Right now is fine!"},
									{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
			setMessage(messagesE[damageState][ageState]);
			break;
		}
	}
	
	@Override
	protected void showHungry() {
		switch (language) {
		case JAPANESE:
			String messagesJ[][] = {{"݂Ⴀ݂Ⴟ傤ႢI", "͂񂵂܂肵ɂĂ̂I", "͂񂳂܂肳ɂ悱̂IłI"},
									{"͂񂵂ǂH", "ɂႫւ̂AAA", "΂肴ɂ͂񂮂"}};
			setMessage(messagesJ[damageState][ageState]);
			break;
		case ENGLISH:
			String messagesE[][] = {{"Gib up shweet-shweets!", "Bwing mishder munch-munch choo Mawisha, je!", "Give up the mister munch-munch to Marisa!  A lot is fine!"},
									{"Where ish mishder food?", "Mishder tummy ish hungwy, je...", "Please give Marisa mister food..."}};
			setMessage(messagesE[damageState][ageState]);
			break;
		}
		stay();
	}
	
	@Override
	protected void showNoAccessory() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"䂥[IڂǂH", "䂥[I܂肿̂킢т傤ǂɂ̂H", "܂肳̂ڂǂȂ̂H"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"Yunn~! Where ish misder had?", "Yunn!! Where ish Mawisha's beaudiful mishder had, je?", "Where is Marisa's mister hat, ze?"};
			setMessage(messagesE[ageState]);
			break;
		}
	}
	
	@Override
	public void showHateYukkuri() {
		switch (language) {
		case JAPANESE:
			String messagesJ[] = {"łɂႢ", "łɂႢ̂", "łȂ肪̂ÎI"};
			setMessage(messagesJ[ageState]);
			break;
		case ENGLISH:
			String messagesE[] = {"There'sh a yukkuri that can'ch chake id eajy", "A yukkuri that can'ch chake id eajy, je", "A yukkuri that can't take it easy, ze!  Punishment time, ze!"};
			setMessage(messagesE[ageState]);
			break;
		}
	}

	// public methods
	public Marisa(int initX, int initY, int initAgeState, int language) {
		super(initX, initY,  Body.MARISA, initAgeState, language);
	}
}