import java.awt.Image;
import java.io.IOException;
import javax.imageio.*;

class Marisa extends Body implements java.io.Serializable {
	static final long serialVersionUID = 2L;
	public static final int type = 0;
	public static final String nameJ = "まりさ";
	public static final String nameE = "Marisa";

	private static Image[][][] images = new Image[NUM_OF_CONDITIONS][2][3];

	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/marisa/";

		// left face
		images[BODY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/body.png"));
		images[LICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/lick.png"));
		images[BRAID][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/braid.png"));
		images[ACCESSORY][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/hat.png"));
		images[DAMAGED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/damage.png"));
		images[PANTS][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/pants.png"));
		images[STAIN][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/shit.png"));
		images[SICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/sick.png"));
		images[NORMAL][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[SLEEPING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/sleeping.png"));
		images[CHEER][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/cheer.png"));
		images[SMILE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/smile.png"));
		images[TIRED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/tired.png"));
		images[PUFF][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/puff.png"));
		images[CRYING][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/crying.png"));
		images[EXCITING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/exciting.png"));
		images[REFRESHED][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/refreshed.png"));
		images[DEAD][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/dead.png"));
		images[RUDE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/rude.png"));
		// right face
		images[BODY][RIGHT][adultIndex] =		flipImage(images[BODY][LEFT][adultIndex]);
		images[LICK][RIGHT][adultIndex] =		flipImage(images[LICK][LEFT][adultIndex]);
		images[BRAID][RIGHT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"right/braid.png"));
		images[ACCESSORY][RIGHT][adultIndex] =	flipImage(images[ACCESSORY][LEFT][adultIndex]);
		images[DAMAGED][RIGHT][adultIndex] =	flipImage(images[DAMAGED][LEFT][adultIndex]);
		images[PANTS][RIGHT][adultIndex] =		flipImage(images[PANTS][LEFT][adultIndex]);
		images[STAIN][RIGHT][adultIndex] =		flipImage(images[STAIN][LEFT][adultIndex]);
		images[SICK][RIGHT][adultIndex] =		flipImage(images[SICK][LEFT][adultIndex]);		
		images[NORMAL][RIGHT][adultIndex] =		flipImage(images[NORMAL][LEFT][adultIndex]);
		images[SLEEPING][RIGHT][adultIndex] =	flipImage(images[SLEEPING][LEFT][adultIndex]);
		images[CHEER][RIGHT][adultIndex] =		flipImage(images[CHEER][LEFT][adultIndex]);
		images[SMILE][RIGHT][adultIndex] =		flipImage(images[SMILE][LEFT][adultIndex]);
		images[TIRED][RIGHT][adultIndex] =		flipImage(images[TIRED][LEFT][adultIndex]);
		images[PUFF][RIGHT][adultIndex] =		flipImage(images[PUFF][LEFT][adultIndex]);
		images[CRYING][RIGHT][adultIndex] =		flipImage(images[CRYING][LEFT][adultIndex]);
		images[EXCITING][RIGHT][adultIndex] =	flipImage(images[EXCITING][LEFT][adultIndex]);
		images[REFRESHED][RIGHT][adultIndex] =	flipImage(images[REFRESHED][LEFT][adultIndex]);
		images[DEAD][RIGHT][adultIndex] =		flipImage(images[DEAD][LEFT][adultIndex]);
		images[RUDE][RIGHT][adultIndex] =		flipImage(images[RUDE][LEFT][adultIndex]);
		// center
		images[CRUSHED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[CRUSHED2][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"crushed2.png"));			
		images[SHIT][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"shit.png"));
		images[ROLL_ACCESSORY][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"hat.png"));
		images[ROLL_SHIT][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_left.png"));
		images[ROLL_SHIT][RIGHT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_right.png"));
		images[PANTS2][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"pants.png"));
		images[PANTS2_ROLL][LEFT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"left_pants.png"));
		images[PANTS2_ROLL][RIGHT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"right_pants.png"));

		for(Image[][] array2d : images) {	
			for(Image[] array : array2d) {
				if(array[adultIndex] == null) {
					continue;
				}
				// Scale larger images down
				array[adultIndex] = array[adultIndex].getScaledInstance(adultSize, adultSize, Image.SCALE_AREA_AVERAGING);
				array[childIndex] = array[adultIndex].getScaledInstance(childSize, childSize, Image.SCALE_AREA_AVERAGING);
				array[babyIndex] =  array[adultIndex].getScaledInstance(babySize, babySize, Image.SCALE_AREA_AVERAGING);
			}
		}
	}

	public Image getImage(int type, int direction) {
		return images[type][direction][ageState.ordinal()];
	}

	@Override
	public int getType() {
		return type;
	}

	@Override
	public int getHybridType(int partnerType) {
		switch (partnerType) {
		case Reimu.type:
			return ReimuMarisa.type;
		default:
			return Marisa.type;
		}
	}

	@Override
	public String getNameJ() {
		return nameJ;
	}

	@Override
	public String getNameE() {
		return nameE;
	}

	@Override
	protected String msgWantFoodJ () {
		String[] output = {"ごはんしゃんのにおいがしゅりゅのじぇ", "ごはんしゃんのにおいがするのじぇ", "ごはんさんのにおいがするのぜ"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgWantFoodE () {
		String[] output = {"The shmell of mishder food, je!", "Smelled mishder food, je!", "It's the smell of mister food, ze!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgNoFoodJ()
	{
		if (!isRudeMessage()) {
			String[][] output = {{"ごはんしゃんにゃいよ！", "ごはんしゃんにゃいにょじぇ？", "ごはんさんがないのぜ？"},
					{"ごはんしゃんくだちゃい、、、", "ごはんしゃんくだちゃい、、、", "ごはんざんぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ごはんしゃんにゃいよ！", "ごはんしゃんにゃいにょじぇ？ばきゃなの？しにゅの？", "ごはんさんないのぜ？ばかなの？しぬの？"},
					{"ごはんしゃんくだちゃい、、、", "ごはんしゃんくだちゃい、、、", "ごはんざんぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgNoFoodE()
	{
		String[][] output = {{"Mishder food ish nod here!", "Mishder food ish nod here, je! Are you shtoopid?  Wand choo die?", "Mister food is not here, ze?  Are you stupid? Want to die?"},
				{"Gib back mishder food...", "Gib back mishder food...", "Pwease give back mister food..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgExciteJ() {
		if (!isRudeMessage()) {
			String output[] = {"ゆんやー!", "まりちゃのぺにぺにですっきちさせるのじぇ!", "まりさのぺにぺにですっきりさせてやるのぜ！"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"ゆんやー!", "まりちゃのびっぐまぐなむでひーひーいわせりゅのじぇ!", "まりささまのびっぐまぐなむでひーひーいわせるのぜ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgExciteE() { return "Want to refresh, ze~!"; }

	@Override
	protected String msgRelaxE()
	{
		String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgRelaxJ()
	{
		if (!isRudeMessage()) {
			String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"くしょどれいはちね！", "あまあまよこしぇ！", "まりささまにあまあまをけんっじょうするのぜ！"};
			return output[ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgFuriFuriJ()
	{
		if (!isRudeMessage()) {
			String output[] = {"ふーりふーり！ゆっくちー！", "まりちゃはさいっきょうにょじぇ！", "まりさはさいっきょうなのぜ！"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"ふーりふーり！ゆっくちー！", "まりちゃはさいっきょうなにょじぇ！", "まりささまはさいっきょうなのぜ！"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgFuriFuriE()
	{
		String output[] = {"Relax-relax~", "Mawisha ish da shdrongest, je!", "Marisa is the strongest, ze!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgWakeupJ()
	{
		String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgWakeupE()
	{
		String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSleepJ() { return "すーやすーや"; }

	@Override
	protected String msgSleepE() { return "Sleep-Sleep---"; }

	@Override
	protected String msgScreamJ() {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆんやー！", "いちゃい！やめりゅのじぇ！", "いたい！やめるんだぜ！ぷくーだぜ！"},
					{"ゆ、ゆ、ゆ、、、", "やめちぇねやめちぇね、、、", "おねがいじばず、やめでぐだざい、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ゆんやー！", "いちゃい！ぷきゅーするのじぇ！", "いたい！まりささまになにをするのぜ！ぷくーだぜ！"},
					{"ゆ、ゆ、ゆ、、、", "ごめんにゃちゃいやめちぇね、、、", "おねがいじばず、ごめんなさい、やめでぐだざい、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgScreamE() {
		String[][] output = {{"YUNYA-!!", "ID HURD!  Going choo pyuff-pyuff, je!", "Stop it, ze!  Puff, ze!"},
				{"Shdop id, shdop id...", "Mawisha ish showwy sho pwease shdop id...", "Pwease, sdop id pwease..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgScareJ () {
		String[][] output = {{"ゆんやー！", "ゆっくちできにゃいのじぇー！", "ゆっくりできないのぜ！"},
				{"やめちぇにぇやめちぇにぇ、、、", "ごめんにゃちゃいやめちぇね、、、", "おねがいじばず、やめでぐだざい、、、"}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgScareE () {
		String[][] output = {{"YUNYA-!!", "I can'ch chake id eajy, je!", "I can't take it easy, ze!"},
				{"Shdop id, shdop id...", "Mawisha ish showwy sho pwease shdop id...", "Pwease, sdop id pwease..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgAlarmJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"にゃんだかゆっくちできにゃいのじぇ！", "にゃんだかゆっくちできにゃいのじぇ！", "やめるんだぜ！ぷくーだぜ！"},
					{"やめちぇにぇやめちぇにぇ、、、", "ごめんにゃちゃいやめちぇね、、、", "おねがいじばず、やめでぐだざい、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"やめりょくしょどれい！", "やめりょくしょどれい！しぇいしゃいしゅりゅよ！", "くそどれいはいますぐやめるんだぜ！せいっさいするのぜ！"},
					{"やめちぇにぇやめちぇにぇ、、、", "ごめんにゃちゃいやめちぇね、、、", "おねがいじばず、やめでぐだざい、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgAlarmE () {
		String[][] output = {{"I can'ch chake id eajy, je!", "I can'ch chake id eajy, je!", "Stop it, ze!  Puff, ze!"},
				{"Shdop id, shdop id...", "Mawisha ish showwy sho pwease shdop id...", "Pwease, sdop id pwease..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	protected String msgDyingJ () {
		String[] output = {"ゆべっ！", "ゆ、ゆ、ゆ、、、", "ぶぼっ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDyingE () {
		String[] output = {"Yubee!", "Puff!", "Blarf!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadJ () {
		String[] output = {"もっちょゆっくちしちゃかった、、、", "もっちょゆっくちしちゃかった、、、", "もっとゆっくりしたかった、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadE () {
		String[] output = {"Wanted choo chake id eajy more...", "Wanted choo chake id eajy more...", "Wanted to take it easy more..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"む〜ちゃむ〜ちゃ、ゆー", "むーちゃむーちゃ、ちあわちぇー！", "むーしゃむーしゃ、しあわせー！"},
					{"むっちゃむっちゃ、ゆー！", "むちゃむちゃ、はふはふ！", "むーしゃむーしゃ、めっちゃうめぇ！"}};
			return output[hungryState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"む〜ちゃむ〜ちゃ、ゆー", "むーちゃむーちゃ、それなりー！", "むーしゃむーしゃ、それなりー！"},
					{"むっちゃむっちゃ、ゆー！", "むっちゃむっちゃ、はふはふ！", "むーしゃむーしゃ、これめっちゃうめぇ！"}};
			return output[hungryState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgEatingE () {
		String[][] output = {{"Myunch-Myunch, happinesh~", "Myunch~ Myunch~ Happinesh~", "Munch munch, Happiness~"},
				{"Myunch myunch...", "Myunch Myunch, nom nom", "Munch munch, this shit's good, ze!"}};
		return output[hungryState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgEatingShitJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、げりょまじゅ、、、", "むーちゃむーちゃ、げろまじゅ、、、", "むーしゃむーしゃ、げろまず、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingShitE () {
		String[] output = {"Myunch-Myunch, disgusting,,,", "Myunch~ Myunch~ disgusting,,,", "Munch munch, disgusting,,,"};
		return output[ageState.ordinal()];
	}
	
	@Override
	protected String msgEatingBitterJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、こりぇどきゅはいっちぇりゅ！", "むーちゃむーちゃ、こりぇどきゅはいっちぇりゅ！", "むーしゃむーしゃ、これどくはいってるのぜ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingBitterE () {
		String[] output = {"Myunch-Myunch, this is poison!", "Myunch~ Myunch~ this is poison!", "Munch munch, this is poison!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullJ () {
		String[] output = {"おにゃかいっぱい、、、", "おにゃかいっぱい、、、", "もうたべられないのぜ、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullE () {
		String[] output = {"Tummy ish full...", "Tummy ish full...", "Can't eat anymore ze..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHealingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"あみゃあみゃ！", "あまあまおいちぃ！", "あまあまおいしいのぜ！"},
					{"あみゃあみゃ！", "ふっきゃつしちゃのじぇ", "ふっかつしたのぜ"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゃあみゃ！", "あまあまもっちょよこしゅのじぇ！", "あまあまもっとよこすのぜ！"},
					{"あみゃあみゃ！", "まりちゃはふっきゃつしちゃのじぇ！", "まりささまはかれいにふっかつしたのぜ！"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgHealingE () {
		String[][] output = {{"Shweet-shweet!", "Weally eajy, je!", "Can take it easy, ze!"},
				{"Shweet-shweet", "Can chake id eajy", "Can take it easy, ze."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgSukkiriJ () {
		String[] output = {"ちゅっきち！", "ちゅっきり！", "すっきり！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSukkiriE () {
		String[] output = {"Wefweshed!", "Wefeshed!", "Refreshed!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBirthJ () { return "ゆっくちちていっちぇね！"; }

	@Override
	protected String msgBirthE () { return "Chake id eajy!"; }

	@Override
	protected String msgShitJ () {
		if (!hasPants) {
			if (!isRudeMessage()) {
				String[] output = {"うんうんぢぇりゅ！", "まりちゃのすーぴゃーうんうんちゃいみゅにょじぇ！", "まりさのすーぱーうんうんたいむのぜ！"};
				return output[ageState.ordinal()];
			}
			else {
				String[] output = {"うんうんぢぇりゅ！", "くしょじょれいはまりちゃのうんうんくらうにょじぇ！", "くそどれいはまりささまのうんうんくらうのぜ！"};
				return output[ageState.ordinal()];
			}
		}
		else {
			String[] output = {"うんうんもりぇりゅのじぇぇ！", "うんうんしゃんもれりゅのじぇぇ！", "うんうんさんもれちゃうのぜぇ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShitE () {
		if (!hasPants) {
			String[] output = {"Poo-pooing!", "Id'sh Mawisha's shuupa poo-poo time je!!", "It's Marisa's super poo-poo time, ze!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Poo-poo Maricha's pants je!", "Poo-poo Marisha's pants je!", "Leaking Mr.poo-poo ze!"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShit2J () {
		if (!hasPants) {
			String[] output = {"すっきち！", "すっきちー！", "すっきりー！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆんやー！", "ゆんやー！", "きもちわるいのぜ、、、"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgShit2E () {
		if (!hasPants) {
			String[] output = {"Wefeshed!", "Wefeshed-!!", "Refreshed~!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Yun ya-!", "Yun ya-!", "Yuuu,,,"};
			return output[ageState.ordinal()];
		}
	}
	
	@Override
	protected String msgSuriSuriJ () {
		String[] output = {"ちゅりちゅり", "ちゅーりちゅーり", "すーりすーり"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSuriSuriE () {
		String[] output = {"Wub-wub", "Wub-wub", "Rub-rub"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroJ () {
		String[] output = {"ぺりょぺりょ", "ぺーりょぺーりょ", "ぺーろぺーろ"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroE () {
		String[] output = {"Wick-wick~", "Wick-wick~", "Lick-lick~"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBreedJ () { return "う、おちびがうばれるのぜ、、、"; }

	@Override
	protected String msgBreedE () { return "B...Being born..."; }

	@Override
	protected String msgBreed2J () {
		if (!hasPants) {
			return "ゆっくりしていってね！";
		}
		else {
			return "ゆがあぁ！おちびがあぁぁ！";
		}
	}

	@Override
	protected String msgBreed2E () {
		if (!hasPants) {
			return "Take it easy!";
		}
		else {
			return "Yugaa! My little one!";
		}
	}

	@Override
	protected String msgHateShitJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"くちゃい〜！", "うんうんくちゃい！", "うんうんかたづけてね！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないよ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"くちゃい！", "しゅぎゅにうんうんかたじゅきぇるのじぇ！", "くそどれいはすぐにうんうんかたづけるのぜ！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないよ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgHateShitE () {
		String[][] output = {{"Shmelly~!", "Poo-poo shdinky!!  Help eajy!!", "Hurry up and save me from poo-poo!! Right now is fine!"},
				{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgHungryJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"あみゃあみゃちょうじゃい！", "ごはんしゃんまりしゃにちょうだいのじぇ！", "まりさはごはんさんほしいのぜ！"},
					{"ごはんしゃんどきょ？", "おにゃきゃへっちゃのじぇ、、、", "ばりざにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゃあみゃもっちぇこい！", "すぎゅにごはんしゃんもってきゅるのじぇ！", "くそどれいはごはんさんまりさによこすのぜ！たくさんでいいよ！"},
					{"ごはんしゃんどきょ？", "おにゃきゃへっちゃのじぇ、、、", "ばりざにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHungryE () {
		String[][] output = {{"Gib up shweet-shweets!", "Bwing mishder munch-munch choo Mawisha, je!", "Give up the mister munch-munch to Marisa!  A lot is fine!"},
				{"Where ish mishder food?", "Mishder tummy ish hungwy, je...", "Please give Marisa mister food..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgNoAccessoryJ () {
		String[] output = {"ゆぇーん！かえちてね？かえちてね？", "ゆぇーん！まりちゃのしゅてきなおぼうししゃんかえちてね？", "まりさのくろくそびえたつおぼうしさんはどこなのぜ？"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgNoAccessoryE () {
		String[] output = {"Yunn~! Where ish misder had?", "Yunn!! Where ish Mawisha's beaudiful mishder had, je?", "Where is Marisa's mister hat, ze?"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHateYukkuriJ () {
		if (!isRudeMessage()) {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくちできにゃいゆっくちがいりゅのじぇ", "ゆっくりできないゆっくりがいるのぜ！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆへへ、ゆっくちできにゃいゆっくちがいりゅのじぇ", "ゆへへ、ゆっくりできないゆっくりがいるのぜ！せいっさいするのぜ！"};
			return output[ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgHateYukkuriE () {
		String[] output = {"There'sh a yukkuri that can'ch chake id eajy", "A yukkuri that can'ch chake id eajy, je", "A yukkuri that can't take it easy, ze!  Punishment time, ze!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFlyingJ () {
		String[] output = {"おちょらをとんでりゅみちゃいのじぇ！", "まりちゃはおしょらをせいふくしたのじぇ！", "まりさはおそらをせいふくしたのぜ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFlyingE () {
		String[] output = {"Ich feewsh wike fwying, je!", "Maricha conquered shky, je!", "Marisa conquered the sky, ze!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSadnessForChildJ() {
		return "おちびしぬんじゃないのぜ！";
	}

	@Override
	protected String msgSadnessForChildE() {
		return "Don't die, my little one, ze!";
	}

	@Override
	protected String msgSadnessForPartnerJ(Body partner) {
		return partner.getNameJ() + "めをあけるのぜ！";
	}

	@Override
	protected String msgSadnessForPartnerE (Body partner) {
		return "Open your eyes," + partner.getNameE() + ", ze!";
	}
	
	@Override
	protected String msgBlockedByWallJ () {
		if (!isRudeMessage()) {
			String[] output = {"まりちゃしゅしゅめにゃいにょじぇぇぇ！？", "にゃんでかべしゃんじゃましゅるにょじぇぇぇ！？", "なんでかべさんじゃまするのぜ！？"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"くちょかびぇはちね！！", "くちょかべはちね！！ぷきゅーじゃよ！！", "じゃまなかべさんはどくのぜ！すぐでいいよ！"};
			return output[ageState.ordinal()];
		}
	}
	
	@Override
	protected String msgBlockedByWallE () {
		String[] output = {"Maricha can'ch go forward!?", "Why would mishter Wall block me, je!?", "Why would mister Wall block me, ze!?"};
		return output[ageState.ordinal()];
	}
	
	// Constructor of this class.
	public Marisa(int initX, int initY, int initZ, Body.AgeState initAgeState, Body p1, Body p2) {
		super(initX, initY, initZ, initAgeState, p1, p2);
	}
	
	public void tuneParameters() {
		// Tune individual parameters.
		double factor = Math.random()+1;
		HUNGRYLIMIT[AgeState.ADULT.ordinal()] *= factor; 
		HUNGRYLIMIT[AgeState.CHILD.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+1;
		SHITLIMIT[AgeState.ADULT.ordinal()] *= factor;
		SHITLIMIT[AgeState.CHILD.ordinal()] *= factor;
		SHITLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()*2+1;
		DAMAGELIMIT[AgeState.ADULT.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.CHILD.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		BABYLIMIT *= factor;
		CHILDLIMIT *= factor;
		LIFELIMIT *= factor;
		factor = Math.random()+1;
		RELAXPERIOD *= factor;
		EXCITEPERIOD *= factor;
		PREGPERIOD *= factor;
		SLEEPPERIOD *= factor;
		ACTIVEPERIOD *= factor;
		sameDest = rnd.nextInt(10)+10;
		DECLINEPERIOD *= (Math.random()+0.5);
		DISCIPLINELIMIT *= (Math.random()+1);
		ROBUSTNESS = rnd.nextInt(10)+2;
		EYESIGHT /= 1;
		factor = Math.random()+1;
		STRENGTH[AgeState.ADULT.ordinal()] *= factor;
		STRENGTH[AgeState.CHILD.ordinal()] *= factor;
		STRENGTH[AgeState.BABY.ordinal()] *= factor;
	}
}