package demo.soba;

import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.util.files.ClasspathUtil;

public class DumpDataFlowEdge {

	public static void main(String[] args) {
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		for (ClassInfo c: program.getClasses()) {
			for (MethodInfo m: c.getMethods()) {
				System.out.println(m.toLongString());
				DataDependence dd = m.getDataDependence();
				for (DataFlowEdge e: dd.getEdges()) {
					System.out.println(e.toString());
				}
			}
		}
	}

}
