package demo.soba;

import demo.util.MemoryInfo;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.util.files.ClasspathUtil;

public class DataDependencePerformance {

	public static void main(String[] args) {
		args = new String[]{"bin/demo/testdata"};
		
		long start = System.currentTimeMillis();
		
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		for (ClassInfo c: program.getClasses()) {
			for (MethodInfo m: c.getMethods()) {
				DataDependence dd = m.getDataDependence();
				for (DataFlowEdge e: dd.getEdges()) {
//					System.out.println(e.toString());
				}
			}
		}
		
		long end = System.currentTimeMillis();
		
		System.out.println((end - start) + " [ms]");
		System.out.println(MemoryInfo.getMemoryInfo());
	}

}
