package demo.wala;

import java.util.Iterator;

import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;

import demo.util.DemoUtil;

public class ControlDependenceBasicBlockPeformance {

	public static void main(String[] args) {
		try {
			String appJar = "bin/demo/testdata";
			
			AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, (new FileProvider()).getFile(DemoUtil.REGRESSION_EXCLUSIONS));

			ClassHierarchy cha = ClassHierarchy.make(scope);

			for (Iterator<IClass> itr = cha.iterator(); itr.hasNext();) {
				IClass c = itr.next();
				for (IMethod m: c.getAllMethods()) {
					AnalysisOptions options = new AnalysisOptions();
					options.getSSAOptions().setPiNodePolicy(SSAOptions.getAllBuiltInPiNodes());
					AnalysisCache cache = new AnalysisCache();
					IR ir = cache.getSSACache().findOrCreateIR(m, Everywhere.EVERYWHERE, options.getSSAOptions() );
					if (ir == null) {
						Assertions.UNREACHABLE("Null IR for " + m);
					}
					ControlDependenceGraph<SSAInstruction, ISSABasicBlock> cdg = new ControlDependenceGraph<>(ir.getControlFlowGraph());
					for (int i = 0; i < cdg.getMaxNumber(); i++) {
						ISSABasicBlock b1 = cdg.getNode(i);
						for (Iterator<ISSABasicBlock> succs = cdg.getSuccNodes(b1); succs.hasNext();) {
							ISSABasicBlock b2 = succs.next();
//							System.out.println(b1.toString() + " -> " + b2.toString());
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
