package demo.wala;

import java.util.Iterator;

import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;

import demo.util.DemoUtil;
import demo.util.MemoryInfo;

public class ClassHierarchyPerformance {

	public static void main(String[] args) {
		try {
			long start = System.currentTimeMillis();
			
			String appJar = "bin/demo/testdata";
			AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(appJar, (new FileProvider()).getFile(DemoUtil.REGRESSION_EXCLUSIONS));

			ClassHierarchy cha = ClassHierarchy.make(scope);

			Iterable<Entrypoint> entrypoints = com.ibm.wala.ipa.callgraph.impl.Util.makeMainEntrypoints(scope, cha);
			AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
			com.ibm.wala.ipa.callgraph.CallGraphBuilder builder = Util.makeZeroCFABuilder(options, new AnalysisCache(), cha, scope);
			CallGraph cg = builder.makeCallGraph(options, null);

			for (int i = 0; i < cg.getMaxNumber(); i++) {
				CGNode caller = cg.getNode(i);
				for (Iterator<CGNode> callees = cg.getSuccNodes(caller); callees.hasNext();) {
					CGNode callee = callees.next();
//					System.out.println(caller.getMethod().toString() + " -> " + callee.getMethod().toString());
				}
			}
			
			long end = System.currentTimeMillis();
			
			System.out.println((end - start) + " [ms]");
			System.out.println(MemoryInfo.getMemoryInfo());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
